/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class SchemaQueryOrderByHeatOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private boolean isFinished = false;
    private final List<Operator> operators;
    private final boolean[] noMoreTsBlocks;
    private final List<TsBlock> showTimeSeriesResult;
    private final List<TsBlock> lastQueryResult;

    public SchemaQueryOrderByHeatOperator(OperatorContext operatorContext, List<Operator> operators) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.operators = operators;
        this.noMoreTsBlocks = new boolean[operators.size()];
        this.showTimeSeriesResult = new ArrayList<TsBlock>();
        this.lastQueryResult = new ArrayList<TsBlock>();
    }

    @Override
    public TsBlock next() {
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(HeaderConstant.showTimeSeriesHeader.getRespDataTypes());
        HashMap<String, Long> timeseriesToLastTimestamp = new HashMap<String, Long>();
        for (TsBlock tsBlock : this.lastQueryResult) {
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                String timeseries = tsBlock.getColumn(0).getBinary(i).toString();
                long time = tsBlock.getTimeByIndex(i);
                timeseriesToLastTimestamp.put(timeseries, time);
            }
        }
        HashMap lastTimestampToTsSchema = new HashMap();
        for (TsBlock tsBlock : this.showTimeSeriesResult) {
            TsBlock.TsBlockRowIterator tsBlockRowIterator = tsBlock.getTsBlockRowIterator();
            while (tsBlockRowIterator.hasNext()) {
                Object[] line = tsBlockRowIterator.next();
                String timeseries = line[0].toString();
                long time = timeseriesToLastTimestamp.getOrDefault(timeseries, 0L);
                if (!lastTimestampToTsSchema.containsKey(time)) {
                    lastTimestampToTsSchema.put(time, new ArrayList());
                }
                ((List)lastTimestampToTsSchema.get(time)).add(line);
            }
        }
        ArrayList arrayList = new ArrayList(lastTimestampToTsSchema.keySet());
        arrayList.sort(Comparator.reverseOrder());
        for (Long time : arrayList) {
            List rows = (List)lastTimestampToTsSchema.get(time);
            for (Object[] row : rows) {
                tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
                for (int i = 0; i < HeaderConstant.showTimeSeriesHeader.getRespDataTypes().size(); ++i) {
                    Object value = row[i];
                    if (null == value) {
                        tsBlockBuilder.getColumnBuilder(i).appendNull();
                        continue;
                    }
                    tsBlockBuilder.getColumnBuilder(i).writeBinary(new Binary(value.toString()));
                }
                tsBlockBuilder.declarePosition();
            }
        }
        return tsBlockBuilder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        for (int i = 0; i < this.operators.size(); ++i) {
            if (this.noMoreTsBlocks[i]) continue;
            Operator operator = this.operators.get(i);
            ListenableFuture<?> blocked = operator.isBlocked();
            while (operator.hasNext() && blocked.isDone()) {
                TsBlock tsBlock = operator.next();
                if (null != tsBlock && !tsBlock.isEmpty()) {
                    if (this.isShowTimeSeriesBlock(tsBlock)) {
                        this.showTimeSeriesResult.add(tsBlock);
                    } else {
                        this.lastQueryResult.add(tsBlock);
                    }
                }
                blocked = operator.isBlocked();
            }
            if (!blocked.isDone()) {
                return blocked;
            }
            this.noMoreTsBlocks[i] = true;
        }
        return NOT_BLOCKED;
    }

    private boolean isShowTimeSeriesBlock(TsBlock tsBlock) {
        return tsBlock.getValueColumnCount() == HeaderConstant.showTimeSeriesHeader.getOutputValueColumnCount();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public void close() throws Exception {
        for (Operator operator : this.operators) {
            operator.close();
        }
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }
}

