/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaEntityNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaInternalNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.mpp.common.schematree.visitor.SchemaTreeDeviceVisitor;
import org.apache.iotdb.db.mpp.common.schematree.visitor.SchemaTreeMeasurementVisitor;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SchemaTree {
    private List<String> storageGroups;
    private final SchemaNode root;

    public SchemaTree() {
        this.root = new SchemaInternalNode("root");
    }

    public SchemaTree(SchemaNode root) {
        this.root = root;
    }

    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch) {
        SchemaTreeMeasurementVisitor visitor = new SchemaTreeMeasurementVisitor(this.root, pathPattern, slimit, soffset, isPrefixMatch);
        return new Pair(visitor.getAllResult(), (Object)visitor.getNextOffset());
    }

    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern) {
        SchemaTreeMeasurementVisitor visitor = new SchemaTreeMeasurementVisitor(this.root, pathPattern, IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum() + 1, 0, false);
        return new Pair(visitor.getAllResult(), (Object)visitor.getNextOffset());
    }

    public List<MeasurementPath> getAllMeasurement() {
        return (List)this.searchMeasurementPaths((PartialPath)MetadataConstant.ALL_MATCH_PATTERN, (int)0, (int)0, (boolean)false).left;
    }

    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) {
        SchemaTreeDeviceVisitor visitor = new SchemaTreeDeviceVisitor(this.root, pathPattern, isPrefixMatch);
        return visitor.getAllResult();
    }

    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern) {
        SchemaTreeDeviceVisitor visitor = new SchemaTreeDeviceVisitor(this.root, pathPattern, false);
        return visitor.getAllResult();
    }

    public DeviceSchemaInfo searchDeviceSchemaInfo(PartialPath devicePath, List<String> measurements) {
        String[] nodes = devicePath.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                return null;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur == null) {
            return null;
        }
        ArrayList<SchemaMeasurementNode> measurementNodeList = new ArrayList<SchemaMeasurementNode>();
        for (String measurement : measurements) {
            SchemaNode node = cur.getChild(measurement);
            if (node == null) {
                measurementNodeList.add(null);
                continue;
            }
            measurementNodeList.add(node.getAsMeasurementNode());
        }
        return new DeviceSchemaInfo(devicePath, cur.getAsEntityNode().isAligned(), measurementNodeList);
    }

    public void appendMeasurementPaths(List<MeasurementPath> measurementPathList) {
        for (MeasurementPath measurementPath : measurementPathList) {
            this.appendSingleMeasurementPath(measurementPath);
        }
    }

    private void appendSingleMeasurementPath(MeasurementPath measurementPath) {
        this.appendSingleMeasurement(measurementPath, (MeasurementSchema)measurementPath.getMeasurementSchema(), measurementPath.isMeasurementAliasExists() ? measurementPath.getMeasurementAlias() : null, measurementPath.isUnderAlignedEntity());
    }

    public void appendSingleMeasurement(PartialPath path, MeasurementSchema schema, String alias, boolean isAligned) {
        String[] nodes = path.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            SchemaEntityNode entityNode;
            SchemaNode child = cur.getChild(nodes[i]);
            if (child == null) {
                if (i == nodes.length - 1) {
                    SchemaMeasurementNode measurementNode = new SchemaMeasurementNode(nodes[i], schema);
                    if (alias != null) {
                        measurementNode.setAlias(alias);
                        cur.getAsEntityNode().addAliasChild(alias, measurementNode);
                    }
                    child = measurementNode;
                } else if (i == nodes.length - 2) {
                    entityNode = new SchemaEntityNode(nodes[i]);
                    entityNode.setAligned(isAligned);
                    child = entityNode;
                } else {
                    child = new SchemaInternalNode(nodes[i]);
                }
                cur.addChild(nodes[i], child);
            } else if (i == nodes.length - 2 && !child.isEntity()) {
                entityNode = new SchemaEntityNode(nodes[i]);
                cur.replaceChild(nodes[i], entityNode);
                child = entityNode;
            }
            cur = child;
        }
    }

    public void mergeSchemaTree(SchemaTree schemaTree) {
        this.traverseAndMerge(this.root, null, schemaTree.root);
    }

    private void traverseAndMerge(SchemaNode thisNode, SchemaNode thisParent, SchemaNode thatNode) {
        for (SchemaNode thatChild : thatNode.getChildren().values()) {
            SchemaNode thisChild = thisNode.getChild(thatChild.getName());
            if (thisChild == null) {
                SchemaMeasurementNode measurementNode;
                SchemaEntityNode entityNode;
                thisNode.addChild(thatChild.getName(), thatChild);
                if (!thatChild.isMeasurement()) continue;
                if (thisNode.isEntity()) {
                    entityNode = thisNode.getAsEntityNode();
                } else {
                    entityNode = new SchemaEntityNode(thisNode.getName());
                    thisParent.replaceChild(thisNode.getName(), entityNode);
                    thisNode = entityNode;
                }
                if (!entityNode.isAligned()) {
                    entityNode.setAligned(thatNode.getAsEntityNode().isAligned());
                }
                if ((measurementNode = thatChild.getAsMeasurementNode()).getAlias() == null) continue;
                entityNode.addAliasChild(measurementNode.getAlias(), measurementNode);
                continue;
            }
            this.traverseAndMerge(thisChild, thisNode, thatChild);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.root.serialize(outputStream);
    }

    public static SchemaTree deserialize(InputStream inputStream) throws IOException {
        ArrayDeque<SchemaNode> stack = new ArrayDeque<SchemaNode>();
        while (inputStream.available() > 0) {
            byte nodeType = ReadWriteIOUtils.readByte((InputStream)inputStream);
            if (nodeType == 2) {
                SchemaMeasurementNode measurementNode = SchemaMeasurementNode.deserialize(inputStream);
                stack.push(measurementNode);
                continue;
            }
            SchemaInternalNode internalNode = nodeType == 1 ? SchemaEntityNode.deserialize(inputStream) : SchemaInternalNode.deserialize(inputStream);
            for (int childNum = ReadWriteIOUtils.readInt((InputStream)inputStream); childNum > 0; --childNum) {
                SchemaMeasurementNode measurementNode;
                SchemaNode child = (SchemaNode)stack.pop();
                internalNode.addChild(child.getName(), child);
                if (!child.isMeasurement() || (measurementNode = child.getAsMeasurementNode()).getAlias() == null) continue;
                internalNode.getAsEntityNode().addAliasChild(measurementNode.getAlias(), measurementNode);
            }
            stack.push(internalNode);
        }
        return new SchemaTree((SchemaNode)stack.poll());
    }

    public String getBelongedStorageGroup(String pathName) {
        for (String storageGroup : this.storageGroups) {
            if (!PathUtils.isStartWith((String)pathName, (String)storageGroup)) continue;
            return storageGroup;
        }
        throw new RuntimeException("No matched storage group. Please check the path " + pathName);
    }

    public String getBelongedStorageGroup(PartialPath path) {
        return this.getBelongedStorageGroup(path.getFullPath());
    }

    public List<String> getStorageGroups() {
        return this.storageGroups;
    }

    public void setStorageGroups(List<String> storageGroups) {
        this.storageGroups = storageGroups;
    }

    SchemaNode getRoot() {
        return this.root;
    }

    public boolean isEmpty() {
        return this.root.getChildren() == null || this.root.getChildren().size() == 0;
    }
}

