/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class AvgAccumulator
implements Accumulator {
    private TSDataType seriesDataType;
    private long countValue;
    private double sumValue;
    private boolean initResult = false;

    public AvgAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
    }

    @Override
    public int addInput(Column[] column, TimeRange timeRange) {
        switch (this.seriesDataType) {
            case INT32: {
                return this.addIntInput(column, timeRange);
            }
            case INT64: {
                return this.addLongInput(column, timeRange);
            }
            case FLOAT: {
                return this.addFloatInput(column, timeRange);
            }
            case DOUBLE: {
                return this.addDoubleInput(column, timeRange);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 2 ? 1 : 0) != 0, (Object)"partialResult of Avg should be 2");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.initResult = true;
        this.countValue += partialResult[0].getLong(0);
        this.sumValue += partialResult[1].getDouble(0);
        if (this.countValue == 0L) {
            this.initResult = false;
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.initResult = true;
        this.countValue += statistics.getCount();
        this.sumValue = statistics instanceof IntegerStatistics ? (this.sumValue += (double)statistics.getSumLongValue()) : (this.sumValue += statistics.getSumDoubleValue());
        if (this.countValue == 0L) {
            this.initResult = false;
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        this.countValue = 1L;
        this.sumValue = finalResult.getDouble(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 2 ? 1 : 0) != 0, (Object)"partialResult of Avg should be 2");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            columnBuilders[1].appendNull();
        } else {
            columnBuilders[0].writeLong(this.countValue);
            columnBuilders[1].writeDouble(this.sumValue);
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue / (double)this.countValue);
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.countValue = 0L;
        this.sumValue = 0.0;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64, TSDataType.DOUBLE};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.DOUBLE;
    }

    private int addIntInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += (double)column[1].getInt(i);
        }
        return timeColumn.getPositionCount();
    }

    private int addLongInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += (double)column[1].getLong(i);
        }
        return timeColumn.getPositionCount();
    }

    private int addFloatInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += (double)column[1].getFloat(i);
        }
        return timeColumn.getPositionCount();
    }

    private int addDoubleInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += column[1].getDouble(i);
        }
        return timeColumn.getPositionCount();
    }
}

