/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.MemMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeAboveSGCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.StorageGroupCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.StorageGroupCounter;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTreeAboveSG {
    private final Logger logger = LoggerFactory.getLogger(MTreeAboveSG.class);
    private IMNode root;
    private MemMTreeStore store = new MemMTreeStore(new PartialPath("root"), false);

    public MTreeAboveSG() throws MetadataException {
        this.root = this.store.getRoot();
    }

    public void clear() {
        if (this.store != null) {
            this.store.clear();
            this.root = this.store.getRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageGroup(PartialPath path) throws MetadataException {
        int i;
        String[] nodeNames = path.getNodes();
        MetaFormatUtils.checkStorageGroup(path.getFullPath());
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        Template upperTemplate = cur.getSchemaTemplate();
        for (i = 1; i < nodeNames.length - 1; ++i) {
            IMNode temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                if (cur.isUseTemplate() && upperTemplate.hasSchema(nodeNames[i])) {
                    throw new PathAlreadyExistException(cur.getPartialPath().concatNode(nodeNames[i]).getFullPath());
                }
                cur.addChild(nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            } else if (temp.isStorageGroup()) {
                throw new StorageGroupAlreadySetException(temp.getFullPath());
            }
            cur = cur.getChild(nodeNames[i]);
            upperTemplate = cur.getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        MTreeAboveSG mTreeAboveSG = this;
        synchronized (mTreeAboveSG) {
            if (cur.hasChild(nodeNames[i])) {
                if (cur.getChild(nodeNames[i]).isStorageGroup()) {
                    throw new StorageGroupAlreadySetException(path.getFullPath());
                }
                throw new StorageGroupAlreadySetException(path.getFullPath(), true);
            }
            if (cur.isUseTemplate() && upperTemplate.hasSchema(nodeNames[i])) {
                throw new PathAlreadyExistException(cur.getPartialPath().concatNode(nodeNames[i]).getFullPath());
            }
            StorageGroupMNode storageGroupMNode = new StorageGroupMNode(cur, nodeNames[i], CommonDescriptor.getInstance().getConfig().getDefaultTTL());
            IMNode result = cur.addChild(nodeNames[i], storageGroupMNode);
            if (result != storageGroupMNode) {
                throw new StorageGroupAlreadySetException(path.getFullPath(), true);
            }
        }
    }

    public void deleteStorageGroup(PartialPath path) throws MetadataException {
        IStorageGroupMNode storageGroupMNode = this.getStorageGroupNodeByStorageGroupPath(path);
        IMNode cur = storageGroupMNode.getParent();
        cur.deleteChild(storageGroupMNode.getName());
        while (cur.getParent() != null && cur.getChildren().size() == 0) {
            cur.getParent().deleteChild(cur.getName());
            cur = cur.getParent();
        }
    }

    public boolean isStorageGroup(PartialPath path) {
        int i;
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 1 || !nodeNames[0].equals("root")) {
            return false;
        }
        IMNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            if ((cur = cur.getChild(nodeNames[i])) != null && !cur.isStorageGroup()) continue;
            return false;
        }
        return (cur = cur.getChild(nodeNames[i])) != null && cur.isStorageGroup();
    }

    public boolean checkStorageGroupByPath(PartialPath path) {
        String[] nodes = path.getNodes();
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                return false;
            }
            if (!cur.isStorageGroup()) continue;
            return true;
        }
        return false;
    }

    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        String[] nodes = path.getNodes();
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                throw new StorageGroupNotSetException(path.getFullPath());
            }
            if (!cur.isStorageGroup()) continue;
            return cur.getPartialPath();
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.collectStorageGroups(pathPattern, false, true);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.collectStorageGroups(pathPattern, isPrefixMatch, false);
    }

    private List<PartialPath> collectStorageGroups(PartialPath pathPattern, boolean isPrefixMatch, boolean collectInternal) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        StorageGroupCollector<List<PartialPath>> collector = new StorageGroupCollector<List<PartialPath>>(this.root, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectStorageGroup(IStorageGroupMNode node) {
                result.add(node.getPartialPath());
            }
        };
        collector.setCollectInternal(collectInternal);
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IMNode current = (IMNode)nodeStack.pop();
            if (current.isStorageGroup()) {
                res.add(current.getPartialPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    public Map<String, List<PartialPath>> groupPathByStorageGroup(final PartialPath path) throws MetadataException {
        final HashMap<String, List<PartialPath>> result = new HashMap<String, List<PartialPath>>();
        StorageGroupCollector<Map<String, String>> collector = new StorageGroupCollector<Map<String, String>>(this.root, path, (IMTreeStore)this.store){

            @Override
            protected void collectStorageGroup(IStorageGroupMNode node) {
                PartialPath sgPath = node.getPartialPath();
                result.put(sgPath.getFullPath(), path.alterPrefixPath(sgPath));
            }
        };
        collector.setCollectInternal(true);
        collector.traverse();
        return result;
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        StorageGroupCounter counter = new StorageGroupCounter(this.root, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    public IStorageGroupMNode getStorageGroupNodeByStorageGroupPath(PartialPath storageGroupPath) throws MetadataException {
        String[] nodes = storageGroupPath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(storageGroupPath.getFullPath());
        }
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length - 1; ++i) {
            if ((cur = cur.getChild(nodes[i])) == null) {
                throw new StorageGroupNotSetException(storageGroupPath.getFullPath());
            }
            if (!cur.isStorageGroup()) continue;
            throw new StorageGroupAlreadySetException(cur.getFullPath());
        }
        if ((cur = cur.getChild(nodes[nodes.length - 1])) == null) {
            throw new StorageGroupNotSetException(storageGroupPath.getFullPath());
        }
        if (cur.isStorageGroup()) {
            return cur.getAsStorageGroupMNode();
        }
        throw new StorageGroupAlreadySetException(storageGroupPath.getFullPath(), true);
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMNode cur = this.root;
        for (int i = 1; i < nodes.length && (cur = cur.getChild(nodes[i])) != null; ++i) {
            if (!cur.isStorageGroup()) continue;
            return cur.getAsStorageGroupMNode();
        }
        throw new StorageGroupNotSetException(path.getFullPath());
    }

    public List<PartialPath> getInvolvedStorageGroupNodes(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        StorageGroupCollector<List<PartialPath>> collector = new StorageGroupCollector<List<PartialPath>>(this.root, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectStorageGroup(IStorageGroupMNode node) {
                result.add(node.getPartialPath());
            }
        };
        collector.setCollectInternal(true);
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        ArrayList<IStorageGroupMNode> ret = new ArrayList<IStorageGroupMNode>();
        ArrayDeque<IMNode> nodeStack = new ArrayDeque<IMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IMNode current = (IMNode)nodeStack.pop();
            if (current.isStorageGroup()) {
                ret.add(current.getAsStorageGroupMNode());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return ret;
    }

    public boolean isStorageGroupAlreadySet(PartialPath path) {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                return false;
            }
            if (!(cur = cur.getChild(nodeNames[i])).isStorageGroup()) continue;
            return true;
        }
        return true;
    }

    public void checkStorageGroupAlreadySet(PartialPath path) throws StorageGroupAlreadySetException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                return;
            }
            if (!(cur = cur.getChild(nodeNames[i])).isStorageGroup()) continue;
            throw new StorageGroupAlreadySetException(cur.getFullPath());
        }
        throw new StorageGroupAlreadySetException(path.getFullPath(), true);
    }

    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch, LocalSchemaProcessor.StorageGroupFilter filter) throws MetadataException {
        MNodeAboveSGCollector<List<PartialPath>> collector = new MNodeAboveSGCollector<List<PartialPath>>(this.root, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void transferToResult(IMNode node) {
                ((List)this.resultSet).add(this.getCurrentPartialPath(node));
            }
        };
        collector.setResultSet(new LinkedList());
        collector.setTargetLevel(nodeLevel);
        collector.setPrefixMatch(isPrefixMatch);
        collector.setStorageGroupFilter(filter);
        collector.traverse();
        return new Pair(collector.getResult(), collector.getInvolvedStorageGroupMNodes());
    }

    public Pair<Set<String>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        try {
            MNodeAboveSGCollector<Set<String>> collector = new MNodeAboveSGCollector<Set<String>>(this.root, pathPattern.concatNode("*"), (IMTreeStore)this.store){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(this.getCurrentPartialPath(node).getFullPath());
                }
            };
            collector.setResultSet(new TreeSet());
            collector.traverse();
            return new Pair(collector.getResult(), collector.getInvolvedStorageGroupMNodes());
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    public Pair<Set<String>, Set<PartialPath>> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        try {
            MNodeAboveSGCollector<Set<String>> collector = new MNodeAboveSGCollector<Set<String>>(this.root, pathPattern.concatNode("*"), (IMTreeStore)this.store){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(node.getName());
                }
            };
            collector.setResultSet(new TreeSet());
            collector.traverse();
            return new Pair(collector.getResult(), collector.getInvolvedStorageGroupMNodes());
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeInternalNode((InternalMNode)this.root, outputStream);
    }

    private void serializeInternalNode(InternalMNode node, OutputStream outputStream) throws IOException {
        for (IMNode child : node.getChildren().values()) {
            if (child.isStorageGroup()) {
                this.serializeStorageGroupNode((StorageGroupMNode)child, outputStream);
                continue;
            }
            this.serializeInternalNode((InternalMNode)child, outputStream);
        }
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getChildren().size(), (OutputStream)outputStream);
    }

    private void serializeStorageGroupNode(StorageGroupMNode storageGroupNode, OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)storageGroupNode.getName(), (OutputStream)outputStream);
        ThriftConfigNodeSerDeUtils.serializeTStorageGroupSchema((TStorageGroupSchema)storageGroupNode.getStorageGroupSchema(), (OutputStream)outputStream);
    }

    public void deserialize(InputStream inputStream) throws IOException {
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        if (type != 1) {
            this.logger.error("Wrong node type. Cannot deserialize MTreeAboveSG from given buffer");
            return;
        }
        StorageGroupMNode storageGroupMNode = this.deserializeStorageGroupMNode(inputStream);
        Stack<InternalMNode> stack = new Stack<InternalMNode>();
        stack.push(storageGroupMNode);
        String name = storageGroupMNode.getName();
        int childNum = 0;
        block4: while (!"root".equals(name)) {
            type = ReadWriteIOUtils.readByte((InputStream)inputStream);
            switch (type) {
                case 0: {
                    InternalMNode internalMNode = this.deserializeInternalMNode(inputStream);
                    for (childNum = ReadWriteIOUtils.readInt((InputStream)inputStream); childNum > 0; --childNum) {
                        internalMNode.addChild((IMNode)stack.pop());
                    }
                    stack.push(internalMNode);
                    name = internalMNode.getName();
                    continue block4;
                }
                case 1: {
                    storageGroupMNode = this.deserializeStorageGroupMNode(inputStream);
                    childNum = 0;
                    stack.push(storageGroupMNode);
                    name = storageGroupMNode.getName();
                    continue block4;
                }
            }
            this.logger.error("Unrecognized node type. Cannot deserialize MTreeAboveSG from given buffer");
            return;
        }
        this.root = (IMNode)stack.peek();
    }

    private InternalMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
        return new InternalMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
    }

    private StorageGroupMNode deserializeStorageGroupMNode(InputStream inputStream) throws IOException {
        StorageGroupMNode storageGroupMNode = new StorageGroupMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        storageGroupMNode.setStorageGroupSchema(ThriftConfigNodeSerDeUtils.deserializeTStorageGroupSchema((InputStream)inputStream));
        return storageGroupMNode;
    }
}

