/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.IOException;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.container.IMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.container.MNodeContainers;
import org.apache.iotdb.db.metadata.mnode.visitor.MNodeVisitor;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;

public class InternalMNode
extends MNode {
    private static final long serialVersionUID = -770028375899514063L;
    protected volatile transient IMNodeContainer children = null;
    protected Template schemaTemplate = null;
    private volatile boolean useTemplate = false;

    public InternalMNode(IMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name);
    }

    @Override
    public IMNode getChild(String name) {
        IMNode child = null;
        if (this.children != null) {
            child = (IMNode)this.children.get(name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode addChild(String name, IMNode child) {
        if (this.children == null) {
            InternalMNode internalMNode = this;
            synchronized (internalMNode) {
                if (this.children == null) {
                    this.children = MNodeContainers.getNewMNodeContainer();
                }
            }
        }
        child.setParent(this);
        IMNode existingChild = this.children.putIfAbsent(name, child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode addChild(IMNode child) {
        if (this.children == null) {
            InternalMNode internalMNode = this;
            synchronized (internalMNode) {
                if (this.children == null) {
                    this.children = MNodeContainers.getNewMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent(child.getName(), child);
        return child;
    }

    @Override
    public IMNode deleteChild(String name) {
        if (this.children != null) {
            return (IMNode)this.children.remove(name);
        }
        return null;
    }

    @Override
    public synchronized void replaceChild(String oldChildName, IMNode newChildNode) {
        if (!oldChildName.equals(newChildNode.getName())) {
            throw new RuntimeException("New child's name must be the same as old child's name!");
        }
        IMNode oldChildNode = this.getChild(oldChildName);
        if (oldChildNode == null) {
            return;
        }
        oldChildNode.moveDataToNewMNode(newChildNode);
        this.children.replace(newChildNode.getName(), newChildNode);
    }

    @Override
    public void moveDataToNewMNode(IMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
        newMNode.setSchemaTemplate(this.schemaTemplate);
        newMNode.setUseTemplate(this.useTemplate);
        if (this.children != null) {
            newMNode.setChildren(this.children);
            this.children.forEach((childName, childNode) -> childNode.setParent(newMNode));
        }
    }

    @Override
    public IMNodeContainer getChildren() {
        if (this.children == null) {
            return MNodeContainers.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer children) {
        this.children = children;
    }

    @Override
    public Template getUpperTemplate() {
        for (IMNode cur = this; cur != null; cur = cur.getParent()) {
            if (cur.getSchemaTemplate() == null) continue;
            return cur.getSchemaTemplate();
        }
        return null;
    }

    @Override
    public Template getSchemaTemplate() {
        return this.schemaTemplate;
    }

    @Override
    public void setSchemaTemplate(Template schemaTemplate) {
        this.schemaTemplate = schemaTemplate;
    }

    @Override
    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    @Override
    public void serializeTo(MLogWriter logWriter) throws IOException {
        this.serializeChildren(logWriter);
        logWriter.serializeMNode(this);
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitInternalMNode(this, context);
    }

    void serializeChildren(MLogWriter logWriter) throws IOException {
        if (this.children == null) {
            return;
        }
        for (IMNode child : this.children.values()) {
            child.serializeTo(logWriter);
        }
    }

    public static InternalMNode deserializeFrom(MNodePlan plan) {
        return new InternalMNode(null, plan.getName());
    }
}

