/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.dataregion;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.dataregion.VirtualPartitioner;

public class HashVirtualPartitioner
implements VirtualPartitioner {
    public static int STORAGE_GROUP_NUM = IoTDBDescriptor.getInstance().getConfig().getDataRegionNum();

    private HashVirtualPartitioner() {
    }

    public static HashVirtualPartitioner getInstance() {
        return HashVirtualPartitionerHolder.INSTANCE;
    }

    @Override
    public int deviceToDataRegionId(PartialPath deviceId) {
        return this.toStorageGroupId(deviceId);
    }

    @Override
    public int getPartitionCount() {
        return STORAGE_GROUP_NUM;
    }

    private int toStorageGroupId(PartialPath deviceId) {
        return Math.abs(deviceId.hashCode() % STORAGE_GROUP_NUM);
    }

    private static class HashVirtualPartitionerHolder {
        private static final HashVirtualPartitioner INSTANCE = new HashVirtualPartitioner();

        private HashVirtualPartitionerHolder() {
        }
    }
}

