/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.snapshot.exception.DirectoryNotLegalException;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotTaker.class);
    private final DataRegion dataRegion;
    public static String SNAPSHOT_FILE_INFO_SEP_STR = "_";
    private File seqBaseDir;
    private File unseqBaseDir;

    public SnapshotTaker(DataRegion dataRegion) {
        this.dataRegion = dataRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeFullSnapshot(String snapshotDirPath, boolean flushBeforeSnapshot) throws DirectoryNotLegalException, IOException {
        File snapshotDir = new File(snapshotDirPath);
        if (snapshotDir.exists() && snapshotDir.listFiles() != null && Objects.requireNonNull(snapshotDir.listFiles()).length > 0) {
            throw new DirectoryNotLegalException(String.format("%s already exists and is not empty", snapshotDirPath));
        }
        this.seqBaseDir = new File(snapshotDir, "sequence" + File.separator + this.dataRegion.getLogicalStorageGroupName() + File.separator + this.dataRegion.getDataRegionId());
        this.unseqBaseDir = new File(snapshotDir, "unsequence" + File.separator + this.dataRegion.getLogicalStorageGroupName() + File.separator + this.dataRegion.getDataRegionId());
        if (!snapshotDir.exists() && !snapshotDir.mkdirs()) {
            throw new IOException(String.format("Failed to create directory %s", snapshotDir));
        }
        if (flushBeforeSnapshot) {
            this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
        List<Long> timePartitions = this.dataRegion.getTimePartitions();
        TsFileManager manager = this.dataRegion.getTsFileManager();
        manager.readLock();
        try {
            for (Long timePartition : timePartitions) {
                List<String> seqDataDirs = this.getAllDataDirOfOnePartition(true, timePartition);
                try {
                    this.createFileSnapshot(seqDataDirs, true, timePartition);
                }
                catch (IOException e) {
                    LOGGER.error("Fail to create snapshot", (Throwable)e);
                    this.cleanUpWhenFail(snapshotDir);
                    boolean bl = false;
                    manager.readUnlock();
                    return bl;
                }
                List<String> unseqDataDirs = this.getAllDataDirOfOnePartition(false, timePartition);
                try {
                    this.createFileSnapshot(unseqDataDirs, false, timePartition);
                }
                catch (IOException e) {
                    LOGGER.error("Fail to create snapshot", (Throwable)e);
                    this.cleanUpWhenFail(snapshotDir);
                    boolean bl = false;
                    manager.readUnlock();
                    return bl;
                }
            }
        }
        finally {
            manager.readUnlock();
        }
        LOGGER.info("Successfully take snapshot for {}-{}, snapshot directory is {}", new Object[]{this.dataRegion.getLogicalStorageGroupName(), this.dataRegion.getDataRegionId(), snapshotDirPath});
        return true;
    }

    private List<String> getAllDataDirOfOnePartition(boolean sequence, long timePartition) {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        LinkedList<String> resultDirs = new LinkedList<String>();
        for (String dataDir : dataDirs) {
            resultDirs.add(dataDir + File.separator + (sequence ? "sequence" : "unsequence") + File.separator + this.dataRegion.getLogicalStorageGroupName() + File.separator + this.dataRegion.getDataRegionId() + File.separator + timePartition + File.separator);
        }
        return resultDirs;
    }

    private void createFileSnapshot(List<String> sourceDirPaths, boolean sequence, long timePartition) throws IOException {
        File timePartitionDir = new File(sequence ? this.seqBaseDir : this.unseqBaseDir, String.valueOf(timePartition));
        if (!timePartitionDir.exists() && !timePartitionDir.mkdirs()) {
            throw new IOException(String.format("%s not exists and cannot create it", timePartitionDir.getAbsolutePath()));
        }
        for (String sourceDirPath : sourceDirPaths) {
            File[] files;
            File sourceDir = new File(sourceDirPath);
            if (!sourceDir.exists() || (files = sourceDir.listFiles((dir, name) -> name.endsWith(".tsfile") || name.endsWith(".resource") || name.endsWith(".mods") || name.endsWith(".compaction.mods") || name.endsWith(".inner-compaction.log") || name.endsWith(".cross-compaction.log") || name.endsWith(".inner") || name.endsWith(".cross"))) == null || files.length == 0) continue;
            for (File file : files) {
                File linkFile = new File(timePartitionDir, file.getName());
                Files.createLink(linkFile.toPath(), file.toPath());
            }
        }
    }

    private void cleanUpWhenFail(File snapshotDir) {
        File[] files = snapshotDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.delete()) continue;
                LOGGER.error("Failed to delete link file {} after failing to create snapshot", (Object)file);
            }
        }
    }
}

