/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionTask
implements Callable<CompactionTaskSummary> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected String fullStorageGroupName;
    protected long timePartition;
    protected final AtomicInteger currentTaskNum;
    protected final TsFileManager tsFileManager;
    protected long timeCost = 0L;
    protected volatile boolean ran = false;
    protected volatile boolean finished = false;
    protected ICompactionPerformer performer;
    protected int hashCode = -1;
    protected long serialId;

    public AbstractCompactionTask(String fullStorageGroupName, long timePartition, TsFileManager tsFileManager, AtomicInteger currentTaskNum, long serialId) {
        this.fullStorageGroupName = fullStorageGroupName;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.currentTaskNum = currentTaskNum;
        this.serialId = serialId;
    }

    public abstract void setSourceFilesToCompactionCandidate();

    protected abstract void doCompaction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionTaskSummary call() throws Exception {
        this.ran = true;
        long startTime = System.currentTimeMillis();
        this.currentTaskNum.incrementAndGet();
        boolean isSuccess = false;
        try {
            this.doCompaction();
            isSuccess = true;
        }
        catch (InterruptedException e) {
            LOGGER.warn("{} [Compaction] Current task is interrupted", (Object)this.fullStorageGroupName);
        }
        catch (Throwable e) {
            LOGGER.error("{} [Compaction] Running compaction task failed", (Object)this.fullStorageGroupName, (Object)e);
        }
        finally {
            this.currentTaskNum.decrementAndGet();
            this.timeCost = System.currentTimeMillis() - startTime;
            CompactionTaskManager.getInstance().removeRunningTaskFuture(this);
            this.finished = true;
        }
        return new CompactionTaskSummary(isSuccess);
    }

    public String getFullStorageGroupName() {
        return this.fullStorageGroupName;
    }

    public long getTimePartition() {
        return this.timePartition;
    }

    public abstract boolean equalsOtherTask(AbstractCompactionTask var1);

    public abstract boolean checkValidAndSetMerging();

    public boolean equals(Object other) {
        if (other instanceof AbstractCompactionTask) {
            return this.equalsOtherTask((AbstractCompactionTask)other);
        }
        return false;
    }

    public abstract void resetCompactionCandidateStatusForAllSourceFiles();

    public long getTimeCost() {
        return this.timeCost;
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(String.format("%s [Compaction] abort", this.fullStorageGroupName));
        }
    }

    public boolean isTaskRan() {
        return this.ran;
    }

    public boolean isTaskFinished() {
        return this.finished;
    }

    public long getSerialId() {
        return this.serialId;
    }
}

