/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.upgrade.MetadataUpgrader;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStartCheck {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBStartCheck.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private static final String PROPERTIES_FILE_NAME = "system.properties";
    private static final String SCHEMA_DIR = config.getSchemaDir();
    private static final String[] WAL_DIRS = config.getWalDirs();
    private File propertiesFile;
    private File tmpPropertiesFile;
    private Properties properties = new Properties();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private static final String SYSTEM_PROPERTIES_STRING = "System properties:";
    private static final String TIMESTAMP_PRECISION_STRING = "timestamp_precision";
    private static String timestampPrecision = config.getTimestampPrecision();
    private static final String PARTITION_INTERVAL_STRING = "partition_interval";
    private static long partitionInterval = config.getPartitionInterval();
    private static final String TSFILE_FILE_SYSTEM_STRING = "tsfile_storage_fs";
    private static String tsfileFileSystem = config.getTsFileStorageFs().toString();
    private static final String ENABLE_PARTITION_STRING = "enable_partition";
    private static boolean enablePartition = config.isEnablePartition();
    private static final String TAG_ATTRIBUTE_SIZE_STRING = "tag_attribute_total_size";
    private static String tagAttributeTotalSize = String.valueOf(config.getTagAttributeTotalSize());
    private static final String TAG_ATTRIBUTE_FLUSH_INTERVAL = "tag_attribute_flush_interval";
    private static String tagAttributeFlushInterval = String.valueOf(config.getTagAttributeFlushInterval());
    private static final String MAX_DEGREE_OF_INDEX_STRING = "max_degree_of_index_node";
    private static String maxDegreeOfIndexNode = String.valueOf(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode());
    private static final String DATA_REGION_NUM = "data_region_num";
    private static final String VIRTUAL_STORAGE_GROUP_NUM = "virtual_storage_group_num";
    private static String dataRegionNum = String.valueOf(config.getDataRegionNum());
    private static final String ENABLE_ID_TABLE = "enable_id_table";
    private static String enableIDTable = String.valueOf(config.isEnableIDTable());
    private static final String ENABLE_ID_TABLE_LOG_FILE = "enable_id_table_log_file";
    private static String enableIdTableLogFile = String.valueOf(config.isEnableIDTableLogFile());
    private static final String SCHEMA_ENGINE_MODE = "schema_engine_mode";
    private static String schemaEngineMode = String.valueOf(config.getSchemaEngineMode());
    private static final String TIME_ENCODER_KEY = "time_encoder";
    private static String timeEncoderValue = String.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
    private static final String DATA_NODE_ID = "data_node_id";
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL = "schema_region_consensus_protocol";
    private static final String DATA_REGION_CONSENSUS_PROTOCOL = "data_region_consensus_protocol";
    private static final String IOTDB_VERSION_STRING = "iotdb_version";

    public static IoTDBStartCheck getInstance() {
        return IoTDBConfigCheckHolder.INSTANCE;
    }

    private IoTDBStartCheck() {
        logger.info("Starting IoTDB " + IoTDBConstant.VERSION);
        File dir = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error("can not create schema dir: {}", (Object)SCHEMA_DIR);
                System.exit(-1);
            } else {
                logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
            }
        }
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong {}, please set as: ms, us or ns ! Current is: {}", (Object)TIMESTAMP_PRECISION_STRING, (Object)timestampPrecision);
            System.exit(-1);
        }
        if (!enablePartition) {
            partitionInterval = Long.MAX_VALUE;
        }
        if (partitionInterval <= 0L) {
            logger.error("Partition interval must larger than 0!");
            System.exit(-1);
        }
        this.systemProperties.put(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
        this.systemProperties.put(TIMESTAMP_PRECISION_STRING, timestampPrecision);
        this.systemProperties.put(PARTITION_INTERVAL_STRING, String.valueOf(partitionInterval));
        this.systemProperties.put(TSFILE_FILE_SYSTEM_STRING, tsfileFileSystem);
        this.systemProperties.put(ENABLE_PARTITION_STRING, String.valueOf(enablePartition));
        this.systemProperties.put(TAG_ATTRIBUTE_SIZE_STRING, tagAttributeTotalSize);
        this.systemProperties.put(TAG_ATTRIBUTE_FLUSH_INTERVAL, tagAttributeFlushInterval);
        this.systemProperties.put(MAX_DEGREE_OF_INDEX_STRING, maxDegreeOfIndexNode);
        this.systemProperties.put(DATA_REGION_NUM, dataRegionNum);
        this.systemProperties.put(TIME_ENCODER_KEY, timeEncoderValue);
        this.systemProperties.put(ENABLE_ID_TABLE, enableIDTable);
        this.systemProperties.put(ENABLE_ID_TABLE_LOG_FILE, enableIdTableLogFile);
        this.systemProperties.put(SCHEMA_ENGINE_MODE, schemaEngineMode);
    }

    public void checkConfig() throws ConfigurationException, IOException {
        String versionString;
        this.propertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME);
        this.tmpPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME + ".tmp");
        if (!this.propertiesFile.exists() && !this.tmpPropertiesFile.exists()) {
            if (this.propertiesFile.createNewFile()) {
                logger.info(" {} has been created.", (Object)this.propertiesFile.getAbsolutePath());
            } else {
                logger.error("can not create {}", (Object)this.propertiesFile.getAbsolutePath());
                System.exit(-1);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            return;
        }
        if (!this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
            logger.info("rename {} to {}", (Object)this.tmpPropertiesFile, (Object)this.propertiesFile);
            return;
        }
        if (this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.forceDelete((File)this.tmpPropertiesFile);
            logger.info("remove {}", (Object)this.tmpPropertiesFile);
        }
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
        if (!this.properties.containsKey(IOTDB_VERSION_STRING)) {
            logger.error("DO NOT UPGRADE IoTDB from v0.9 or lower version to v0.12! Please upgrade to v0.10 first");
            System.exit(-1);
        }
        if ((versionString = this.properties.getProperty(IOTDB_VERSION_STRING)).startsWith("0.10") || versionString.startsWith("0.11")) {
            logger.error("IoTDB version is too old, please upgrade to 0.12 firstly.");
            System.exit(-1);
        } else if (versionString.startsWith("0.12") || versionString.startsWith("0.13")) {
            this.checkWALNotExists();
            this.upgradePropertiesFile();
            MetadataUpgrader.upgrade();
        }
        this.checkProperties();
    }

    private void checkWALNotExists() {
        for (String walDir : WAL_DIRS) {
            File[] sgWALs;
            if (!SystemFileFactory.INSTANCE.getFile(walDir).isDirectory() || (sgWALs = SystemFileFactory.INSTANCE.getFile(walDir).listFiles()) == null) continue;
            for (File sgWAL : sgWALs) {
                if (!sgWAL.isDirectory() || sgWAL.list().length == 0) continue;
                logger.error("WAL detected, please stop insertion and run 'SET SYSTEM TO READONLY', then run 'flush' on IoTDB {} before upgrading to {}.", (Object)this.properties.getProperty(IOTDB_VERSION_STRING), (Object)IoTDBConstant.VERSION);
                System.exit(-1);
            }
        }
    }

    private void upgradePropertiesFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v);
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.setProperty(DATA_REGION_NUM, this.properties.getProperty(VIRTUAL_STORAGE_GROUP_NUM));
            this.properties.remove(VIRTUAL_STORAGE_GROUP_NUM);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void upgradePropertiesFileFromBrokenFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v);
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void checkProperties() throws ConfigurationException, IOException {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.upgradePropertiesFileFromBrokenFile();
            logger.info("repair system.properties, lack {}", (Object)entry.getKey());
        }
        if (!this.properties.getProperty(TIMESTAMP_PRECISION_STRING).equals(timestampPrecision)) {
            this.throwException(TIMESTAMP_PRECISION_STRING, timestampPrecision);
        }
        if (Boolean.parseBoolean(this.properties.getProperty(ENABLE_PARTITION_STRING)) != enablePartition) {
            this.throwException(ENABLE_PARTITION_STRING, enablePartition);
        }
        if (Long.parseLong(this.properties.getProperty(PARTITION_INTERVAL_STRING)) != partitionInterval) {
            this.throwException(PARTITION_INTERVAL_STRING, partitionInterval);
        }
        if (!this.properties.getProperty(TSFILE_FILE_SYSTEM_STRING).equals(tsfileFileSystem)) {
            this.throwException(TSFILE_FILE_SYSTEM_STRING, tsfileFileSystem);
        }
        if (!this.properties.getProperty(TAG_ATTRIBUTE_SIZE_STRING).equals(tagAttributeTotalSize)) {
            this.throwException(TAG_ATTRIBUTE_SIZE_STRING, tagAttributeTotalSize);
        }
        if (!this.properties.getProperty(TAG_ATTRIBUTE_FLUSH_INTERVAL).equals(tagAttributeFlushInterval)) {
            this.throwException(TAG_ATTRIBUTE_FLUSH_INTERVAL, tagAttributeFlushInterval);
        }
        if (!this.properties.getProperty(MAX_DEGREE_OF_INDEX_STRING).equals(maxDegreeOfIndexNode)) {
            this.throwException(MAX_DEGREE_OF_INDEX_STRING, maxDegreeOfIndexNode);
        }
        if (!this.properties.getProperty(DATA_REGION_NUM).equals(dataRegionNum)) {
            this.throwException(DATA_REGION_NUM, dataRegionNum);
        }
        if (!this.properties.getProperty(TIME_ENCODER_KEY).equals(timeEncoderValue)) {
            this.throwException(TIME_ENCODER_KEY, timeEncoderValue);
        }
        if (!this.properties.getProperty(ENABLE_ID_TABLE).equals(enableIDTable)) {
            this.throwException(ENABLE_ID_TABLE, enableIDTable);
        }
        if (!this.properties.getProperty(ENABLE_ID_TABLE_LOG_FILE).equals(enableIdTableLogFile)) {
            this.throwException(ENABLE_ID_TABLE_LOG_FILE, enableIdTableLogFile);
        }
        if (!this.properties.getProperty(SCHEMA_ENGINE_MODE).equals(schemaEngineMode)) {
            this.throwException(SCHEMA_ENGINE_MODE, schemaEngineMode);
        }
        if (this.properties.containsKey(DATA_NODE_ID)) {
            config.setDataNodeId(Integer.parseInt(this.properties.getProperty(DATA_NODE_ID)));
        }
        if (this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL)) {
            config.setSchemaRegionConsensusProtocolClass(this.properties.getProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL));
        }
        if (this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL)) {
            config.setDataRegionConsensusProtocolClass(this.properties.getProperty(DATA_REGION_CONSENSUS_PROTOCOL));
        }
    }

    private void throwException(String parameter, Object badValue) throws ConfigurationException {
        throw new ConfigurationException(parameter, String.valueOf(badValue), this.properties.getProperty(parameter));
    }

    private void reloadProperties() throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
    }

    public void serializeDataNodeId(int dataNodeId) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.properties.setProperty(DATA_NODE_ID, String.valueOf(dataNodeId));
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public void serializeConsensusProtocol(String regionConsensusProtocol, TConsensusGroupType type) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            if (type == TConsensusGroupType.DataRegion) {
                this.properties.setProperty(DATA_REGION_CONSENSUS_PROTOCOL, regionConsensusProtocol);
            } else if (type == TConsensusGroupType.SchemaRegion) {
                this.properties.setProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL, regionConsensusProtocol);
            }
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public boolean checkConsensusProtocolExists(TConsensusGroupType type) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL);
        }
        if (type == TConsensusGroupType.SchemaRegion) {
            return this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL);
        }
        logger.error("Unexpected consensus group type");
        return false;
    }

    private static class IoTDBConfigCheckHolder {
        private static final IoTDBStartCheck INSTANCE = new IoTDBStartCheck();

        private IoTDBConfigCheckHolder() {
        }
    }
}

