/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;
import org.apache.iotdb.tsfile.exception.PathParseException;
import org.apache.iotdb.tsfile.read.common.parser.PathNodesGenerator;

public class PathUtils {
    public static String[] splitPathToDetachedNodes(String path) throws IllegalPathException {
        if ("".equals(path)) {
            return new String[0];
        }
        try {
            return PathNodesGenerator.splitPathToNodes((String)path);
        }
        catch (PathParseException e) {
            throw new IllegalPathException(path);
        }
    }

    public static void isLegalPath(String path) throws IllegalPathException {
        try {
            PathNodesGenerator.splitPathToNodes((String)path);
        }
        catch (PathParseException e) {
            throw new IllegalPathException(path);
        }
    }

    public static void isLegalSingleMeasurementLists(List<List<String>> measurementLists) throws MetadataException {
        if (measurementLists == null) {
            return;
        }
        for (List<String> measurements : measurementLists) {
            PathUtils.isLegalMeasurements(measurements);
        }
    }

    public static void isLegalSingleMeasurements(List<String> measurements) throws MetadataException {
        if (measurements == null) {
            return;
        }
        for (String measurement : measurements) {
            if (measurement == null) continue;
            if (measurement.startsWith("`") && measurement.endsWith("`")) {
                if (PathUtils.checkBackQuotes(measurement.substring(1, measurement.length() - 1))) continue;
                throw new IllegalPathException(measurement);
            }
            if (!IoTDBConstant.reservedWords.contains(measurement.toUpperCase()) && !StringUtils.isNumeric((CharSequence)measurement) && TsFileConstant.NODE_NAME_PATTERN.matcher(measurement).matches()) continue;
            throw new IllegalPathException(measurement);
        }
    }

    public static void isLegalMeasurementLists(List<List<String>> measurementLists) throws IllegalPathException {
        if (measurementLists == null) {
            return;
        }
        for (List<String> measurementList : measurementLists) {
            PathUtils.isLegalMeasurements(measurementList);
        }
    }

    public static void isLegalMeasurements(List<String> measurements) throws IllegalPathException {
        if (measurements == null) {
            return;
        }
        for (String measurement : measurements) {
            if (measurement == null) continue;
            PathUtils.isLegalPath(measurement);
        }
    }

    public static boolean isStartWith(String deviceName, String storageGroup) {
        return deviceName.equals(storageGroup) || deviceName.startsWith(storageGroup + ".");
    }

    private static boolean checkBackQuotes(String src) {
        int num = src.length() - src.replace("`", "").length();
        if (num % 2 == 1) {
            return false;
        }
        return src.length() == src.replace("``", "").length() + num;
    }
}

