/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.builtin.UDTFMath;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFOnOff
extends UDTFMath {
    protected double threshold;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validateRequiredAttribute("threshold");
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.threshold = parameters.getDouble("threshold");
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(0));
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putBoolean(time, (double)row.getInt(0) >= this.threshold);
                break;
            }
            case INT64: {
                collector.putBoolean(time, (double)row.getLong(0) >= this.threshold);
                break;
            }
            case FLOAT: {
                collector.putBoolean(time, (double)row.getFloat(0) >= this.threshold);
                break;
            }
            case DOUBLE: {
                collector.putBoolean(time, row.getDouble(0) >= this.threshold);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    @Override
    protected void setTransformer() {
        throw new UnsupportedOperationException("UDTFOnOff#setTransformer()");
    }
}

