/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.ratis.FileInfoWithDelayedMd5Computing;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.SnapshotRetentionPolicy;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.impl.FileListSnapshotInfo;
import org.apache.ratis.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStorage
implements StateMachineStorage {
    private final Logger logger = LoggerFactory.getLogger(SnapshotStorage.class);
    private final IStateMachine applicationStateMachine;
    private final String META_FILE_PREFIX = ".ratis_meta.";
    private File stateMachineDir;

    public SnapshotStorage(IStateMachine applicationStateMachine) {
        this.applicationStateMachine = applicationStateMachine;
    }

    public void init(RaftStorage raftStorage) throws IOException {
        this.stateMachineDir = raftStorage.getStorageDir().getStateMachineDir();
    }

    private Path[] getSortedSnapshotDirPaths() {
        ArrayList<Path> snapshotPaths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.stateMachineDir.toPath());){
            for (Path path : stream) {
                if (!path.toFile().isDirectory()) continue;
                snapshotPaths.add(path);
            }
        }
        catch (IOException exception) {
            this.logger.warn("cannot construct snapshot directory stream ", (Throwable)exception);
            return null;
        }
        Path[] pathArray = snapshotPaths.toArray(new Path[0]);
        Arrays.sort(pathArray, (o1, o2) -> {
            String index1 = o1.toFile().getName().split("_")[1];
            String index2 = o2.toFile().getName().split("_")[1];
            return Long.compare(Long.parseLong(index1), Long.parseLong(index2));
        });
        return pathArray;
    }

    public File findLatestSnapshotDir() {
        this.moveSnapshotFileToSubDirectory();
        Path[] snapshots = this.getSortedSnapshotDirPaths();
        if (snapshots == null || snapshots.length == 0) {
            return null;
        }
        return snapshots[snapshots.length - 1].toFile();
    }

    private List<Path> getAllFilesUnder(File rootDir) {
        final ArrayList<Path> allFiles = new ArrayList<Path>();
        try {
            Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile()) {
                        allFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    SnapshotStorage.this.logger.info("visit file {} failed due to {}", (Object)file.toAbsolutePath(), (Object)exc);
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            this.logger.error("IOException occurred during listing snapshot directory: ", (Throwable)ioException);
            return Collections.emptyList();
        }
        return allFiles;
    }

    public SnapshotInfo getLatestSnapshot() {
        File latestSnapshotDir = this.findLatestSnapshotDir();
        if (latestSnapshotDir == null) {
            return null;
        }
        TermIndex snapshotTermIndex = Utils.getTermIndexFromDir(latestSnapshotDir);
        ArrayList<FileInfoWithDelayedMd5Computing> fileInfos = new ArrayList<FileInfoWithDelayedMd5Computing>();
        for (Path file : this.getAllFilesUnder(latestSnapshotDir)) {
            FileInfoWithDelayedMd5Computing fileInfo = new FileInfoWithDelayedMd5Computing(file);
            fileInfos.add(fileInfo);
        }
        return new FileListSnapshotInfo(fileInfos, snapshotTermIndex.getTerm(), snapshotTermIndex.getIndex());
    }

    public void format() throws IOException {
    }

    public void cleanupOldSnapshots(SnapshotRetentionPolicy snapshotRetentionPolicy) throws IOException {
        Path[] sortedSnapshotDirs = this.getSortedSnapshotDirPaths();
        if (sortedSnapshotDirs == null || sortedSnapshotDirs.length == 0) {
            return;
        }
        for (int i = 0; i < sortedSnapshotDirs.length - 1; ++i) {
            FileUtils.deleteFully((Path)sortedSnapshotDirs[i]);
        }
    }

    public File getStateMachineDir() {
        return this.stateMachineDir;
    }

    public File getSnapshotDir(String snapshotMetadata) {
        return new File(this.stateMachineDir.getAbsolutePath() + File.separator + snapshotMetadata);
    }

    public boolean addTermIndexMetaFile(File snapshotDir, String termIndexMetadata) {
        File snapshotMetaFile = new File(this.getMetafilePath(snapshotDir, termIndexMetadata));
        try {
            return snapshotMetaFile.createNewFile();
        }
        catch (IOException e) {
            this.logger.warn("cannot create snapshot metafile: ", (Throwable)e);
            return false;
        }
    }

    private String getMetafilePath(File snapshotDir, String termIndexMetadata) {
        return snapshotDir.getAbsolutePath() + File.separator + ".ratis_meta." + termIndexMetadata;
    }

    private String getMetafileMatcherRegex() {
        return ".ratis_meta.\\d+_\\d+$";
    }

    void moveSnapshotFileToSubDirectory() {
        File[] potentialMetafile = this.stateMachineDir.listFiles((dir, name) -> name.matches(this.getMetafileMatcherRegex()));
        if (potentialMetafile == null || potentialMetafile.length == 0) {
            return;
        }
        String metadata = potentialMetafile[0].getName().substring(".ratis_meta.".length());
        File snapshotDir = this.getSnapshotDir(metadata);
        snapshotDir.mkdir();
        File[] snapshotFiles = this.stateMachineDir.listFiles();
        try {
            if (snapshotFiles == null) {
                this.logger.error("An unexpected condition triggered. please check implementation " + this.getClass().getName());
                FileUtils.deleteFully((File)snapshotDir);
                return;
            }
            for (File file : snapshotFiles) {
                boolean success;
                if (file.equals(snapshotDir) || (success = file.renameTo(new File(snapshotDir + File.separator + file.getName())))) continue;
                this.logger.warn("move snapshot file " + file.getAbsolutePath() + " to sub-directory " + snapshotDir.getAbsolutePath() + "failed");
                FileUtils.deleteFully((File)snapshotDir);
                break;
            }
        }
        catch (IOException e) {
            this.logger.warn("delete directory failed: ", (Throwable)e);
        }
    }
}

