/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientPoolProperty;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.consensus.exception.RatisRequestFailedException;
import org.apache.iotdb.consensus.ratis.ApplicationStateMachineProxy;
import org.apache.iotdb.consensus.ratis.RatisClient;
import org.apache.iotdb.consensus.ratis.RequestMessage;
import org.apache.iotdb.consensus.ratis.ResponseMessage;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RatisConsensus
implements IConsensus {
    private final Logger logger = LoggerFactory.getLogger(RatisConsensus.class);
    private final RaftPeer myself;
    private final RaftServer server;
    private final RaftProperties properties = new RaftProperties();
    private final RaftClientRpc clientRpc;
    private final IClientManager<RaftGroup, RatisClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new RatisClientPoolFactory());
    private final Map<RaftGroupId, RaftGroup> lastSeen = new ConcurrentHashMap<RaftGroupId, RaftGroup>();
    private final ClientId localFakeId = ClientId.randomId();
    private final AtomicLong localFakeCallId = new AtomicLong(0L);
    private static final int DEFAULT_PRIORITY = 0;
    private static final int LEADER_PRIORITY = 1;
    private static final int DEFAULT_WAIT_LEADER_READY_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);

    public RatisConsensus(ConsensusConfig config, IStateMachine.Registry registry) throws IOException {
        this.myself = Utils.fromTEndPointAndPriorityToRaftPeer(config.getThisNode(), 0);
        System.setProperty("org.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads", "false");
        RaftServerConfigKeys.setStorageDir((RaftProperties)this.properties, Collections.singletonList(new File(config.getStorageDir())));
        GrpcConfigKeys.Server.setPort((RaftProperties)this.properties, (int)config.getThisNode().getPort());
        Utils.initRatisConfig(this.properties, config.getRatisConfig());
        this.clientRpc = new GrpcFactory(new Parameters()).newRaftClientRpc(ClientId.randomId(), this.properties);
        this.server = RaftServer.newBuilder().setServerId(this.myself.getId()).setProperties(this.properties).setStateMachineRegistry(raftGroupId -> new ApplicationStateMachineProxy((IStateMachine)registry.apply(Utils.fromRaftGroupIdToConsensusGroupId(raftGroupId)), (RaftGroupId)raftGroupId)).build();
    }

    @Override
    public void start() throws IOException {
        this.server.start();
    }

    @Override
    public void stop() throws IOException {
        this.clientManager.close();
        this.server.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsensusWriteResponse write(ConsensusGroupId consensusGroupId, IConsensusRequest IConsensusRequest2) {
        TSStatus writeResult;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(consensusGroupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null || !raftGroup.getPeers().contains(this.myself)) {
            return this.failedWrite(new ConsensusGroupNotExistException(consensusGroupId));
        }
        RequestMessage message = new RequestMessage(IConsensusRequest2);
        RaftClientRequest clientRequest = this.buildRawRequest(raftGroupId, message, RaftClientRequest.writeRequestType());
        RaftPeer suggestedLeader = null;
        if (this.isLeader(consensusGroupId) && this.waitUntilLeaderReady(raftGroupId)) {
            try {
                RaftClientReply localServerReply = this.server.submitClientRequest(clientRequest);
                if (localServerReply.isSuccess()) {
                    ResponseMessage responseMessage = (ResponseMessage)localServerReply.getMessage();
                    TSStatus writeStatus = (TSStatus)responseMessage.getContentHolder();
                    return ConsensusWriteResponse.newBuilder().setStatus(writeStatus).build();
                }
                NotLeaderException ex = localServerReply.getNotLeaderException();
                if (ex != null) {
                    suggestedLeader = ex.getSuggestedLeader();
                }
            }
            catch (IOException e) {
                return this.failedWrite(new RatisRequestFailedException(e));
            }
        }
        RatisClient client = null;
        try {
            client = this.getRaftClient(raftGroup);
            RaftClientReply reply = client.getRaftClient().io().send((Message)message);
            if (!reply.isSuccess()) {
                ConsensusWriteResponse consensusWriteResponse = this.failedWrite(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusWriteResponse;
            }
            writeResult = Utils.deserializeFrom(reply.getMessage().getContent().asReadOnlyByteBuffer());
        }
        catch (IOException | TException e) {
            ConsensusWriteResponse consensusWriteResponse = this.failedWrite(new RatisRequestFailedException((Exception)e));
            return consensusWriteResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        if (suggestedLeader != null) {
            TEndPoint leaderEndPoint = Utils.formRaftPeerIdToTEndPoint(suggestedLeader.getId());
            writeResult.setRedirectNode(new TEndPoint(leaderEndPoint.getIp(), leaderEndPoint.getPort()));
        }
        return ConsensusWriteResponse.newBuilder().setStatus(writeResult).build();
    }

    @Override
    public ConsensusReadResponse read(ConsensusGroupId consensusGroupId, IConsensusRequest IConsensusRequest2) {
        RaftClientReply reply;
        RaftGroupId groupId = Utils.fromConsensusGroupIdToRaftGroupId(consensusGroupId);
        RaftGroup group = this.getGroupInfo(groupId);
        if (group == null || !group.getPeers().contains(this.myself)) {
            return this.failedRead(new ConsensusGroupNotExistException(consensusGroupId));
        }
        try {
            RequestMessage message = new RequestMessage(IConsensusRequest2);
            RaftClientRequest clientRequest = this.buildRawRequest(groupId, message, RaftClientRequest.staleReadRequestType((long)-1L));
            reply = this.server.submitClientRequest(clientRequest);
            if (!reply.isSuccess()) {
                return this.failedRead(new RatisRequestFailedException((Exception)reply.getException()));
            }
        }
        catch (IOException e) {
            return this.failedRead(new RatisRequestFailedException(e));
        }
        Message ret = reply.getMessage();
        ResponseMessage readResponseMessage = (ResponseMessage)ret;
        DataSet dataSet = (DataSet)readResponseMessage.getContentHolder();
        return ConsensusReadResponse.newBuilder().setDataSet(dataSet).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsensusGenericResponse addConsensusGroup(ConsensusGroupId groupId, List<Peer> peers) {
        RaftClientReply reply;
        RaftGroup group = this.buildRaftGroup(groupId, peers);
        if (!group.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        RatisClient client = null;
        try {
            client = this.getRaftClient(group);
            reply = client.getRaftClient().getGroupManagementApi(this.myself.getId()).add(group);
            if (!reply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusGenericResponse;
            }
        }
        catch (IOException e) {
            ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException(e));
            return consensusGenericResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsensusGenericResponse removeConsensusGroup(ConsensusGroupId groupId) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null || !raftGroup.getPeers().contains(this.myself)) {
            return this.failed(new PeerNotInConsensusGroupException(groupId, this.myself));
        }
        RatisClient client = null;
        try {
            client = this.getRaftClient(raftGroup);
            reply = client.getRaftClient().getGroupManagementApi(this.myself.getId()).remove(raftGroupId, true, false);
            if (!reply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusGenericResponse;
            }
        }
        catch (IOException e) {
            ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException(e));
            return consensusGenericResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse addPeer(ConsensusGroupId groupId, Peer peer) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        RaftPeer peerToAdd = Utils.fromTEndPointAndPriorityToRaftPeer(peer, 0);
        if (group == null || !group.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        if (group.getPeers().contains(peerToAdd)) {
            return this.failed(new PeerAlreadyInConsensusGroupException(groupId, peer));
        }
        ArrayList<RaftPeer> newConfig = new ArrayList<RaftPeer>(group.getPeers());
        newConfig.add(peerToAdd);
        try {
            reply = this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
        }
        catch (RatisRequestFailedException e) {
            return this.failed(e);
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse removePeer(ConsensusGroupId groupId, Peer peer) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        RaftPeer peerToRemove = Utils.fromTEndPointAndPriorityToRaftPeer(peer, 0);
        if (group == null || !group.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        if (!group.getPeers().contains(peerToRemove)) {
            return this.failed(new PeerNotInConsensusGroupException(groupId, this.myself));
        }
        List newConfig = group.getPeers().stream().filter(raftPeer -> !raftPeer.equals((Object)peerToRemove)).collect(Collectors.toList());
        try {
            reply = this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
        }
        catch (RatisRequestFailedException e) {
            return this.failed(e);
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public ConsensusGenericResponse changePeer(ConsensusGroupId groupId, List<Peer> newPeers) {
        RaftClientReply reply;
        RaftGroup raftGroup = this.buildRaftGroup(groupId, newPeers);
        if (!raftGroup.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        try {
            reply = this.sendReconfiguration(raftGroup);
        }
        catch (RatisRequestFailedException e) {
            return this.failed(new RatisRequestFailedException(e));
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsensusGenericResponse transferLeader(ConsensusGroupId groupId, Peer newLeader) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        RaftPeer newRaftLeader = Utils.fromTEndPointAndPriorityToRaftPeer(newLeader, 1);
        ArrayList<RaftPeer> newConfiguration = new ArrayList<RaftPeer>();
        for (RaftPeer raftPeer : raftGroup.getPeers()) {
            if (raftPeer.getId().equals((Object)newRaftLeader.getId())) {
                newConfiguration.add(newRaftLeader);
                continue;
            }
            newConfiguration.add(Utils.fromTEndPointAndPriorityToRaftPeer(Utils.formRaftPeerIdToTEndPoint(raftPeer.getId()), 0));
        }
        RatisClient client = null;
        try {
            client = this.getRaftClient(raftGroup);
            RaftClientReply configChangeReply = client.getRaftClient().admin().setConfiguration(newConfiguration);
            if (!configChangeReply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)configChangeReply.getException()));
                return consensusGenericResponse;
            }
            reply = client.getRaftClient().admin().transferLeadership(null, 5000L);
            if (!reply.isSuccess()) {
                ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException((Exception)reply.getException()));
                return consensusGenericResponse;
            }
        }
        catch (IOException e) {
            ConsensusGenericResponse consensusGenericResponse = this.failed(new RatisRequestFailedException(e));
            return consensusGenericResponse;
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        boolean isLeader;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            isLeader = this.server.getDivision(raftGroupId).getInfo().isLeader();
        }
        catch (IOException exception) {
            this.logger.info("isLeader request failed with exception: ", (Throwable)exception);
            isLeader = false;
        }
        return isLeader;
    }

    private boolean waitUntilLeaderReady(RaftGroupId groupId) {
        DivisionInfo divisionInfo;
        try {
            divisionInfo = this.server.getDivision(groupId).getInfo();
        }
        catch (IOException e) {
            this.logger.info("isLeaderReady checking failed with exception: ", (Throwable)e);
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            while (divisionInfo.isLeader() && !divisionInfo.isLeaderReady()) {
                Thread.sleep(10L);
                long consumedTime = System.currentTimeMillis() - startTime;
                if (consumedTime < (long)DEFAULT_WAIT_LEADER_READY_TIMEOUT) continue;
                this.logger.warn("{}: leader is still not ready after {}ms", (Object)groupId, (Object)consumedTime);
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Unexpected interruption", (Throwable)e);
            return false;
        }
        return divisionInfo.isLeader();
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        RaftPeerId leaderId;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            leaderId = this.server.getDivision(raftGroupId).getInfo().getLeaderId();
        }
        catch (IOException e) {
            this.logger.warn("fetch division info for group " + groupId + " failed due to: ", (Throwable)e);
            return null;
        }
        if (leaderId == null) {
            return null;
        }
        TEndPoint leaderEndpoint = Utils.formRaftPeerIdToTEndPoint(leaderId);
        return new Peer(groupId, leaderEndpoint);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        ArrayList<ConsensusGroupId> ids = new ArrayList<ConsensusGroupId>();
        this.server.getGroupIds().forEach(groupId -> ids.add(Utils.fromRaftGroupIdToConsensusGroupId(groupId)));
        return ids;
    }

    @Override
    public ConsensusGenericResponse triggerSnapshot(ConsensusGroupId groupId) {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup groupInfo = this.getGroupInfo(raftGroupId);
        if (groupInfo == null || !groupInfo.getPeers().contains(this.myself)) {
            return this.failed(new ConsensusGroupNotExistException(groupId));
        }
        SnapshotManagementRequest request = SnapshotManagementRequest.newCreate((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (RaftGroupId)raftGroupId, (long)this.localFakeCallId.incrementAndGet(), (long)30000L);
        try {
            reply = this.server.snapshotManagement(request);
        }
        catch (IOException ioException) {
            return this.failed(new RatisRequestFailedException(ioException));
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(reply.isSuccess()).build();
    }

    private ConsensusGenericResponse failed(ConsensusException e) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).setException(e).build();
    }

    private ConsensusWriteResponse failedWrite(ConsensusException e) {
        return ConsensusWriteResponse.newBuilder().setException(e).build();
    }

    private ConsensusReadResponse failedRead(ConsensusException e) {
        return ConsensusReadResponse.newBuilder().setException(e).build();
    }

    private RaftClientRequest buildRawRequest(RaftGroupId groupId, Message message, RaftClientRequest.Type type) {
        return RaftClientRequest.newBuilder().setServerId(this.server.getId()).setClientId(this.localFakeId).setCallId(this.localFakeCallId.incrementAndGet()).setGroupId(groupId).setType(type).setMessage(message).build();
    }

    private RaftGroup getGroupInfo(RaftGroupId raftGroupId) {
        RaftGroup raftGroup = null;
        try {
            raftGroup = this.server.getDivision(raftGroupId).getGroup();
            RaftGroup lastSeenGroup = this.lastSeen.getOrDefault(raftGroupId, null);
            if (lastSeenGroup != null && !lastSeenGroup.equals((Object)raftGroup)) {
                this.clientManager.clear((Object)lastSeenGroup);
                this.lastSeen.put(raftGroupId, raftGroup);
            }
        }
        catch (IOException e) {
            this.logger.debug("get group {} failed ", (Object)raftGroupId, (Object)e);
        }
        return raftGroup;
    }

    private RaftGroup buildRaftGroup(ConsensusGroupId groupId, List<Peer> peers) {
        return RaftGroup.valueOf((RaftGroupId)Utils.fromConsensusGroupIdToRaftGroupId(groupId), Utils.fromPeersAndPriorityToRaftPeers(peers, 0));
    }

    private RatisClient getRaftClient(RaftGroup group) throws IOException {
        try {
            return (RatisClient)this.clientManager.borrowClient((Object)group);
        }
        catch (IOException e) {
            this.logger.error(String.format("Borrow client from pool for group %s failed.", group), (Throwable)e);
            throw e;
        }
    }

    private RaftClientReply sendReconfiguration(RaftGroup newGroupConf) throws RatisRequestFailedException {
        RaftClientReply reply;
        RatisClient client = null;
        try {
            client = this.getRaftClient(newGroupConf);
            reply = client.getRaftClient().admin().setConfiguration(new ArrayList(newGroupConf.getPeers()));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (IOException e) {
            throw new RatisRequestFailedException(e);
        }
        finally {
            if (client != null) {
                client.returnSelf();
            }
        }
        return reply;
    }

    public RaftServer getServer() {
        return this.server;
    }

    private class RatisClientPoolFactory
    implements IClientPoolFactory<RaftGroup, RatisClient> {
        private RatisClientPoolFactory() {
        }

        public KeyedObjectPool<RaftGroup, RatisClient> createClientPool(ClientManager<RaftGroup, RatisClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new RatisClient.Factory(manager, new ClientFactoryProperty.Builder().build(), RatisConsensus.this.properties, RatisConsensus.this.clientRpc), new ClientPoolProperty.Builder().build().getConfig());
        }
    }
}

