/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.MultiLeaderServerImpl;
import org.apache.iotdb.consensus.multileader.client.AsyncMultiLeaderServiceClient;
import org.apache.iotdb.consensus.multileader.client.DispatchLogHandler;
import org.apache.iotdb.consensus.multileader.logdispatcher.IndexController;
import org.apache.iotdb.consensus.multileader.logdispatcher.PendingBatch;
import org.apache.iotdb.consensus.multileader.logdispatcher.SyncStatus;
import org.apache.iotdb.consensus.multileader.thrift.TLogBatch;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogReq;
import org.apache.iotdb.consensus.multileader.wal.ConsensusReqReader;
import org.apache.iotdb.consensus.multileader.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDispatcher {
    private final Logger logger = LoggerFactory.getLogger(LogDispatcher.class);
    private final MultiLeaderServerImpl impl;
    private final List<LogDispatcherThread> threads;
    private final IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager;
    private ExecutorService executorService;

    public LogDispatcher(MultiLeaderServerImpl impl, IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager) {
        this.impl = impl;
        this.clientManager = clientManager;
        this.threads = impl.getConfiguration().stream().filter(x -> !Objects.equals(x, impl.getThisNode())).map(x -> new LogDispatcherThread((Peer)x, impl.getConfig())).collect(Collectors.toList());
        if (!this.threads.isEmpty()) {
            this.executorService = IoTDBThreadPoolFactory.newFixedThreadPool((int)this.threads.size(), (String)("LogDispatcher-" + impl.getThisNode().getGroupId()));
        }
    }

    public void start() {
        if (!this.threads.isEmpty()) {
            this.threads.forEach(this.executorService::submit);
        }
    }

    public void stop() {
        if (!this.threads.isEmpty()) {
            this.threads.forEach(LogDispatcherThread::stop);
            this.executorService.shutdownNow();
            int timeout = 10;
            try {
                if (!this.executorService.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.logger.error("Unable to shutdown LogDispatcher service after {} seconds", (Object)timeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("Unexpected Interruption when closing LogDispatcher service ");
            }
        }
    }

    public OptionalLong getMinSyncIndex() {
        return this.threads.stream().mapToLong(LogDispatcherThread::getCurrentSyncIndex).min();
    }

    public void offer(IndexedConsensusRequest request) {
        this.threads.forEach(thread -> {
            this.logger.debug("{}: Push a log to the queue, where the queue length is {}", (Object)this.impl.getThisNode().getGroupId(), (Object)thread.getPendingRequest().size());
            if (!thread.getPendingRequest().offer(request)) {
                this.logger.debug("{}: Log queue of {} is full, ignore the log to this node", (Object)this.impl.getThisNode().getGroupId(), (Object)thread.getPeer());
            }
        });
    }

    public class LogDispatcherThread
    implements Runnable {
        private final MultiLeaderConfig config;
        private final Peer peer;
        private final IndexController controller;
        private final SyncStatus syncStatus;
        private final BlockingQueue<IndexedConsensusRequest> pendingRequest;
        private final List<IndexedConsensusRequest> bufferedRequest = new LinkedList<IndexedConsensusRequest>();
        private final ConsensusReqReader reader = (ConsensusReqReader)((Object)LogDispatcher.access$000(LogDispatcher.this).getStateMachine().read(new GetConsensusReqReaderPlan()));
        private volatile boolean stopped = false;

        public LogDispatcherThread(Peer peer, MultiLeaderConfig config) {
            this.peer = peer;
            this.config = config;
            this.pendingRequest = new ArrayBlockingQueue<IndexedConsensusRequest>(config.getReplication().getMaxPendingRequestNumPerNode());
            this.controller = new IndexController(LogDispatcher.this.impl.getStorageDir(), Utils.fromTEndPointToString(peer.getEndpoint()), false);
            this.syncStatus = new SyncStatus(this.controller, config);
        }

        public IndexController getController() {
            return this.controller;
        }

        public long getCurrentSyncIndex() {
            return this.controller.getCurrentIndex();
        }

        public Peer getPeer() {
            return this.peer;
        }

        public MultiLeaderConfig getConfig() {
            return this.config;
        }

        public BlockingQueue<IndexedConsensusRequest> getPendingRequest() {
            return this.pendingRequest;
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void run() {
            LogDispatcher.this.logger.info("{}: Dispatcher for {} starts", (Object)LogDispatcher.this.impl.getThisNode(), (Object)this.peer);
            try {
                while (!Thread.interrupted() && !this.stopped) {
                    PendingBatch batch;
                    while ((batch = this.getBatch()).isEmpty()) {
                        this.bufferedRequest.add(this.pendingRequest.take());
                        if (this.pendingRequest.size() > this.config.getReplication().getMaxRequestPerBatch()) continue;
                        Thread.sleep(this.config.getReplication().getMaxWaitingTimeForAccumulatingBatchInMs());
                    }
                    this.syncStatus.addNextBatch(batch);
                    this.sendBatchAsync(batch, new DispatchLogHandler(this, batch));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LogDispatcher.this.logger.error("Unexpected error in logDispatcher for peer {}", (Object)this.peer, (Object)e);
            }
            LogDispatcher.this.logger.info("{}: Dispatcher for {} exits", (Object)LogDispatcher.this.impl.getThisNode(), (Object)this.peer);
        }

        public PendingBatch getBatch() {
            PendingBatch batch;
            ArrayList<TLogBatch> logBatches = new ArrayList<TLogBatch>();
            long startIndex = this.syncStatus.getNextSendingIndex();
            long maxIndex = LogDispatcher.this.impl.getController().getCurrentIndex() + 1L;
            if (this.bufferedRequest.size() <= this.config.getReplication().getMaxRequestPerBatch()) {
                this.pendingRequest.drainTo(this.bufferedRequest, this.config.getReplication().getMaxRequestPerBatch() - this.bufferedRequest.size());
            }
            if (this.bufferedRequest.isEmpty()) {
                long endIndex = this.constructBatchFromWAL(startIndex, maxIndex, logBatches);
                batch = new PendingBatch(startIndex, endIndex, logBatches);
                LogDispatcher.this.logger.debug("{} : accumulated a {} from wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch);
            } else {
                Iterator<IndexedConsensusRequest> iterator = this.bufferedRequest.iterator();
                IndexedConsensusRequest prev = iterator.next();
                long endIndex = this.constructBatchFromWAL(startIndex, prev.getSearchIndex(), logBatches);
                if (logBatches.size() == this.config.getReplication().getMaxRequestPerBatch()) {
                    PendingBatch batch2 = new PendingBatch(startIndex, endIndex, logBatches);
                    LogDispatcher.this.logger.debug("{} : accumulated a {} from wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch2);
                    return batch2;
                }
                this.constructBatchIndexedFromConsensusRequest(prev, logBatches);
                endIndex = prev.getSearchIndex();
                iterator.remove();
                while (iterator.hasNext() && logBatches.size() <= this.config.getReplication().getMaxRequestPerBatch()) {
                    IndexedConsensusRequest current = iterator.next();
                    if (current.getSearchIndex() != prev.getSearchIndex() + 1L) {
                        endIndex = this.constructBatchFromWAL(prev.getSearchIndex(), current.getSearchIndex(), logBatches);
                        if (logBatches.size() == this.config.getReplication().getMaxRequestPerBatch()) {
                            PendingBatch batch3 = new PendingBatch(startIndex, endIndex, logBatches);
                            LogDispatcher.this.logger.debug("{} : accumulated a {} from queue and wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch3);
                            return batch3;
                        }
                    }
                    this.constructBatchIndexedFromConsensusRequest(current, logBatches);
                    endIndex = current.getSearchIndex();
                    prev = current;
                    iterator.remove();
                }
                batch = new PendingBatch(startIndex, endIndex, logBatches);
                LogDispatcher.this.logger.debug("{} : accumulated a {} from queue and wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch);
            }
            return batch;
        }

        public void sendBatchAsync(PendingBatch batch, DispatchLogHandler handler) {
            try {
                AsyncMultiLeaderServiceClient client = (AsyncMultiLeaderServiceClient)((Object)LogDispatcher.this.clientManager.borrowClient((Object)this.peer.getEndpoint()));
                TSyncLogReq req = new TSyncLogReq(this.peer.getGroupId().convertToTConsensusGroupId(), batch.getBatches());
                client.syncLog(req, handler);
            }
            catch (IOException | TException e) {
                LogDispatcher.this.logger.error("Can not sync logs to peer {} because", (Object)this.peer, (Object)e);
            }
        }

        public SyncStatus getSyncStatus() {
            return this.syncStatus;
        }

        private long constructBatchFromWAL(long currentIndex, long maxIndex, List<TLogBatch> logBatches) {
            while (currentIndex < maxIndex && logBatches.size() < this.config.getReplication().getMaxRequestPerBatch()) {
                IConsensusRequest data;
                if ((data = this.reader.getReq(currentIndex++)) == null) continue;
                logBatches.add(new TLogBatch(data.serializeToByteBuffer()));
            }
            return currentIndex - 1L;
        }

        private void constructBatchIndexedFromConsensusRequest(IndexedConsensusRequest request, List<TLogBatch> logBatches) {
            logBatches.add(new TLogBatch(request.serializeToByteBuffer()));
        }
    }
}

