/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.client;

import java.io.IOException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.AsyncBaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.consensus.multileader.thrift.MultiLeaderConsensusIService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMultiLeaderServiceClient
extends MultiLeaderConsensusIService.AsyncClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncMultiLeaderServiceClient.class);
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager;

    public AsyncMultiLeaderServiceClient(TProtocolFactory protocolFactory, int connectionTimeout, TEndPoint endpoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager) throws IOException {
        super(protocolFactory, tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)connectionTimeout));
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    public void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    private void returnSelf() {
        if (this.clientManager != null) {
            this.clientManager.returnClient((Object)this.endpoint, (Object)this);
        }
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        this.returnSelf();
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            logger.info("Unexpected exception occurs in {} :", (Object)this, (Object)e);
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncConfigNodeIServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends AsyncBaseClientFactory<TEndPoint, AsyncMultiLeaderServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager, ClientFactoryProperty clientFactoryProperty) {
            super(clientManager, clientFactoryProperty);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncMultiLeaderServiceClient> pooledObject) {
            ((AsyncMultiLeaderServiceClient)((Object)pooledObject.getObject())).close();
        }

        public PooledObject<AsyncMultiLeaderServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            TAsyncClientManager tManager = this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length];
            tManager = tManager == null ? new TAsyncClientManager() : tManager;
            return new DefaultPooledObject((Object)new AsyncMultiLeaderServiceClient(this.clientFactoryProperty.getProtocolFactory(), this.clientFactoryProperty.getConnectionTimeoutMs(), endPoint, tManager, (ClientManager<TEndPoint, AsyncMultiLeaderServiceClient>)this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncMultiLeaderServiceClient> pooledObject) {
            return pooledObject.getObject() != null && ((AsyncMultiLeaderServiceClient)((Object)pooledObject.getObject())).isReady();
        }
    }
}

