/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import java.util.concurrent.TimeUnit;

public class MultiLeaderConfig {
    private final RPC rpc;
    private final Replication replication;

    private MultiLeaderConfig(RPC rpc, Replication replication) {
        this.rpc = rpc;
        this.replication = replication;
    }

    public RPC getRpc() {
        return this.rpc;
    }

    public Replication getReplication() {
        return this.replication;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Replication {
        private final int maxPendingRequestNumPerNode;
        private final int maxRequestPerBatch;
        private final int maxPendingBatch;
        private final int maxWaitingTimeForAccumulatingBatchInMs;
        private final long basicRetryWaitTimeMs;
        private final long maxRetryWaitTimeMs;

        private Replication(int maxPendingRequestNumPerNode, int maxRequestPerBatch, int maxPendingBatch, int maxWaitingTimeForAccumulatingBatchInMs, long basicRetryWaitTimeMs, long maxRetryWaitTimeMs) {
            this.maxPendingRequestNumPerNode = maxPendingRequestNumPerNode;
            this.maxRequestPerBatch = maxRequestPerBatch;
            this.maxPendingBatch = maxPendingBatch;
            this.maxWaitingTimeForAccumulatingBatchInMs = maxWaitingTimeForAccumulatingBatchInMs;
            this.basicRetryWaitTimeMs = basicRetryWaitTimeMs;
            this.maxRetryWaitTimeMs = maxRetryWaitTimeMs;
        }

        public int getMaxPendingRequestNumPerNode() {
            return this.maxPendingRequestNumPerNode;
        }

        public int getMaxRequestPerBatch() {
            return this.maxRequestPerBatch;
        }

        public int getMaxPendingBatch() {
            return this.maxPendingBatch;
        }

        public int getMaxWaitingTimeForAccumulatingBatchInMs() {
            return this.maxWaitingTimeForAccumulatingBatchInMs;
        }

        public long getBasicRetryWaitTimeMs() {
            return this.basicRetryWaitTimeMs;
        }

        public long getMaxRetryWaitTimeMs() {
            return this.maxRetryWaitTimeMs;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int maxPendingRequestNumPerNode = 200;
            private int maxRequestPerBatch = 40;
            private int maxPendingBatch = 6;
            private int maxWaitingTimeForAccumulatingBatchInMs = 500;
            private long basicRetryWaitTimeMs = TimeUnit.MILLISECONDS.toMillis(100L);
            private long maxRetryWaitTimeMs = TimeUnit.SECONDS.toMillis(20L);

            public Builder setMaxPendingRequestNumPerNode(int maxPendingRequestNumPerNode) {
                this.maxPendingRequestNumPerNode = maxPendingRequestNumPerNode;
                return this;
            }

            public Builder setMaxRequestPerBatch(int maxRequestPerBatch) {
                this.maxRequestPerBatch = maxRequestPerBatch;
                return this;
            }

            public Builder setMaxPendingBatch(int maxPendingBatch) {
                this.maxPendingBatch = maxPendingBatch;
                return this;
            }

            public Builder setMaxWaitingTimeForAccumulatingBatchInMs(int maxWaitingTimeForAccumulatingBatchInMs) {
                this.maxWaitingTimeForAccumulatingBatchInMs = maxWaitingTimeForAccumulatingBatchInMs;
                return this;
            }

            public Builder setBasicRetryWaitTimeMs(long basicRetryWaitTimeMs) {
                this.basicRetryWaitTimeMs = basicRetryWaitTimeMs;
                return this;
            }

            public Builder setMaxRetryWaitTimeMs(long maxRetryWaitTimeMs) {
                this.maxRetryWaitTimeMs = maxRetryWaitTimeMs;
                return this;
            }

            public Replication build() {
                return new Replication(this.maxPendingRequestNumPerNode, this.maxRequestPerBatch, this.maxPendingBatch, this.maxWaitingTimeForAccumulatingBatchInMs, this.basicRetryWaitTimeMs, this.maxRetryWaitTimeMs);
            }
        }
    }

    public static class RPC {
        private final int rpcMaxConcurrentClientNum;
        private final int thriftServerAwaitTimeForStopService;
        private final boolean isRpcThriftCompressionEnabled;
        private final int selectorNumOfClientManager;
        private final int connectionTimeoutInMs;

        private RPC(int rpcMaxConcurrentClientNum, int thriftServerAwaitTimeForStopService, boolean isRpcThriftCompressionEnabled, int selectorNumOfClientManager, int connectionTimeoutInMs) {
            this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
            this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
            this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
            this.selectorNumOfClientManager = selectorNumOfClientManager;
            this.connectionTimeoutInMs = connectionTimeoutInMs;
        }

        public int getRpcMaxConcurrentClientNum() {
            return this.rpcMaxConcurrentClientNum;
        }

        public int getThriftServerAwaitTimeForStopService() {
            return this.thriftServerAwaitTimeForStopService;
        }

        public boolean isRpcThriftCompressionEnabled() {
            return this.isRpcThriftCompressionEnabled;
        }

        public int getSelectorNumOfClientManager() {
            return this.selectorNumOfClientManager;
        }

        public int getConnectionTimeoutInMs() {
            return this.connectionTimeoutInMs;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int rpcMaxConcurrentClientNum = 65535;
            private int thriftServerAwaitTimeForStopService = 60;
            private boolean isRpcThriftCompressionEnabled = false;
            private int selectorNumOfClientManager = 1;
            private int connectionTimeoutInMs = (int)TimeUnit.SECONDS.toMillis(20L);

            public Builder setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
                this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
                return this;
            }

            public Builder setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
                this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
                return this;
            }

            public Builder setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
                this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
                return this;
            }

            public Builder setSelectorNumOfClientManager(int selectorNumOfClientManager) {
                this.selectorNumOfClientManager = selectorNumOfClientManager;
                return this;
            }

            public Builder setConnectionTimeoutInMs(int connectionTimeoutInMs) {
                this.connectionTimeoutInMs = connectionTimeoutInMs;
                return this;
            }

            public RPC build() {
                return new RPC(this.rpcMaxConcurrentClientNum, this.thriftServerAwaitTimeForStopService, this.isRpcThriftCompressionEnabled, this.selectorNumOfClientManager, this.connectionTimeoutInMs);
            }
        }
    }

    public static class Builder {
        private RPC rpc;
        private Replication replication;

        public MultiLeaderConfig build() {
            return new MultiLeaderConfig(this.rpc != null ? this.rpc : new RPC.Builder().build(), this.replication != null ? this.replication : new Replication.Builder().build());
        }

        public Builder setRpc(RPC rpc) {
            this.rpc = rpc;
            return this;
        }

        public Builder setReplication(Replication replication) {
            this.replication = replication;
            return this;
        }
    }
}

