/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.common;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;

public class Peer {
    private final ConsensusGroupId groupId;
    private final TEndPoint endpoint;

    public Peer(ConsensusGroupId groupId, TEndPoint endpoint) {
        this.groupId = groupId;
        this.endpoint = endpoint;
    }

    public ConsensusGroupId getGroupId() {
        return this.groupId;
    }

    public TEndPoint getEndpoint() {
        return this.endpoint;
    }

    public void serialize(DataOutputStream stream) {
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.groupId.convertToTConsensusGroupId(), (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTEndPoint((TEndPoint)this.endpoint, (DataOutputStream)stream);
    }

    public static Peer deserialize(ByteBuffer buffer) {
        return new Peer(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer)), ThriftCommonsSerDeUtils.deserializeTEndPoint((ByteBuffer)buffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        return Objects.equals(this.groupId, peer.groupId) && Objects.equals(this.endpoint, peer.endpoint);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.endpoint);
    }

    public String toString() {
        return "Peer{groupId=" + this.groupId + ", endpoint=" + this.endpoint + '}';
    }
}

