/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.pool;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.session.pool.SessionDataSetWrapper;
import org.apache.iotdb.session.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    public static final String SESSION_POOL_IS_CLOSED = "Session pool is closed";
    public static final String CLOSE_THE_SESSION_FAILED = "close the session failed.";
    private static final int RETRY = 3;
    private static final int FINAL_RETRY = 2;
    private final ConcurrentLinkedDeque<Session> queue = new ConcurrentLinkedDeque();
    private final ConcurrentMap<Session, Session> occupied = new ConcurrentHashMap<Session, Session>();
    private int size = 0;
    private int maxSize = 0;
    private final long waitToGetSessionTimeoutInMs;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final int fetchSize;
    private final ZoneId zoneId;
    private final boolean enableCacheLeader;
    private final int connectionTimeoutInMs;
    private final boolean enableCompression;
    private boolean closed;
    private final List<String> nodeUrls;

    public SessionPool(String host, int port, String user, String password, int maxSize) {
        this(host, port, user, password, maxSize, 5000, 60000L, false, null, true, 0);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, false, null, true, 0);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, boolean enableCompression) {
        this(host, port, user, password, maxSize, 5000, 60000L, enableCompression, null, true, 0);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, boolean enableCompression) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, enableCompression, null, true, 0);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, boolean enableCompression, boolean enableCacheLeader) {
        this(host, port, user, password, maxSize, 5000, 60000L, enableCompression, null, enableCacheLeader, 0);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, boolean enableCompression, boolean enableCacheLeader) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, enableCompression, null, enableCacheLeader, 0);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, ZoneId zoneId) {
        this(host, port, user, password, maxSize, 5000, 60000L, false, zoneId, true, 0);
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, ZoneId zoneId) {
        this(nodeUrls, user, password, maxSize, 5000, 60000L, false, zoneId, true, 0);
    }

    public SessionPool(String host, int port, String user, String password, int maxSize, int fetchSize, long waitToGetSessionTimeoutInMs, boolean enableCompression, ZoneId zoneId, boolean enableCacheLeader, int connectionTimeoutInMs) {
        this.maxSize = maxSize;
        this.host = host;
        this.port = port;
        this.nodeUrls = null;
        this.user = user;
        this.password = password;
        this.fetchSize = fetchSize;
        this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
        this.enableCompression = enableCompression;
        this.zoneId = zoneId;
        this.enableCacheLeader = enableCacheLeader;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public SessionPool(List<String> nodeUrls, String user, String password, int maxSize, int fetchSize, long waitToGetSessionTimeoutInMs, boolean enableCompression, ZoneId zoneId, boolean enableCacheLeader, int connectionTimeoutInMs) {
        this.maxSize = maxSize;
        this.host = null;
        this.port = -1;
        this.nodeUrls = nodeUrls;
        this.user = user;
        this.password = password;
        this.fetchSize = fetchSize;
        this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
        this.enableCompression = enableCompression;
        this.zoneId = zoneId;
        this.enableCacheLeader = enableCacheLeader;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    private Session constructNewSession() {
        Session session = this.nodeUrls == null ? new Session.Builder().host(this.host).port(this.port).username(this.user).password(this.password).fetchSize(this.fetchSize).zoneId(this.zoneId).enableCacheLeader(this.enableCacheLeader).build() : new Session.Builder().nodeUrls(this.nodeUrls).username(this.user).password(this.password).fetchSize(this.fetchSize).zoneId(this.zoneId).enableCacheLeader(this.enableCacheLeader).build();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() throws IoTDBConnectionException {
        SessionPool sessionPool;
        Session session = this.queue.poll();
        if (this.closed) {
            throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
        }
        if (session != null) {
            return session;
        }
        boolean shouldCreate = false;
        long start = System.currentTimeMillis();
        while (session == null) {
            sessionPool = this;
            synchronized (sessionPool) {
                if (this.size < this.maxSize) {
                    ++this.size;
                    shouldCreate = true;
                    break;
                }
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("no more sessions can be created, wait... queue.size={}", (Object)this.queue.size());
                    }
                    this.wait(1000L);
                    long timeOut = Math.min(this.waitToGetSessionTimeoutInMs, 60000L);
                    if (System.currentTimeMillis() - start > timeOut) {
                        logger.warn("the SessionPool has wait for {} seconds to get a new connection: {}:{} with {}, {}", new Object[]{(System.currentTimeMillis() - start) / 1000L, this.host, this.port, this.user, this.password});
                        logger.warn("current occupied size {}, queue size {}, considered size {} ", new Object[]{this.occupied.size(), this.queue.size(), this.size});
                        if (System.currentTimeMillis() - start > this.waitToGetSessionTimeoutInMs) {
                            throw new IoTDBConnectionException(String.format("timeout to get a connection from %s:%s", this.host, this.port));
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                session = this.queue.poll();
                if (this.closed) {
                    throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                }
            }
        }
        if (shouldCreate) {
            if (logger.isDebugEnabled()) {
                if (this.nodeUrls == null) {
                    logger.debug("Create a new Session {}, {}, {}, {}", new Object[]{this.host, this.port, this.user, this.password});
                } else {
                    logger.debug("Create a new redirect Session {}, {}, {}", new Object[]{this.nodeUrls, this.user, this.password});
                }
            }
            session = this.constructNewSession();
            try {
                session.open(this.enableCompression, this.connectionTimeoutInMs);
                sessionPool = this;
                synchronized (sessionPool) {
                    if (this.closed) {
                        session.close();
                        throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                    }
                }
            }
            catch (IoTDBConnectionException e) {
                SessionPool sessionPool2 = this;
                synchronized (sessionPool2) {
                    --this.size;
                    this.notify();
                    if (logger.isDebugEnabled()) {
                        logger.debug("open session failed, reduce the count and notify others...");
                    }
                }
                throw e;
            }
        }
        return session;
    }

    public int currentAvailableSize() {
        return this.queue.size();
    }

    public int currentOccupiedSize() {
        return this.occupied.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBack(Session session) {
        this.queue.push(session);
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            this.notify();
        }
    }

    private void occupy(Session session) {
        this.occupied.put(session, session);
    }

    public synchronized void close() {
        for (Session session : this.queue) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException e) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e);
            }
        }
        for (Session session : this.occupied.keySet()) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException e) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e);
            }
        }
        logger.info("closing the session pool, cleaning queues...");
        this.closed = true;
        this.queue.clear();
        this.occupied.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet(SessionDataSetWrapper wrapper) {
        boolean putback = true;
        try {
            wrapper.sessionDataSet.closeOperationHandle();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            this.tryConstructNewSession();
            putback = false;
        }
        finally {
            Session session = (Session)this.occupied.remove(wrapper.session);
            if (putback && session != null) {
                this.putBack(wrapper.session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConstructNewSession() {
        Session session = this.constructNewSession();
        try {
            session.open(this.enableCompression, this.connectionTimeoutInMs);
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                if (this.closed) {
                    session.close();
                    throw new IoTDBConnectionException(SESSION_POOL_IS_CLOSED);
                }
                this.queue.push(session);
                this.notify();
            }
        }
        catch (IoTDBConnectionException e) {
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                --this.size;
                this.notify();
                if (logger.isDebugEnabled()) {
                    logger.debug("open session failed, reduce the count and notify others...");
                }
            }
        }
    }

    private void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e2) {
                logger.warn(CLOSE_THE_SESSION_FAILED, (Throwable)e2);
            }
        }
    }

    private void cleanSessionAndMayThrowConnectionException(Session session, int times, IoTDBConnectionException e) throws IoTDBConnectionException {
        this.closeSession(session);
        this.tryConstructNewSession();
        if (times == 2) {
            throw new IoTDBConnectionException(String.format("retry to execute statement on %s:%s failed %d times: %s", this.host, this.port, 3, e.getMessage()), (Throwable)e);
        }
    }

    public void insertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablet(tablet, false);
    }

    public void insertAlignedTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedRecords(List<String> multiSeriesIds, List<Long> times, List<List<String>> multiMeasurementComponentsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedRecords(multiSeriesIds, times, multiMeasurementComponentsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    @Deprecated
    public void insertOneDeviceRecords(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    @Deprecated
    public void insertOneDeviceRecords(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, haveSorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedStringRecordsOfOneDevice failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedRecords(List<String> multiSeriesIds, List<Long> times, List<List<String>> multiMeasurementComponentsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedRecords(multiSeriesIds, times, multiMeasurementComponentsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedRecord(String multiSeriesId, long time, List<String> multiMeasurementComponents, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedRecord(multiSeriesId, time, multiMeasurementComponents, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertAlignedRecord(String multiSeriesId, long time, List<String> multiMeasurementComponents, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.insertAlignedRecord(multiSeriesId, time, multiMeasurementComponents, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("insertAlignedRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertTablet(tablet);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablet failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertTablets(tablets);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertTablets failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecords failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("testInsertRecord failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteTimeseries(path);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteTimeseries(paths);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(String path, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(path, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(List<String> paths, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(paths, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(paths, startTime, endTime);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteData failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void setStorageGroup(String storageGroupId) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.setStorageGroup(storageGroupId);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("setStorageGroup failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteStorageGroup(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteStorageGroup failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteStorageGroups(List<String> storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteStorageGroups(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteStorageGroups failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createMultiTimeseries(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createMultiTimeseries failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                boolean resp = session.checkTimeseriesExists(path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("checkTimeseriesExists failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return false;
    }

    public void createSchemaTemplate(Template template) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createSchemaTemplate(template);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createSchemaTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createSchemaTemplate(String templateName, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createSchemaTemplate(templateName, measurements, dataTypes, encodings, compressors, isAligned);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createSchemaTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    @Deprecated
    public void createSchemaTemplate(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<CompressionType> compressors) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.createSchemaTemplate(name, schemaNames, measurements, dataTypes, encodings, compressors);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("createSchemaTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void addAlignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.addAlignedMeasurementsInTemplate(templateName, measurementsPath, dataTypes, encodings, compressors);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addAlignedMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void addAlignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.addAlignedMeasurementInTemplate(templateName, measurementPath, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addAlignedMeasurementInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void addUnalignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.addUnalignedMeasurementsInTemplate(templateName, measurementsPath, dataTypes, encodings, compressors);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addUnalignedMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void addUnalignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.addUnalignedMeasurementInTemplate(templateName, measurementPath, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("addUnalignedMeasurementInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteNodeInTemplate(String templateName, String path) throws IOException, IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.deleteNodeInTemplate(templateName, path);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("deleteNodeInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public int countMeasurementsInTemplate(String name) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                int resp = session.countMeasurementsInTemplate(name);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("countMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return -1;
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                boolean resp = session.isMeasurementInTemplate(templateName, path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("isMeasurementInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return false;
    }

    public boolean isPathExistInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                boolean resp = session.isPathExistInTemplate(templateName, path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("isPathExistInTemplata failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return false;
    }

    public List<String> showMeasurementsInTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                List<String> resp = session.showMeasurementsInTemplate(templateName);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public List<String> showMeasurementsInTemplate(String templateName, String pattern) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                List<String> resp = session.showMeasurementsInTemplate(templateName, pattern);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showMeasurementsInTemplate failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                List<String> resp = session.showAllTemplates();
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showAllTemplates failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public List<String> showPathsTemplateSetOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                List<String> resp = session.showPathsTemplateSetOn(templateName);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showPathsTemplateSetOn failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public List<String> showPathsTemplateUsingOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                List<String> resp = session.showPathsTemplateUsingOn(templateName);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("showPathsTemplateUsingOn failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public void setSchemaTemplate(String templateName, String prefixPath) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.setSchemaTemplate(templateName, prefixPath);
                this.putBack(session);
                continue;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("setSchemaTemplate [%s] on [%s] failed", templateName, prefixPath), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void unsetSchemaTemplate(String prefixPath, String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.unsetSchemaTemplate(prefixPath, templateName);
                this.putBack(session);
                continue;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("unsetSchemaTemplate [%s] on [%s] failed", templateName, prefixPath), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void dropSchemaTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.dropSchemaTemplate(templateName);
                this.putBack(session);
                continue;
            }
            catch (IoTDBConnectionException e) {
                logger.warn(String.format("dropSchemaTemplate [%s] failed", templateName), (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public SessionDataSetWrapper executeQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                SessionDataSet resp = session.executeQueryStatement(sql);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public SessionDataSetWrapper executeQueryStatement(String sql, long timeoutInMs) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                SessionDataSet resp = session.executeQueryStatement(sql, timeoutInMs);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public void executeNonQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                session.executeNonQueryStatement(sql);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeNonQueryStatement failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public SessionDataSetWrapper executeRawDataQuery(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < 3; ++i) {
            Session session = this.getSession();
            try {
                SessionDataSet resp = session.executeRawDataQuery(paths, startTime, endTime);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                logger.warn("executeRawDataQuery failed", (Throwable)e);
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (RuntimeException | StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public long getWaitToGetSessionTimeoutInMs() {
        return this.waitToGetSessionTimeoutInMs;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public boolean isEnableCacheLeader() {
        return this.enableCacheLeader;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 6667;
        private List<String> nodeUrls = null;
        private int maxSize = 5;
        private String user = "root";
        private String password = "root";
        private int fetchSize = 5000;
        private long waitToGetSessionTimeoutInMs = 60000L;
        private boolean enableCompression = false;
        private ZoneId zoneId = null;
        private boolean enableCacheLeader = true;
        private int connectionTimeoutInMs = 0;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder waitToGetSessionTimeoutInMs(long waitToGetSessionTimeoutInMs) {
            this.waitToGetSessionTimeoutInMs = waitToGetSessionTimeoutInMs;
            return this;
        }

        public Builder enableCompression(boolean enableCompression) {
            this.enableCompression = enableCompression;
            return this;
        }

        public Builder enableCacheLeader(boolean enableCacheLeader) {
            this.enableCacheLeader = enableCacheLeader;
            return this;
        }

        public Builder connectionTimeoutInMs(int connectionTimeoutInMs) {
            this.connectionTimeoutInMs = connectionTimeoutInMs;
            return this;
        }

        public SessionPool build() {
            if (this.nodeUrls == null) {
                return new SessionPool(this.host, this.port, this.user, this.password, this.maxSize, this.fetchSize, this.waitToGetSessionTimeoutInMs, this.enableCompression, this.zoneId, this.enableCacheLeader, this.connectionTimeoutInMs);
            }
            return new SessionPool(this.nodeUrls, this.user, this.password, this.maxSize, this.fetchSize, this.waitToGetSessionTimeoutInMs, this.enableCompression, this.zoneId, this.enableCacheLeader, this.connectionTimeoutInMs);
        }
    }
}

