/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.service;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.multileader.MultiLeaderConsensus;
import org.apache.iotdb.consensus.multileader.MultiLeaderServerImpl;
import org.apache.iotdb.consensus.multileader.thrift.MultiLeaderConsensusIService;
import org.apache.iotdb.consensus.multileader.thrift.TLogBatch;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogReq;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderRPCServiceProcessor
implements MultiLeaderConsensusIService.Iface {
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderRPCServiceProcessor.class);
    private final MultiLeaderConsensus consensus;

    public MultiLeaderRPCServiceProcessor(MultiLeaderConsensus consensus) {
        this.consensus = consensus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSyncLogRes syncLog(TSyncLogReq req) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("Unexpected consensusGroupId %s for TSyncLogReq which size is %s", groupId, req.getBatches().size());
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            return new TSyncLogRes(Collections.singletonList(status));
        }
        ArrayList<TSStatus> statuses = new ArrayList<TSStatus>();
        IStateMachine iStateMachine = impl.getStateMachine();
        synchronized (iStateMachine) {
            for (TLogBatch batch : req.getBatches()) {
                statuses.add(impl.getStateMachine().write(impl.buildIndexedConsensusRequestForRemoteRequest(new ByteBufferConsensusRequest(batch.data))));
            }
        }
        this.logger.debug("Execute TSyncLogReq for {} with result {}", (Object)req.consensusGroupId, statuses);
        return new TSyncLogRes(statuses);
    }

    public void handleClientExit() {
    }
}

