/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.BinaryTVList;
import org.apache.iotdb.db.utils.datastructure.BooleanTVList;
import org.apache.iotdb.db.utils.datastructure.DoubleTVList;
import org.apache.iotdb.db.utils.datastructure.FloatTVList;
import org.apache.iotdb.db.utils.datastructure.IntTVList;
import org.apache.iotdb.db.utils.datastructure.LongTVList;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class TVList
implements WALEntryValue {
    protected static final int SMALL_ARRAY_LENGTH = 32;
    protected static final String ERR_DATATYPE_NOT_CONSISTENT = "DataType not consistent";
    protected List<long[]> timestamps = new ArrayList<long[]>();
    protected int rowCount = 0;
    protected long[][] sortedTimestamps;
    protected boolean sorted = true;
    protected AtomicInteger referenceCount;
    protected long pivotTime;
    protected long minTime = Long.MAX_VALUE;
    private long version;

    public TVList() {
        this.referenceCount = new AtomicInteger();
    }

    public static TVList newList(TSDataType dataType) {
        switch (dataType) {
            case TEXT: {
                return new BinaryTVList();
            }
            case FLOAT: {
                return new FloatTVList();
            }
            case INT32: {
                return new IntTVList();
            }
            case INT64: {
                return new LongTVList();
            }
            case DOUBLE: {
                return new DoubleTVList();
            }
            case BOOLEAN: {
                return new BooleanTVList();
            }
        }
        return null;
    }

    public static long tvListArrayMemCost(TSDataType type) {
        long size = 0L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 8L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 2L;
        return size += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2L;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void increaseReferenceCount() {
        this.referenceCount.incrementAndGet();
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public int rowCount() {
        return this.rowCount;
    }

    public long getTime(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.timestamps.get(arrayIndex)[elementIndex];
    }

    public void putLong(long time, long value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putInt(long time, int value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putFloat(long time, float value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putDouble(long time, double value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBinary(long time, Binary value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBoolean(long time, boolean value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putAlignedValue(long time, Object[] value, int[] columnIndexArray) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putLongs(long[] time, long[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putInts(long[] time, int[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putFloats(long[] time, float[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putDoubles(long[] time, double[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBinaries(long[] time, Binary[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBooleans(long[] time, boolean[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putAlignedValues(long[] time, Object[] value, BitMap[] bitMaps, int[] columnIndexArray, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public long getLong(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public int getInt(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public float getFloat(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public double getDouble(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public Binary getBinary(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public boolean getBoolean(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public Object getAlignedValue(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public TVList getTvListByColumnIndex(List<Integer> columnIndexList, List<TSDataType> dataTypeList) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public int getValueIndex(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public abstract void sort();

    public long getMinTime() {
        return this.minTime;
    }

    public long getVersion() {
        return this.version;
    }

    protected abstract void set(int var1, int var2);

    protected abstract void setFromSorted(int var1, int var2);

    protected abstract void setToSorted(int var1, int var2);

    protected abstract void reverseRange(int var1, int var2);

    protected abstract void expandValues();

    public abstract TVList clone();

    public TVList clone(long version) {
        this.version = version;
        return this.clone();
    }

    protected abstract void releaseLastValueArray();

    protected void releaseLastTimeArray() {
        PrimitiveArrayManager.release(this.timestamps.remove(this.timestamps.size() - 1));
    }

    public int delete(long lowerBound, long upperBound) {
        int newSize = 0;
        this.minTime = Long.MAX_VALUE;
        for (int i = 0; i < this.rowCount; ++i) {
            long time = this.getTime(i);
            if (time >= lowerBound && time <= upperBound) continue;
            this.set(i, newSize++);
            this.minTime = Math.min(time, this.minTime);
        }
        int deletedNumber = this.rowCount - newSize;
        this.rowCount = newSize;
        int newArrayNum = newSize / PrimitiveArrayManager.ARRAY_SIZE;
        if (newSize % PrimitiveArrayManager.ARRAY_SIZE != 0) {
            ++newArrayNum;
        }
        int oldArrayNum = this.timestamps.size();
        for (int releaseIdx = newArrayNum; releaseIdx < oldArrayNum; ++releaseIdx) {
            this.releaseLastTimeArray();
            this.releaseLastValueArray();
        }
        return deletedNumber;
    }

    protected void cloneAs(TVList cloneList) {
        for (long[] timestampArray : this.timestamps) {
            cloneList.timestamps.add(this.cloneTime(timestampArray));
        }
        cloneList.rowCount = this.rowCount;
        cloneList.sorted = this.sorted;
        cloneList.minTime = this.minTime;
    }

    public void clear() {
        this.rowCount = 0;
        this.sorted = true;
        this.minTime = Long.MAX_VALUE;
        this.clearTime();
        this.clearSortedTime();
        this.clearValue();
        this.clearSortedValue();
    }

    protected void clearTime() {
        if (this.timestamps != null) {
            for (long[] dataArray : this.timestamps) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.timestamps.clear();
        }
    }

    protected void clearSortedTime() {
        if (this.sortedTimestamps != null) {
            this.sortedTimestamps = null;
        }
    }

    abstract void clearValue();

    abstract void clearSortedValue();

    protected void checkExpansion() {
        if (this.rowCount % PrimitiveArrayManager.ARRAY_SIZE == 0) {
            this.expandValues();
            this.timestamps.add((long[])this.getPrimitiveArraysByType(TSDataType.INT64));
        }
    }

    protected Object getPrimitiveArraysByType(TSDataType dataType) {
        return PrimitiveArrayManager.allocate(dataType);
    }

    protected long[] cloneTime(long[] array) {
        long[] cloneArray = new long[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    protected void sort(int lo, int hi) {
        if (this.sorted) {
            return;
        }
        if (lo == hi) {
            return;
        }
        if (hi - lo <= 32) {
            int initRunLen = this.countRunAndMakeAscending(lo, hi);
            this.binarySort(lo, hi, lo + initRunLen);
            return;
        }
        int mid = lo + hi >>> 1;
        this.sort(lo, mid);
        this.sort(mid, hi);
        this.merge(lo, mid, hi);
    }

    protected int countRunAndMakeAscending(int lo, int hi) {
        assert (lo < hi);
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (this.getTime(runHi++) < this.getTime(lo)) {
            while (runHi < hi && this.getTime(runHi) < this.getTime(runHi - 1)) {
                ++runHi;
            }
            this.reverseRange(lo, runHi);
        } else {
            while (runHi < hi && this.getTime(runHi) >= this.getTime(runHi - 1)) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    protected int compare(int idx1, int idx2) {
        long t1 = this.getTime(idx1);
        long t2 = this.getTime(idx2);
        return Long.compare(t1, t2);
    }

    protected abstract void saveAsPivot(int var1);

    protected abstract void setPivotTo(int var1);

    protected void binarySort(int lo, int hi, int start) {
        assert (lo <= start && start <= hi);
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            int n;
            this.saveAsPivot(start);
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                if (this.compare(start, mid) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            for (int i = n = start - left; i >= 1; --i) {
                this.set(left + i - 1, left + i);
            }
            this.setPivotTo(left);
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setToSorted(i, i);
        }
    }

    protected void merge(int lo, int mid, int hi) {
        int end;
        int start;
        int tmpIdx = 0;
        int leftIdx = lo;
        int rightIdx = mid;
        int endSide = 0;
        while (endSide == 0) {
            if (this.compare(leftIdx, rightIdx) <= 0) {
                this.setToSorted(leftIdx, lo + tmpIdx);
                ++tmpIdx;
                if (++leftIdx != mid) continue;
                endSide = 1;
                continue;
            }
            this.setToSorted(rightIdx, lo + tmpIdx);
            ++tmpIdx;
            if (++rightIdx != hi) continue;
            endSide = 2;
        }
        if (endSide == 1) {
            start = rightIdx;
            end = hi;
        } else {
            start = leftIdx;
            end = mid;
        }
        while (start < end) {
            this.setToSorted(start, lo + tmpIdx);
            ++tmpIdx;
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setFromSorted(i, i);
        }
    }

    void updateMinTimeAndSorted(long[] time, int start, int end) {
        int length = time.length;
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        for (int i = start; i < end; ++i) {
            inPutMinTime = Math.min(inPutMinTime, time[i]);
            if (!inputSorted || i >= length - 1 || time[i] <= time[i + 1]) continue;
            inputSorted = false;
        }
        this.minTime = Math.min(inPutMinTime, this.minTime);
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
    }

    public abstract TimeValuePair getTimeValuePair(int var1);

    protected abstract TimeValuePair getTimeValuePair(int var1, long var2, Integer var4, TSEncoding var5);

    public TsBlock buildTsBlock() {
        return this.buildTsBlock(0, TSEncoding.PLAIN, null);
    }

    public TsBlock buildTsBlock(int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.getDataType()));
        this.writeValidValuesIntoTsBlock(builder, floatPrecision, encoding, deletionList);
        return builder.build();
    }

    protected abstract void writeValidValuesIntoTsBlock(TsBlockBuilder var1, int var2, TSEncoding var3, List<TimeRange> var4);

    protected boolean isPointDeleted(long timestamp, List<TimeRange> deletionList, Integer deleteCursor) {
        while (deletionList != null && deleteCursor < deletionList.size()) {
            if (deletionList.get(deleteCursor).contains(timestamp)) {
                return true;
            }
            if (deletionList.get(deleteCursor).getMax() < timestamp) {
                Integer n = deleteCursor;
                Integer n2 = deleteCursor = Integer.valueOf(deleteCursor + 1);
                continue;
            }
            return false;
        }
        return false;
    }

    protected float roundValueWithGivenPrecision(float value, int floatPrecision, TSEncoding encoding) {
        if (!(Float.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            return MathUtils.roundWithGivenPrecision(value, floatPrecision);
        }
        return value;
    }

    protected double roundValueWithGivenPrecision(double value, int floatPrecision, TSEncoding encoding) {
        if (!(Double.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            return MathUtils.roundWithGivenPrecision(value, floatPrecision);
        }
        return value;
    }

    public abstract TSDataType getDataType();

    public static TVList deserialize(DataInputStream stream) throws IOException {
        TSDataType dataType = ReadWriteIOUtils.readDataType((InputStream)stream);
        switch (dataType) {
            case TEXT: {
                return BinaryTVList.deserialize(stream);
            }
            case FLOAT: {
                return FloatTVList.deserialize(stream);
            }
            case INT32: {
                return IntTVList.deserialize(stream);
            }
            case INT64: {
                return LongTVList.deserialize(stream);
            }
            case DOUBLE: {
                return DoubleTVList.deserialize(stream);
            }
            case BOOLEAN: {
                return BooleanTVList.deserialize(stream);
            }
            case VECTOR: {
                return AlignedTVList.deserialize(stream);
            }
        }
        return null;
    }
}

