/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.validate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileValidationTool {
    private static boolean printDetails = false;
    private static boolean printToFile = false;
    private static String outFilePath = "TsFile_validation_view.txt";
    private static PrintWriter pw = null;
    private static final Logger logger = LoggerFactory.getLogger(TsFileValidationTool.class);
    private static final List<File> seqDataDirList = new ArrayList<File>();
    private static final List<File> fileList = new ArrayList<File>();
    private static int badFileNum = 0;

    public static void main(String[] args) throws IOException {
        if (!TsFileValidationTool.checkArgs(args)) {
            System.exit(1);
        }
        if (printToFile) {
            pw = new PrintWriter(new FileWriter(outFilePath));
        }
        TsFileValidationTool.printBoth("Start checking seq files ...");
        for (File f : fileList) {
            TsFileValidationTool.findUncorrectFiles(Collections.singletonList(f));
        }
        for (File seqDataDir : seqDataDirList) {
            if (!TsFileValidationTool.checkIsDirectory(seqDataDir)) continue;
            File[] sgDirs = seqDataDir.listFiles();
            for (File sgDir : Objects.requireNonNull(sgDirs)) {
                if (!TsFileValidationTool.checkIsDirectory(sgDir)) continue;
                TsFileValidationTool.printBoth("- Check files in storage group: " + sgDir.getAbsolutePath());
                File[] dataRegionDirs = sgDir.listFiles();
                for (File dataRegionDir : Objects.requireNonNull(dataRegionDirs)) {
                    if (!TsFileValidationTool.checkIsDirectory(dataRegionDir)) continue;
                    List<Object> timePartitionDirs = Arrays.asList((Object[])Objects.requireNonNull(dataRegionDir.listFiles()));
                    timePartitionDirs.sort((f1, f2) -> Long.compareUnsigned(Long.parseLong(f1.getName()), Long.parseLong(f2.getName())));
                    for (File file2 : Objects.requireNonNull(timePartitionDirs)) {
                        if (!TsFileValidationTool.checkIsDirectory(file2)) continue;
                        List<Object> tsFiles = Arrays.asList((Object[])Objects.requireNonNull(file2.listFiles(file -> file.getName().endsWith(".tsfile"))));
                        tsFiles.sort((f1, f2) -> Long.compareUnsigned(Long.parseLong(f1.getName().split("-")[0]), Long.parseLong(f2.getName().split("-")[0])));
                        TsFileValidationTool.findUncorrectFiles(tsFiles);
                    }
                }
            }
        }
        TsFileValidationTool.printBoth("Finish checking successfully, totally find " + badFileNum + " bad files.");
        if (printToFile) {
            pw.close();
        }
    }

    private static void findUncorrectFiles(List<File> tsFiles) {
        HashMap<String, long[]> measurementLastTime = new HashMap<String, long[]>();
        HashMap<String, Long> deviceEndTime = new HashMap<String, Long>();
        for (File tsFile : tsFiles) {
            try {
                TsFileResource resource = new TsFileResource(tsFile);
                if (!new File(tsFile.getAbsolutePath() + ".resource").exists()) {
                    logger.warn("{} does not exist ,skip it.", (Object)(tsFile.getAbsolutePath() + ".resource"));
                    continue;
                }
                resource.deserialize();
                boolean isBadFile = false;
                TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());
                Throwable throwable = null;
                try {
                    byte marker;
                    HashMap<String, Boolean> hasCheckedDeviceOverlap = new HashMap<String, Boolean>();
                    reader.position((long)"TsFile".getBytes().length + 1L);
                    String deviceID = "";
                    HashMap<String, boolean[]> hasMeasurementPrintedDetails = new HashMap<String, boolean[]>();
                    HashMap<String, Long> lashChunkEndTime = new HashMap<String, Long>();
                    block17: while ((marker = reader.readMarker()) != 2) {
                        switch (marker) {
                            case -127: 
                            case -123: 
                            case 1: 
                            case 5: 
                            case 65: 
                            case 69: {
                                PageHeader pageHeader;
                                ChunkHeader header = reader.readChunkHeader(marker);
                                if (header.getDataSize() == 0) continue block17;
                                long currentChunkEndTime = Long.MIN_VALUE;
                                String measurementID = deviceID + '.' + header.getMeasurementID();
                                hasMeasurementPrintedDetails.computeIfAbsent(measurementID, k -> new boolean[4]);
                                measurementLastTime.computeIfAbsent(measurementID, k -> {
                                    long[] arr = new long[2];
                                    Arrays.fill(arr, Long.MIN_VALUE);
                                    return arr;
                                });
                                Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                                Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                                long lastPageEndTime = Long.MIN_VALUE;
                                for (int dataSize = header.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                                    valueDecoder.reset();
                                    pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                                    ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                                    long currentPageEndTime = Long.MIN_VALUE;
                                    if ((header.getChunkType() & 0xFFFFFF80) == -128) {
                                        TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, defaultTimeDecoder);
                                        long[] timeBatch = timePageReader.getNextTimeBatch();
                                        for (int i = 0; i < timeBatch.length; ++i) {
                                            long timestamp = timeBatch[i];
                                            if (timestamp <= ((long[])measurementLastTime.get(measurementID))[0]) {
                                                if (!isBadFile) {
                                                    TsFileValidationTool.printBoth("-- Find the bad file " + tsFile.getAbsolutePath());
                                                    isBadFile = true;
                                                    ++badFileNum;
                                                }
                                                if (!printDetails) continue;
                                                if (timestamp <= ((long[])measurementLastTime.get(measurementID))[1]) {
                                                    if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[0]) continue;
                                                    TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between files");
                                                    ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[0] = true;
                                                    continue;
                                                }
                                                if (timestamp <= lashChunkEndTime.getOrDefault(measurementID, Long.MIN_VALUE)) {
                                                    if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[1]) continue;
                                                    TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between chunks");
                                                    ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[1] = true;
                                                    continue;
                                                }
                                                if (timestamp <= lastPageEndTime) {
                                                    if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[2]) continue;
                                                    TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between pages");
                                                    ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[2] = true;
                                                    continue;
                                                }
                                                if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[3]) continue;
                                                TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap within one page");
                                                ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[3] = true;
                                                continue;
                                            }
                                            ((long[])measurementLastTime.get((Object)measurementID))[0] = timestamp;
                                            currentPageEndTime = timestamp;
                                            currentChunkEndTime = timestamp;
                                        }
                                    } else if ((header.getChunkType() & 0x40) != 64) {
                                        PageReader pageReader = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder, null);
                                        BatchData batchData = pageReader.getAllSatisfiedPageData();
                                        while (batchData.hasCurrent()) {
                                            long timestamp = batchData.currentTime();
                                            if (timestamp <= ((long[])measurementLastTime.get(measurementID))[0]) {
                                                if (!isBadFile) {
                                                    TsFileValidationTool.printBoth("-- Find the bad file " + tsFile.getAbsolutePath());
                                                    isBadFile = true;
                                                    ++badFileNum;
                                                }
                                                if (printDetails) {
                                                    if (timestamp <= ((long[])measurementLastTime.get(measurementID))[1]) {
                                                        if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[0]) {
                                                            TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between files");
                                                            ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[0] = true;
                                                        }
                                                    } else if (timestamp <= lashChunkEndTime.getOrDefault(measurementID, Long.MIN_VALUE)) {
                                                        if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[1]) {
                                                            TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between chunks");
                                                            ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[1] = true;
                                                        }
                                                    } else if (timestamp <= lastPageEndTime) {
                                                        if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[2]) {
                                                            TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between pages");
                                                            ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[2] = true;
                                                        }
                                                    } else if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[3]) {
                                                        TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap within one page");
                                                        ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[3] = true;
                                                    }
                                                }
                                            } else {
                                                ((long[])measurementLastTime.get((Object)measurementID))[0] = timestamp;
                                                currentPageEndTime = timestamp;
                                                currentChunkEndTime = timestamp;
                                            }
                                            batchData.next();
                                        }
                                    }
                                    lastPageEndTime = Math.max(lastPageEndTime, currentPageEndTime);
                                }
                                lashChunkEndTime.put(measurementID, Math.max(lashChunkEndTime.getOrDefault(measurementID, Long.MIN_VALUE), currentChunkEndTime));
                                continue block17;
                            }
                            case 0: {
                                ChunkGroupHeader chunkGroupHeader;
                                if (!deviceID.equals("") && resource.getEndTime(deviceID) > deviceEndTime.getOrDefault(deviceID, Long.MIN_VALUE)) {
                                    deviceEndTime.put(deviceID, resource.getEndTime(deviceID));
                                }
                                if (!hasCheckedDeviceOverlap.getOrDefault(deviceID = (chunkGroupHeader = reader.readChunkGroupHeader()).getDeviceID(), false).booleanValue() && resource.getStartTime(deviceID) <= deviceEndTime.getOrDefault(deviceID, Long.MIN_VALUE)) {
                                    if (!isBadFile) {
                                        TsFileValidationTool.printBoth("-- Find the bad file " + tsFile.getAbsolutePath());
                                        isBadFile = true;
                                        ++badFileNum;
                                    }
                                    if (printDetails) {
                                        TsFileValidationTool.printBoth("---- Device " + deviceID + " overlap between files");
                                    }
                                }
                                hasCheckedDeviceOverlap.put(deviceID, true);
                                continue block17;
                            }
                            case 4: {
                                reader.readPlanIndex();
                                continue block17;
                            }
                        }
                        MetaMarker.handleUnexpectedMarker((byte)marker);
                    }
                    for (Map.Entry entry : lashChunkEndTime.entrySet()) {
                        Long endTime = Math.max(((long[])measurementLastTime.get(entry.getKey()))[1], (Long)entry.getValue());
                        ((long[])measurementLastTime.get(entry.getKey()))[1] = endTime;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Throwable e) {
                logger.error("Meet errors in reading file {} , skip it.", (Object)tsFile.getAbsolutePath(), (Object)e);
                TsFileValidationTool.printBoth("-- Meet errors in reading file " + tsFile.getAbsolutePath() + ", tsfile may be corrupted.");
            }
        }
    }

    public static boolean checkArgs(String[] args) {
        if (args.length < 1) {
            System.out.println("Please input correct param, which is [path of data dir] [-pd = print details or not] [-f = path of outFile]. Eg: xxx/iotdb/data/data -pd=true -f=xxx/TsFile_validation_view.txt");
            return false;
        }
        for (String arg : args) {
            if (arg.startsWith("-pd")) {
                printDetails = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("-f")) {
                printToFile = true;
                outFilePath = arg.split("=")[1];
                continue;
            }
            File f = new File(arg);
            if (f.isDirectory() && Objects.requireNonNull(f.list((dir, name) -> name.equals("sequence") || name.equals("unsequence"))).length == 2) {
                File seqDataDir = new File(f, "sequence");
                seqDataDirList.add(seqDataDir);
                continue;
            }
            if (arg.endsWith(".tsfile") && f.isFile()) {
                fileList.add(f);
                continue;
            }
            System.out.println(arg + " is not a correct data directory or tsfile of IOTDB.");
            return false;
        }
        if (seqDataDirList.size() == 0 && fileList.size() == 0) {
            System.out.println("Please input correct param, which is [path of data dir] [-pd = print details or not] [-f = path of outFile]. Eg: xxx/iotdb/data/data -pd=true -f=xxx/TsFile_validation_view.txt");
            return false;
        }
        return true;
    }

    private static boolean checkIsDirectory(File dir) {
        boolean res = true;
        if (!dir.isDirectory()) {
            logger.error("{} is not a directory or does not exist, skip it.", (Object)dir.getAbsolutePath());
            res = false;
        }
        return res;
    }

    private static void printBoth(String msg) {
        System.out.println(msg);
        if (printToFile) {
            pw.println(msg);
        }
    }
}

