/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.service.transport.thrift.IdentityInfo;
import org.apache.iotdb.service.transport.thrift.TransportService;
import org.apache.iotdb.service.transport.thrift.TransportStatus;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ClientWrapper.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private TTransport transport = null;
    private volatile TransportService.Client serviceClient = null;
    private final String ipAddress;
    private final int port;
    private final String localIP;
    private final Pipe pipe;

    public ClientWrapper(Pipe pipe, String ipAddress, int port, String localIP) {
        this.pipe = pipe;
        this.ipAddress = ipAddress;
        this.port = port;
        this.localIP = localIP;
    }

    public TransportService.Client getClient() {
        return this.serviceClient;
    }

    public boolean handshakeWithVersion() throws SyncConnectionException {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        try {
            this.transport = RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, this.ipAddress, this.port, 100000, 1000));
            Object protocol = config.isRpcThriftCompressionEnable() ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
            this.serviceClient = new TransportService.Client((TProtocol)protocol);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            IdentityInfo identityInfo = new IdentityInfo(this.localIP, this.pipe.getName(), this.pipe.getCreateTime(), config.getIoTDBMajorVersion());
            TransportStatus status = this.serviceClient.handshake(identityInfo);
            if (status.code != 1) {
                logger.error("The receiver rejected the synchronization task because {}", (Object)status.msg);
                return false;
            }
        }
        catch (TException e) {
            logger.warn("Cannot connect to the receiver because {}", (Object)e.getMessage());
            throw new SyncConnectionException(String.format("Cannot connect to the receiver because %s.", e.getMessage()));
        }
        return true;
    }

    public void close() {
        if (this.transport != null) {
            this.transport.close();
            this.transport = null;
        }
    }
}

