/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.exception.sync.PipeException;
import org.apache.iotdb.db.exception.sync.PipeSinkException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.sync.conf.SyncConstant;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.sender.pipe.ExternalPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.IoTDBPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.db.sync.sender.recovery.SenderLogAnalyzer;
import org.apache.iotdb.db.sync.sender.recovery.SenderLogger;
import org.apache.iotdb.db.sync.sender.service.MsgManager;
import org.apache.iotdb.db.sync.sender.service.TransportHandler;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.apache.iotdb.service.transport.thrift.RequestType;
import org.apache.iotdb.service.transport.thrift.SyncResponse;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(SenderService.class);
    private SenderLogger senderLogger;
    private Map<String, PipeSink> pipeSinks;
    private List<Pipe> pipes;
    private Pipe runningPipe;
    private MsgManager msgManager;
    private TransportHandler transportHandler;
    private ExtPipePluginManager extPipePluginManager;

    private SenderService() {
    }

    public static SenderService getInstance() {
        return SenderServiceHolder.INSTANCE;
    }

    public PipeSink getPipeSink(String name) {
        return this.pipeSinks.getOrDefault(name, null);
    }

    public ExtPipePluginManager getExternalPipeManager() {
        return this.extPipePluginManager;
    }

    public boolean isPipeSinkExist(String name) {
        return this.pipeSinks.containsKey(name);
    }

    public void addPipeSink(CreatePipeSinkPlan plan) throws PipeSinkException {
        if (this.isPipeSinkExist(plan.getPipeSinkName())) {
            throw new PipeSinkException("There is a pipeSink named " + plan.getPipeSinkName() + " in IoTDB, please drop it.");
        }
        this.addPipeSink(this.parseCreatePipeSinkPlan(plan));
        this.senderLogger.addPipeSink(plan);
    }

    public PipeSink parseCreatePipeSinkPlan(CreatePipeSinkPlan plan) throws PipeSinkException {
        PipeSink pipeSink;
        try {
            pipeSink = PipeSink.PipeSinkFactory.createPipeSink(plan.getPipeSinkType(), plan.getPipeSinkName());
        }
        catch (UnsupportedOperationException e) {
            throw new PipeSinkException(e.getMessage());
        }
        pipeSink.setAttribute(plan.getPipeSinkAttributes());
        return pipeSink;
    }

    public void addPipeSink(PipeSink pipeSink) {
        this.pipeSinks.put(pipeSink.getPipeSinkName(), pipeSink);
    }

    public void dropPipeSink(String name) throws PipeSinkException {
        if (!this.isPipeSinkExist(name)) {
            throw new PipeSinkException("PipeSink " + name + " is not exist.");
        }
        if (this.runningPipe != null && this.runningPipe.getStatus() != Pipe.PipeStatus.DROP && this.runningPipe.getPipeSink().getPipeSinkName().equals(name)) {
            throw new PipeSinkException(String.format("Can not drop pipeSink %s, because pipe %s is using it.", name, this.runningPipe.getName()));
        }
        this.pipeSinks.remove(name);
        this.senderLogger.dropPipeSink(name);
    }

    public List<PipeSink> getAllPipeSink() {
        ArrayList<PipeSink> allPipeSinks = new ArrayList<PipeSink>();
        for (Map.Entry<String, PipeSink> entry : this.pipeSinks.entrySet()) {
            allPipeSinks.add(entry.getValue());
        }
        return allPipeSinks;
    }

    public synchronized void addPipe(CreatePipePlan plan) throws PipeException {
        if (this.runningPipe != null && this.runningPipe.getStatus() != Pipe.PipeStatus.DROP) {
            throw new PipeException(String.format("Pipe %s is %s, please retry after drop it.", this.runningPipe.getName(), this.runningPipe.getStatus().name()));
        }
        if (!this.isPipeSinkExist(plan.getPipeSinkName())) {
            throw new PipeException(String.format("Can not find pipeSink %s.", plan.getPipeSinkName()));
        }
        long currentTime = DatetimeUtils.currentTime();
        if (plan.getDataStartTimestamp() > currentTime) {
            throw new PipeException(String.format("Start time %s is later than current time %s, this is not supported yet.", DatetimeUtils.convertLongToDate(plan.getDataStartTimestamp()), DatetimeUtils.convertLongToDate(currentTime)));
        }
        PipeSink runningPipeSink = this.getPipeSink(plan.getPipeSinkName());
        this.runningPipe = this.parseCreatePipePlan(plan, runningPipeSink, currentTime);
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
            try {
                this.transportHandler = TransportHandler.getNewTransportHandler(this.runningPipe, (IoTDBPipeSink)runningPipeSink);
                this.sendMsg(RequestType.CREATE);
            }
            catch (ClassCastException e) {
                logger.error(String.format("Cast Class to %s error when create pipe %s.", IoTDBPipeSink.class.getName(), plan.getPipeName()), (Throwable)e);
                this.runningPipe = null;
                throw new PipeException(String.format("Wrong pipeSink type %s for create pipe %s", new Object[]{runningPipeSink.getType(), runningPipeSink.getPipeSinkName()}));
            }
            catch (PipeException e) {
                this.runningPipe = null;
                throw e;
            }
        } else {
            this.startExternalPipeManager(false);
        }
        this.msgManager.addPipe(this.runningPipe);
        this.pipes.add(this.runningPipe);
        this.senderLogger.addPipe(plan, currentTime);
    }

    public Pipe parseCreatePipePlan(CreatePipePlan plan, PipeSink pipeSink, long pipeCreateTime) throws PipeException {
        boolean syncDelOp = true;
        for (Pair<String, String> pair : plan.getPipeAttributes()) {
            pair.left = ((String)pair.left).toLowerCase();
            if ("syncdelop".equals(pair.left)) {
                syncDelOp = Boolean.parseBoolean((String)pair.right);
                continue;
            }
            throw new PipeException(String.format("Can not recognition attribute %s", pair.left));
        }
        return new TsFilePipe(pipeCreateTime, plan.getPipeName(), pipeSink, plan.getDataStartTimestamp(), syncDelOp);
    }

    public synchronized void stopPipe(String pipeName) throws PipeException {
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getStatus() == Pipe.PipeStatus.RUNNING) {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                this.runningPipe.stop();
                this.transportHandler.stop();
            } else {
                if (this.extPipePluginManager != null) {
                    try {
                        String extPipeSinkTypeName = ((ExternalPipeSink)this.runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                        this.extPipePluginManager.stopExtPipe(extPipeSinkTypeName);
                    }
                    catch (Exception e) {
                        throw new PipeException("Failed to stop externalPipeProcessor. " + e.getMessage());
                    }
                }
                this.runningPipe.stop();
            }
        }
        this.senderLogger.operatePipe(pipeName, Operator.OperatorType.STOP_PIPE);
    }

    public synchronized void startPipe(String pipeName) throws PipeException {
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getStatus() == Pipe.PipeStatus.STOP) {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                this.sendMsg(RequestType.START);
                this.runningPipe.start();
                this.transportHandler.start();
            } else {
                this.runningPipe.start();
                this.startExternalPipeManager(true);
            }
        }
        this.senderLogger.operatePipe(pipeName, Operator.OperatorType.START_PIPE);
    }

    private void startExternalPipeManager(boolean startExtPipe) throws PipeException {
        if (!(this.runningPipe instanceof TsFilePipe)) {
            logger.error("startExternalPipeManager(), runningPipe is not TsFilePipe. " + this.runningPipe);
            return;
        }
        PipeSink pipeSink = this.runningPipe.getPipeSink();
        if (!(pipeSink instanceof ExternalPipeSink)) {
            logger.error("startExternalPipeManager(), pipeSink is not ExternalPipeSink." + pipeSink);
            return;
        }
        String extPipeSinkTypeName = ((ExternalPipeSink)pipeSink).getExtPipeSinkTypeName();
        IExternalPipeSinkWriterFactory externalPipeSinkWriterFactory = ExtPipePluginRegister.getInstance().getWriteFactory(extPipeSinkTypeName);
        if (externalPipeSinkWriterFactory == null) {
            logger.error(String.format("startExternalPipeManager(), can not found ExternalPipe plugin for {}.", extPipeSinkTypeName));
            throw new PipeException("Can not found ExternalPipe plugin for " + extPipeSinkTypeName + ".");
        }
        if (this.extPipePluginManager == null) {
            this.extPipePluginManager = new ExtPipePluginManager((TsFilePipe)this.runningPipe);
        }
        if (startExtPipe) {
            try {
                this.extPipePluginManager.startExtPipe(extPipeSinkTypeName, ((ExternalPipeSink)pipeSink).getSinkParams());
            }
            catch (IOException e) {
                logger.error("Failed to start External Pipe: {}.", (Object)extPipeSinkTypeName, (Object)e);
                throw new PipeException("Failed to start External Pipe: " + extPipeSinkTypeName + ". " + e.getMessage());
            }
        }
    }

    public synchronized void dropPipe(String pipeName) throws PipeException {
        this.checkRunningPipeExistAndName(pipeName);
        try {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                if (!this.transportHandler.close()) {
                    throw new PipeException(String.format("Close pipe %s transport error after %s %s, please try again.", this.runningPipe.getName(), SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS.name()));
                }
                this.runningPipe.drop();
                this.msgManager.removeAllPipe();
                this.sendMsg(RequestType.DROP);
            } else {
                if (this.extPipePluginManager != null) {
                    String extPipeSinkTypeName = ((ExternalPipeSink)this.runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                    this.extPipePluginManager.dropExtPipe(extPipeSinkTypeName);
                    this.extPipePluginManager = null;
                }
                this.runningPipe.drop();
            }
            this.senderLogger.operatePipe(pipeName, Operator.OperatorType.DROP_PIPE);
        }
        catch (InterruptedException e) {
            logger.warn(String.format("Interrupted when waiting for clear transport %s.", this.runningPipe.getName()), (Throwable)e);
            throw new PipeException("Drop error, be interrupted, please try again.");
        }
    }

    public List<Pipe> getAllPipes() {
        return new ArrayList<Pipe>(this.pipes);
    }

    public synchronized String getPipeMsg(Pipe pipe) {
        return this.msgManager.getPipeMsg(pipe);
    }

    private void checkRunningPipeExistAndName(String pipeName) throws PipeException {
        if (this.runningPipe == null || this.runningPipe.getStatus() == Pipe.PipeStatus.DROP) {
            throw new PipeException("There is no existing pipe.");
        }
        if (!this.runningPipe.getName().equals(pipeName)) {
            throw new PipeException(String.format("Pipe %s is %s, please retry after drop it.", new Object[]{this.runningPipe.getName(), this.runningPipe.getStatus()}));
        }
    }

    public void setConnecting(boolean isConnecting) {
        this.runningPipe.setDisconnected(isConnecting);
    }

    private void sendMsg(RequestType type) throws PipeException {
        try {
            this.receiveMsg(this.transportHandler.sendMsg(type));
        }
        catch (SyncConnectionException e) {
            logger.warn(String.format("Connect to pipeSink %s error when %s pipe.", this.runningPipe.getPipeSink(), type.name()), (Throwable)((Object)e));
            throw new PipeException(String.format("Can not connect to pipeSink %s, please check net and receiver is available, and try again.", this.runningPipe.getPipeSink()));
        }
    }

    public synchronized void receiveMsg(SyncResponse response) {
        if (this.runningPipe == null || this.runningPipe.getStatus() == Pipe.PipeStatus.DROP) {
            logger.info(String.format("No running pipe for receiving msg %s.", response));
            return;
        }
        switch (response.type) {
            case INFO: {
                break;
            }
            case ERROR: {
                logger.warn(String.format("%s from receiver: %s", response.type.name(), response.msg));
                try {
                    this.stopPipe(this.runningPipe.getName());
                }
                catch (PipeException e) {
                    logger.warn(String.format("Stop pipe %s when meeting error in sender service.", this.runningPipe.getName()), (Throwable)((Object)e));
                }
            }
            case WARN: {
                this.msgManager.recordMsg(this.runningPipe, this.runningPipe.getStatus() == Pipe.PipeStatus.RUNNING ? Operator.OperatorType.START_PIPE : Operator.OperatorType.STOP_PIPE, response.type, response.msg);
            }
        }
    }

    public void start() throws StartupException {
        ExtPipePluginRegister extPipePluginRegister = ExtPipePluginRegister.getInstance();
        if (extPipePluginRegister == null) {
            throw new StartupException("Load ExternalPipe Plugin error.");
        }
        logger.info("Load {} ExternalPipe Plugin: {}", (Object)extPipePluginRegister.getAllPluginName().size(), extPipePluginRegister.getAllPluginName());
        this.pipeSinks = new HashMap<String, PipeSink>();
        this.pipes = new ArrayList<Pipe>();
        this.senderLogger = new SenderLogger();
        this.msgManager = new MsgManager(this.senderLogger);
        File senderLog = new File(SyncPathUtil.getSysDir(), "senderService.log");
        if (senderLog.exists()) {
            try {
                this.recover();
            }
            catch (Exception e) {
                logger.error("Recover from disk error.", (Throwable)e);
                throw new StartupException((Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.runningPipe != null && !Pipe.PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            try {
                this.runningPipe.stop();
                this.transportHandler.stop();
            }
            catch (PipeException e) {
                logger.warn(String.format("Stop pipe %s error when stop Sender Service.", this.runningPipe.getName()), (Throwable)((Object)e));
            }
        }
    }

    public void shutdown(long milliseconds) throws ShutdownException {
        this.pipeSinks = null;
        this.pipes = null;
        this.msgManager = null;
        this.senderLogger.close();
        if (this.runningPipe != null && !Pipe.PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            try {
                this.runningPipe.stop();
                this.transportHandler.close();
                this.runningPipe.close();
            }
            catch (InterruptedException | PipeException e) {
                logger.warn(String.format("Stop pipe %s error when shutdown Sender Service.", this.runningPipe.getName()), (Throwable)e);
                throw new ShutdownException((Throwable)e);
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.SENDER_SERVICE;
    }

    private void recover() throws IOException, PipeException {
        SenderLogAnalyzer analyzer = new SenderLogAnalyzer();
        analyzer.recover();
        this.pipeSinks = analyzer.getRecoveryAllPipeSinks();
        this.pipes = analyzer.getRecoveryAllPipes();
        this.runningPipe = analyzer.getRecoveryRunningPipe();
        this.msgManager = analyzer.getMsgManager();
        if (this.runningPipe == null || Pipe.PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            return;
        }
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
            this.transportHandler = TransportHandler.getNewTransportHandler(this.runningPipe, (IoTDBPipeSink)this.runningPipe.getPipeSink());
            if (Pipe.PipeStatus.RUNNING.equals((Object)this.runningPipe.getStatus())) {
                this.transportHandler.start();
            }
        } else {
            this.startExternalPipeManager(this.runningPipe.getStatus() == Pipe.PipeStatus.RUNNING);
        }
    }

    private static class SenderServiceHolder {
        private static final SenderService INSTANCE = new SenderService();

        private SenderServiceHolder() {
        }
    }
}

