/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateTemplatePlan
extends PhysicalPlan {
    String name;
    Set<String> alignedDeviceId;
    String[] schemaNames;
    String[][] measurements;
    TSDataType[][] dataTypes;
    TSEncoding[][] encodings;
    CompressionType[][] compressors;
    private static final int NEW_PLAN = -1;

    public CreateTemplatePlan() {
        super(Operator.OperatorType.CREATE_TEMPLATE);
    }

    public CreateTemplatePlan(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors) {
        super(Operator.OperatorType.CREATE_TEMPLATE);
        int j;
        int i;
        this.name = name;
        this.schemaNames = null;
        this.measurements = new String[measurements.size()][];
        for (i = 0; i < measurements.size(); ++i) {
            this.measurements[i] = new String[measurements.get(i).size()];
            for (j = 0; j < measurements.get(i).size(); ++j) {
                this.measurements[i][j] = measurements.get(i).get(j);
            }
        }
        this.dataTypes = new TSDataType[dataTypes.size()][];
        for (i = 0; i < dataTypes.size(); ++i) {
            this.dataTypes[i] = new TSDataType[dataTypes.get(i).size()];
            for (j = 0; j < dataTypes.get(i).size(); ++j) {
                this.dataTypes[i][j] = dataTypes.get(i).get(j);
            }
        }
        this.encodings = new TSEncoding[dataTypes.size()][];
        for (i = 0; i < encodings.size(); ++i) {
            this.encodings[i] = new TSEncoding[dataTypes.get(i).size()];
            for (j = 0; j < encodings.get(i).size(); ++j) {
                this.encodings[i][j] = encodings.get(i).get(j);
            }
        }
        this.compressors = new CompressionType[dataTypes.size()][];
        for (i = 0; i < compressors.size(); ++i) {
            this.compressors[i] = new CompressionType[compressors.get(i).size()];
            for (j = 0; j < compressors.get(i).size(); ++j) {
                this.compressors[i][j] = compressors.get(i).get(j);
            }
        }
        this.alignedDeviceId = new HashSet<String>();
    }

    public CreateTemplatePlan(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors) {
        this(name, measurements, dataTypes, encodings, compressors);
        this.schemaNames = schemaNames.toArray(new String[0]);
    }

    private CreateTemplatePlan(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors, Set<String> alignedDeviceId) {
        this(name, measurements, dataTypes, encodings, compressors);
        this.alignedDeviceId = alignedDeviceId;
    }

    public CreateTemplatePlan(String name, String[][] measurements, TSDataType[][] dataTypes, TSEncoding[][] encodings, CompressionType[][] compressors) {
        super(Operator.OperatorType.CREATE_TEMPLATE);
        this.name = name;
        this.schemaNames = null;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
    }

    public List<String> getSchemaNames() {
        if (this.schemaNames != null) {
            return Arrays.asList(this.schemaNames);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getAlignedDeviceId() {
        return this.alignedDeviceId;
    }

    public List<List<String>> getMeasurements() {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        for (String[] measurement : this.measurements) {
            ret.add(Arrays.asList(measurement));
        }
        return ret;
    }

    public List<List<TSDataType>> getDataTypes() {
        ArrayList<List<TSDataType>> ret = new ArrayList<List<TSDataType>>();
        for (TSDataType[] alignedDataTypes : this.dataTypes) {
            ret.add(Arrays.asList(alignedDataTypes));
        }
        return ret;
    }

    public List<List<TSEncoding>> getEncodings() {
        ArrayList<List<TSEncoding>> ret = new ArrayList<List<TSEncoding>>();
        for (TSEncoding[] alignedEncodings : this.encodings) {
            ret.add(Arrays.asList(alignedEncodings));
        }
        return ret;
    }

    public List<List<CompressionType>> getCompressors() {
        ArrayList<List<CompressionType>> ret = new ArrayList<List<CompressionType>>();
        for (CompressionType[] alignedCompressor : this.compressors) {
            ret.add(Arrays.asList(alignedCompressor));
        }
        return ret;
    }

    public static CreateTemplatePlan deserializeFromReq(ByteBuffer buffer) throws MetadataException {
        HashMap alignedPrefix = new HashMap();
        HashMap alignedDataTypes = new HashMap();
        HashMap alignedEncodings = new HashMap();
        HashMap alignedCompressions = new HashMap();
        ArrayList<List<String>> measurements = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> dataTypes = new ArrayList<List<TSDataType>>();
        ArrayList<List<TSEncoding>> encodings = new ArrayList<List<TSEncoding>>();
        ArrayList<List<CompressionType>> compressors = new ArrayList<List<CompressionType>>();
        String templateName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        boolean isAlign = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (isAlign) {
            alignedPrefix.put("", new ArrayList());
            alignedDataTypes.put("", new ArrayList());
            alignedEncodings.put("", new ArrayList());
            alignedCompressions.put("", new ArrayList());
        }
        while (buffer.position() != buffer.limit()) {
            String prefix = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            isAlign = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
            String measurementName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            TSDataType dataType = TSDataType.values()[ReadWriteIOUtils.readByte((ByteBuffer)buffer)];
            TSEncoding encoding = TSEncoding.values()[ReadWriteIOUtils.readByte((ByteBuffer)buffer)];
            CompressionType compressionType = CompressionType.values()[ReadWriteIOUtils.readByte((ByteBuffer)buffer)];
            if (alignedPrefix.containsKey(prefix) && !isAlign) {
                throw new MetadataException("Align designation incorrect at: " + prefix);
            }
            if (isAlign && !alignedPrefix.containsKey(prefix)) {
                alignedPrefix.put(prefix, new ArrayList());
                alignedDataTypes.put(prefix, new ArrayList());
                alignedEncodings.put(prefix, new ArrayList());
                alignedCompressions.put(prefix, new ArrayList());
            }
            if (alignedPrefix.containsKey(prefix)) {
                ((List)alignedPrefix.get(prefix)).add(measurementName);
                ((List)alignedDataTypes.get(prefix)).add(dataType);
                ((List)alignedEncodings.get(prefix)).add(encoding);
                ((List)alignedCompressions.get(prefix)).add(compressionType);
                continue;
            }
            if ("".equals(prefix)) {
                measurements.add(Collections.singletonList(measurementName));
            } else {
                measurements.add(Collections.singletonList(prefix + "." + measurementName));
            }
            dataTypes.add(Collections.singletonList(dataType));
            encodings.add(Collections.singletonList(encoding));
            compressors.add(Collections.singletonList(compressionType));
        }
        for (String prefix : alignedPrefix.keySet()) {
            ArrayList thisMeasurements = new ArrayList();
            ArrayList thisDataTypes = new ArrayList();
            ArrayList thisEncodings = new ArrayList();
            ArrayList thisCompressors = new ArrayList();
            for (int i = 0; i < ((List)alignedPrefix.get(prefix)).size(); ++i) {
                if ("".equals(prefix)) {
                    thisMeasurements.add(((List)alignedPrefix.get(prefix)).get(i));
                } else {
                    thisMeasurements.add(prefix + "." + (String)((List)alignedPrefix.get(prefix)).get(i));
                }
                thisDataTypes.add(((List)alignedDataTypes.get(prefix)).get(i));
                thisEncodings.add(((List)alignedEncodings.get(prefix)).get(i));
                thisCompressors.add(((List)alignedCompressions.get(prefix)).get(i));
            }
            measurements.add(thisMeasurements);
            dataTypes.add(thisDataTypes);
            encodings.add(thisEncodings);
            compressors.add(thisCompressors);
        }
        return new CreateTemplatePlan(templateName, measurements, dataTypes, encodings, compressors, alignedPrefix.keySet());
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)-1, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.measurements.length, (ByteBuffer)buffer);
        for (String[] stringArray : this.measurements) {
            ReadWriteIOUtils.write((int)stringArray.length, (ByteBuffer)buffer);
            for (String measurement : stringArray) {
                ReadWriteIOUtils.write((String)measurement, (ByteBuffer)buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.dataTypes.length, (ByteBuffer)buffer);
        for (String[] stringArray : this.dataTypes) {
            ReadWriteIOUtils.write((int)stringArray.length, (ByteBuffer)buffer);
            for (String dataType : stringArray) {
                ReadWriteIOUtils.write((int)dataType.ordinal(), (ByteBuffer)buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.encodings.length, (ByteBuffer)buffer);
        for (String[] stringArray : this.encodings) {
            ReadWriteIOUtils.write((int)stringArray.length, (ByteBuffer)buffer);
            for (String encoding : stringArray) {
                ReadWriteIOUtils.write((int)encoding.ordinal(), (ByteBuffer)buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.compressors.length, (ByteBuffer)buffer);
        for (String[] stringArray : this.compressors) {
            ReadWriteIOUtils.write((int)stringArray.length, (ByteBuffer)buffer);
            for (String compressionType : stringArray) {
                ReadWriteIOUtils.write((int)compressionType.ordinal(), (ByteBuffer)buffer);
            }
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int j;
        int listSize;
        int i;
        boolean isFormerSerialized;
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        if (size == -1) {
            isFormerSerialized = false;
        } else {
            isFormerSerialized = true;
            this.schemaNames = new String[size];
            for (i = 0; i < size; ++i) {
                this.schemaNames[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            }
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.measurements = new String[size][];
        for (i = 0; i < size; ++i) {
            listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            this.measurements[i] = new String[listSize];
            for (j = 0; j < listSize; ++j) {
                this.measurements[i][j] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            }
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.dataTypes = new TSDataType[size][];
        for (i = 0; i < size; ++i) {
            listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            this.dataTypes[i] = new TSDataType[listSize];
            for (j = 0; j < listSize; ++j) {
                this.dataTypes[i][j] = TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
            }
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.encodings = new TSEncoding[size][];
        for (i = 0; i < size; ++i) {
            listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            this.encodings[i] = new TSEncoding[listSize];
            for (j = 0; j < listSize; ++j) {
                this.encodings[i][j] = TSEncoding.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
            }
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        if (!isFormerSerialized) {
            this.compressors = new CompressionType[size][];
            for (i = 0; i < size; ++i) {
                listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                this.compressors[i] = new CompressionType[listSize];
                for (j = 0; j < listSize; ++j) {
                    this.compressors[i][j] = CompressionType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
                }
            }
        } else {
            this.compressors = new CompressionType[size][];
            for (i = 0; i < size; ++i) {
                listSize = this.measurements[i].length;
                this.compressors[i] = new CompressionType[listSize];
                CompressionType alignedCompressionType = CompressionType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
                for (int j2 = 0; j2 < listSize; ++j2) {
                    this.compressors[i][j2] = alignedCompressionType;
                }
            }
        }
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.measurements.length, (OutputStream)stream);
        for (String[] stringArray : this.measurements) {
            ReadWriteIOUtils.write((int)stringArray.length, (OutputStream)stream);
            for (String measurement : stringArray) {
                ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.dataTypes.length, (OutputStream)stream);
        for (String[] stringArray : this.dataTypes) {
            ReadWriteIOUtils.write((int)stringArray.length, (OutputStream)stream);
            for (String dataType : stringArray) {
                ReadWriteIOUtils.write((int)dataType.ordinal(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.encodings.length, (OutputStream)stream);
        for (String[] stringArray : this.encodings) {
            ReadWriteIOUtils.write((int)stringArray.length, (OutputStream)stream);
            for (String encoding : stringArray) {
                ReadWriteIOUtils.write((int)encoding.ordinal(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.compressors.length, (OutputStream)stream);
        for (String[] stringArray : this.compressors) {
            ReadWriteIOUtils.write((int)stringArray.length, (OutputStream)stream);
            for (String compressionType : stringArray) {
                ReadWriteIOUtils.write((int)compressionType.ordinal(), (OutputStream)stream);
            }
        }
        stream.writeLong(this.index);
    }

    public void formerSerialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.schemaNames.length, (OutputStream)stream);
        for (String string : this.schemaNames) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.measurements.length, (OutputStream)stream);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((int)((String)string).length, (OutputStream)stream);
            for (String measurement : string) {
                ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.dataTypes.length, (OutputStream)stream);
        for (String string : this.dataTypes) {
            ReadWriteIOUtils.write((int)((String)string).length, (OutputStream)stream);
            for (String dataType : string) {
                ReadWriteIOUtils.write((int)dataType.ordinal(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.encodings.length, (OutputStream)stream);
        for (String string : this.encodings) {
            ReadWriteIOUtils.write((int)((String)string).length, (OutputStream)stream);
            for (String encoding : string) {
                ReadWriteIOUtils.write((int)encoding.ordinal(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.compressors.length, (OutputStream)stream);
        for (String string : this.compressors) {
            ReadWriteIOUtils.write((int)string[0].ordinal(), (OutputStream)stream);
        }
        stream.writeLong(this.index);
    }

    public List<PartialPath> getPaths() {
        return null;
    }
}

