/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.selector;

import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxSelector;

public class InfluxLastFunction
extends InfluxSelector {
    private Object value;

    public InfluxLastFunction(List<Expression> expressionList) {
        super(expressionList);
        this.setTimestamp(Long.MIN_VALUE);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        return new InfluxFunctionValue(this.value, this.getTimestamp());
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        return this.calculateBruteForce();
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        if (this.value == null && this.getTimestamp() == null) {
            this.value = functionValues[0].getValue();
            this.setTimestamp(functionValues[0].getTimestamp());
        } else if (this.getTimestamp() > functionValues[0].getTimestamp()) {
            this.value = functionValues[0].getValue();
            this.setTimestamp(functionValues[0].getTimestamp());
        }
    }

    @Override
    public void updateValueAndRelateValues(InfluxFunctionValue functionValue, List<Object> relatedValues) {
        Object value = functionValue.getValue();
        Long timestamp = functionValue.getTimestamp();
        if (timestamp >= this.getTimestamp()) {
            this.value = value;
            this.setTimestamp(timestamp);
            this.setRelatedValues(relatedValues);
        }
    }

    @Override
    public String getFunctionName() {
        return "last";
    }
}

