/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;

public class InfluxModeFunction
extends InfluxAggregator {
    private final Map<Object, Integer> valueOrders = new HashMap<Object, Integer>();
    private final Map<Object, Long> valueLastTimestamp = new HashMap<Object, Long>();
    private int maxNumber = 0;
    private Object maxObject = null;

    public InfluxModeFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        return new InfluxFunctionValue(this.maxObject, 0L);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFunctionName() {
        return "mode";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        Object value = functionValue.getValue();
        Long timestamp = functionValue.getTimestamp();
        if (!this.valueOrders.containsKey(value)) {
            this.valueOrders.put(value, 1);
            this.valueLastTimestamp.put(value, timestamp);
        } else {
            this.valueOrders.put(value, this.valueOrders.get(value) + 1);
            if (timestamp < this.valueLastTimestamp.get(value)) {
                this.valueLastTimestamp.put(value, timestamp);
            }
        }
        if (this.maxObject == null) {
            this.maxObject = value;
            this.maxNumber = 1;
        } else if (this.valueOrders.get(value) > this.maxNumber) {
            this.maxNumber = this.valueOrders.get(value);
            this.maxObject = value;
        } else if (this.valueOrders.get(value) == this.maxNumber && timestamp < this.valueLastTimestamp.get(this.maxObject)) {
            this.maxObject = value;
        }
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        throw new UnsupportedOperationException();
    }
}

