/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.FillComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.FilterNullComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.FromComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByLevelComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderBy;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultSetFormat;
import org.apache.iotdb.db.mpp.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.WhereCondition;

public class QueryStatement
extends Statement {
    protected SelectComponent selectComponent;
    protected FromComponent fromComponent;
    protected WhereCondition whereCondition;
    protected int rowLimit = 0;
    protected int rowOffset = 0;
    protected int seriesLimit = 0;
    protected int seriesOffset = 0;
    protected FillComponent fillComponent;
    protected FilterNullComponent filterNullComponent;
    protected OrderBy resultOrder = OrderBy.TIMESTAMP_ASC;
    protected ResultSetFormat resultSetFormat = ResultSetFormat.ALIGN_BY_TIME;
    protected GroupByTimeComponent groupByTimeComponent;
    protected GroupByLevelComponent groupByLevelComponent;

    public QueryStatement() {
        this.statementType = StatementType.QUERY;
    }

    public List<PartialPath> getPaths() {
        return this.fromComponent.getPrefixPaths();
    }

    public SelectComponent getSelectComponent() {
        return this.selectComponent;
    }

    public void setSelectComponent(SelectComponent selectComponent) {
        this.selectComponent = selectComponent;
    }

    public FromComponent getFromComponent() {
        return this.fromComponent;
    }

    public void setFromComponent(FromComponent fromComponent) {
        this.fromComponent = fromComponent;
    }

    public WhereCondition getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(WhereCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public int getSeriesLimit() {
        return this.seriesLimit;
    }

    public void setSeriesLimit(int seriesLimit) {
        this.seriesLimit = seriesLimit;
    }

    public int getSeriesOffset() {
        return this.seriesOffset;
    }

    public void setSeriesOffset(int seriesOffset) {
        this.seriesOffset = seriesOffset;
    }

    public FillComponent getFillComponent() {
        return this.fillComponent;
    }

    public void setFillComponent(FillComponent fillComponent) {
        this.fillComponent = fillComponent;
    }

    public FilterNullComponent getFilterNullComponent() {
        return this.filterNullComponent;
    }

    public void setFilterNullComponent(FilterNullComponent filterNullComponent) {
        this.filterNullComponent = filterNullComponent;
    }

    public OrderBy getResultOrder() {
        return this.resultOrder;
    }

    public void setResultOrder(OrderBy resultOrder) {
        this.resultOrder = resultOrder;
    }

    public ResultSetFormat getResultSetFormat() {
        return this.resultSetFormat;
    }

    public void setResultSetFormat(ResultSetFormat resultSetFormat) {
        this.resultSetFormat = resultSetFormat;
    }

    public GroupByTimeComponent getGroupByTimeComponent() {
        return this.groupByTimeComponent;
    }

    public void setGroupByTimeComponent(GroupByTimeComponent groupByTimeComponent) {
        this.groupByTimeComponent = groupByTimeComponent;
    }

    public GroupByLevelComponent getGroupByLevelComponent() {
        return this.groupByLevelComponent;
    }

    public void setGroupByLevelComponent(GroupByLevelComponent groupByLevelComponent) {
        this.groupByLevelComponent = groupByLevelComponent;
    }

    public boolean isLastQuery() {
        return this.selectComponent.isHasLast();
    }

    public boolean isAggregationQuery() {
        return this.selectComponent.isHasBuiltInAggregationFunction();
    }

    public boolean isGroupByLevel() {
        return this.groupByLevelComponent != null;
    }

    public boolean isGroupByTime() {
        return this.groupByTimeComponent != null;
    }

    public boolean isAlignByDevice() {
        return this.resultSetFormat == ResultSetFormat.ALIGN_BY_DEVICE;
    }

    public boolean disableAlign() {
        return this.resultSetFormat == ResultSetFormat.DISABLE_ALIGN;
    }

    public void semanticCheck() {
        if (this.isAggregationQuery()) {
            if (this.disableAlign()) {
                throw new SemanticException("AGGREGATION doesn't support disable align clause.");
            }
            if (this.isGroupByLevel() && this.isAlignByDevice()) {
                throw new SemanticException("group by level does not support align by device now.");
            }
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                if (resultColumn.getColumnType() == ResultColumn.ColumnType.AGGREGATION) continue;
                throw new SemanticException("Raw data and aggregation hybrid query is not supported.");
            }
        } else if (this.isGroupByTime() || this.isGroupByLevel()) {
            throw new SemanticException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
        if (this.isAlignByDevice()) {
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                ExpressionAnalyzer.checkIsAllMeasurement(resultColumn.getExpression());
            }
            if (this.getWhereCondition() != null) {
                ExpressionAnalyzer.checkIsAllMeasurement(this.getWhereCondition().getPredicate());
            }
        }
        if (this.isLastQuery()) {
            if (this.isAlignByDevice()) {
                throw new SemanticException("Last query doesn't support align by device.");
            }
            if (this.disableAlign()) {
                throw new SemanticException("Disable align cannot be applied to LAST query.");
            }
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (expression instanceof TimeSeriesOperand) continue;
                throw new SemanticException("Last queries can only be applied on raw time series.");
            }
        }
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }
}

