/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeleteDataNode
extends WritePlanNode {
    private final List<PartialPath> pathList;
    private final long deleteStartTime;
    private final long deleteEndTime;
    private TRegionReplicaSet regionReplicaSet;

    public DeleteDataNode(PlanNodeId id, List<PartialPath> pathList, long deleteStartTime, long deleteEndTime) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
    }

    public DeleteDataNode(PlanNodeId id, List<PartialPath> pathList, long deleteStartTime, long deleteEndTime, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
        this.regionReplicaSet = regionReplicaSet;
    }

    public List<PartialPath> getPathList() {
        return this.pathList;
    }

    public long getDeleteStartTime() {
        return this.deleteStartTime;
    }

    public long getDeleteEndTime() {
        return this.deleteEndTime;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new DeleteDataNode(this.getPlanNodeId(), this.pathList, this.deleteStartTime, this.deleteEndTime);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DELETE_DATA.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.pathList.size(), (ByteBuffer)byteBuffer);
        for (PartialPath path : this.pathList) {
            path.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.deleteStartTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.deleteEndTime, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DELETE_DATA.serialize(stream);
        ReadWriteIOUtils.write((int)this.pathList.size(), (OutputStream)stream);
        for (PartialPath path : this.pathList) {
            path.serialize(stream);
        }
        ReadWriteIOUtils.write((long)this.deleteStartTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.deleteEndTime, (OutputStream)stream);
    }

    public static DeleteDataNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            pathList.add((PartialPath)PathDeserializeUtil.deserialize(byteBuffer));
        }
        long deleteStartTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long deleteEndTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeleteDataNode(planNodeId, pathList, deleteStartTime, deleteEndTime);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteData(this, context);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public String toString() {
        return String.format("DeleteDataNode-%s[ Paths: %s, Region: %s ]", this.getPlanNodeId(), this.pathList, this.regionReplicaSet == null ? "Not Assigned" : this.regionReplicaSet.getRegionId());
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        SchemaTree schemaTree = analysis.getSchemaTree();
        DataPartition dataPartition = analysis.getDataPartitionInfo();
        HashMap<TRegionReplicaSet, List> regionToPatternMap = new HashMap<TRegionReplicaSet, List>();
        Iterator<PartialPath> iterator = this.pathList.iterator();
        while (iterator.hasNext()) {
            PartialPath pathPattern;
            PartialPath devicePattern = pathPattern = iterator.next();
            if (!pathPattern.getTailNode().equals("**")) {
                devicePattern = pathPattern.getDevicePath();
            }
            for (DeviceSchemaInfo deviceSchemaInfo : schemaTree.getMatchedDevices(devicePattern)) {
                PartialPath devicePath = deviceSchemaInfo.getDevicePath();
                for (TRegionReplicaSet regionReplicaSet : dataPartition.getDataRegionReplicaSet(devicePath.getFullPath(), Collections.emptyList())) {
                    regionToPatternMap.computeIfAbsent(regionReplicaSet, o -> new ArrayList()).addAll(pathPattern.alterPrefixPath(devicePath));
                }
            }
        }
        return regionToPatternMap.keySet().stream().map(o -> new DeleteDataNode(this.getPlanNodeId(), (List)regionToPatternMap.get(o), this.deleteStartTime, this.deleteEndTime, (TRegionReplicaSet)o)).collect(Collectors.toList());
    }
}

