/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;

public class FillNode
extends ProcessNode {
    private FillDescriptor fillDescriptor;
    private PlanNode child;

    public FillNode(PlanNodeId id) {
        super(id);
    }

    public FillNode(PlanNodeId id, FillDescriptor fillDescriptor) {
        this(id);
        this.fillDescriptor = fillDescriptor;
    }

    public FillNode(PlanNodeId id, PlanNode child, FillDescriptor fillDescriptor) {
        this(id, fillDescriptor);
        this.child = child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    public PlanNode getChild() {
        return this.child;
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public PlanNode clone() {
        return new FillNode(this.getPlanNodeId(), this.fillDescriptor);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFill(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.FILL.serialize(byteBuffer);
        this.fillDescriptor.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.FILL.serialize(stream);
        this.fillDescriptor.serialize(stream);
    }

    public static FillNode deserialize(ByteBuffer byteBuffer) {
        FillDescriptor fillDescriptor = FillDescriptor.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new FillNode(planNodeId, fillDescriptor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FillNode fillNode = (FillNode)o;
        return Objects.equals(this.fillDescriptor, fillNode.fillDescriptor) && Objects.equals(this.child, fillNode.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fillDescriptor, this.child);
    }

    public FillDescriptor getFillDescriptor() {
        return this.fillDescriptor;
    }
}

