/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.leaf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TimestampOperand
extends LeafOperand {
    public static final PartialPath TIMESTAMP_PARTIAL_PATH = new PartialPath("Time", false);

    public TimestampOperand() {
    }

    public TimestampOperand(ByteBuffer byteBuffer) {
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return true;
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        resultExpressions.add(this);
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        resultExpressions.add(this);
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        pathSet.add(TIMESTAMP_PARTIAL_PATH);
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) {
        typeProvider.setType(this.toString(), TSDataType.INT64);
        return TSDataType.INT64;
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = rawTimeSeriesInputLayer.constructTimePointReader();
            expressionDataTypeMap.put(this, parentLayerPointReader.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, TypeProvider typeProvider, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = rawTimeSeriesInputLayer.constructTimePointReader();
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    protected boolean isConstantOperandInternal() {
        return false;
    }

    @Override
    protected String getExpressionStringInternal() {
        return "Time";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.TIMESTAMP;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
    }
}

