/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;

public class SetStorageGroupTask
implements IConfigTask {
    private final SetStorageGroupStatement setStorageGroupStatement;

    public SetStorageGroupTask(SetStorageGroupStatement setStorageGroupStatement) {
        this.setStorageGroupStatement = setStorageGroupStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        return configTaskExecutor.setStorageGroup(this.setStorageGroupStatement);
    }

    public static TStorageGroupSchema constructStorageGroupSchema(SetStorageGroupStatement setStorageGroupStatement) {
        TStorageGroupSchema storageGroupSchema = new TStorageGroupSchema();
        storageGroupSchema.setName(setStorageGroupStatement.getStorageGroupPath().getFullPath());
        if (setStorageGroupStatement.getTTL() != null) {
            storageGroupSchema.setTTL(setStorageGroupStatement.getTTL().longValue());
        }
        if (setStorageGroupStatement.getSchemaReplicationFactor() != null) {
            storageGroupSchema.setSchemaReplicationFactor(setStorageGroupStatement.getSchemaReplicationFactor().intValue());
        }
        if (setStorageGroupStatement.getDataReplicationFactor() != null) {
            storageGroupSchema.setDataReplicationFactor(setStorageGroupStatement.getDataReplicationFactor().intValue());
        }
        if (setStorageGroupStatement.getTimePartitionInterval() != null) {
            storageGroupSchema.setTimePartitionInterval(setStorageGroupStatement.getTimePartitionInterval().longValue());
        }
        return storageGroupSchema;
    }
}

