/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.service.metrics.recorder.CacheMetricsRecorder;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPartitionFetcher
implements IPartitionFetcher {
    private static final Logger logger = LoggerFactory.getLogger(ClusterPartitionFetcher.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final List<String> ROOT_PATH = Arrays.asList("root", "**");
    private final SeriesPartitionExecutor partitionExecutor;
    private final PartitionCache partitionCache;
    private final IClientManager<PartitionRegionId, ConfigNodeClient> configNodeClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());

    public static ClusterPartitionFetcher getInstance() {
        return ClusterPartitionFetcherHolder.INSTANCE;
    }

    private ClusterPartitionFetcher() {
        this.partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)config.getSeriesPartitionExecutorClass(), (int)config.getSeriesPartitionSlotNum());
        this.partitionCache = new PartitionCache(config.getSeriesPartitionExecutorClass(), config.getSeriesPartitionSlotNum());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaPartition getSchemaPartition(PathPatternTree patternTree) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSchemaPartitionResp schemaPartitionResp;
            patternTree.constructTree();
            List<String> devicePaths = patternTree.getAllDevicePatterns();
            Map<String, String> deviceToStorageGroupMap = this.getDeviceToStorageGroup(devicePaths, false);
            SchemaPartition schemaPartition = this.partitionCache.getSchemaPartition(deviceToStorageGroupMap);
            if (null == schemaPartition && (schemaPartitionResp = client.getSchemaPartition(this.constructSchemaPartitionReq(patternTree))).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                schemaPartition = this.parseSchemaPartitionResp(schemaPartitionResp);
                this.partitionCache.updateSchemaPartitionCache(devicePaths, schemaPartition);
            }
            SchemaPartition schemaPartition2 = schemaPartition;
            return schemaPartition2;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getSchemaPartition():" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaPartition getOrCreateSchemaPartition(PathPatternTree patternTree) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            patternTree.constructTree();
            List<String> devicePaths = patternTree.getAllDevicePatterns();
            Map<String, String> deviceToStorageGroupMap = this.getDeviceToStorageGroup(devicePaths, true);
            SchemaPartition schemaPartition = this.partitionCache.getSchemaPartition(deviceToStorageGroupMap);
            if (null == schemaPartition) {
                TSchemaPartitionResp schemaPartitionResp = client.getOrCreateSchemaPartition(this.constructSchemaPartitionReq(patternTree));
                if (schemaPartitionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) throw new RuntimeException((Throwable)new IoTDBException(schemaPartitionResp.getStatus().getMessage(), schemaPartitionResp.getStatus().getCode()));
                schemaPartition = this.parseSchemaPartitionResp(schemaPartitionResp);
                this.partitionCache.updateSchemaPartitionCache(devicePaths, schemaPartition);
            }
            SchemaPartition schemaPartition2 = schemaPartition;
            return schemaPartition2;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getOrCreateSchemaPartition():" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaNodeManagementPartition getSchemaNodeManagementPartitionWithLevel(PathPatternTree patternTree, Integer level) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            patternTree.constructTree();
            TSchemaNodeManagementResp schemaNodeManagementResp = client.getSchemaNodeManagementPartition(this.constructSchemaNodeManagementPartitionReq(patternTree, level));
            SchemaNodeManagementPartition schemaNodeManagementPartition = this.parseSchemaNodeManagementPartitionResp(schemaNodeManagementResp);
            return schemaNodeManagementPartition;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getSchemaNodeManagementPartition():" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TDataPartitionResp dataPartitionResp = client.getDataPartition(this.constructDataPartitionReq(sgNameToQueryParamsMap));
            if (dataPartitionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) return null;
            DataPartition dataPartition = this.parseDataPartitionResp(dataPartitionResp);
            return dataPartition;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getDataPartition():" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataPartition getDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TDataPartitionResp dataPartitionResp;
            Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParams = this.splitDataPartitionQueryParam(dataPartitionQueryParams, false);
            DataPartition dataPartition = this.partitionCache.getDataPartition(splitDataPartitionQueryParams);
            if (null == dataPartition && (dataPartitionResp = client.getDataPartition(this.constructDataPartitionReq(splitDataPartitionQueryParams))).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                dataPartition = this.parseDataPartitionResp(dataPartitionResp);
                this.partitionCache.updateDataPartitionCache(dataPartition);
            }
            DataPartition dataPartition2 = dataPartition;
            return dataPartition2;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getDataPartition():" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataPartition getOrCreateDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TDataPartitionResp dataPartitionResp = client.getOrCreateDataPartition(this.constructDataPartitionReq(sgNameToQueryParamsMap));
            if (dataPartitionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) return null;
            DataPartition dataPartition = this.parseDataPartitionResp(dataPartitionResp);
            return dataPartition;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataPartition getOrCreateDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TDataPartitionResp dataPartitionResp;
            Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParams = this.splitDataPartitionQueryParam(dataPartitionQueryParams, true);
            DataPartition dataPartition = this.partitionCache.getDataPartition(splitDataPartitionQueryParams);
            if (null == dataPartition && (dataPartitionResp = client.getOrCreateDataPartition(this.constructDataPartitionReq(splitDataPartitionQueryParams))).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                dataPartition = this.parseDataPartitionResp(dataPartitionResp);
                this.partitionCache.updateDataPartitionCache(dataPartition);
            }
            DataPartition dataPartition2 = dataPartition;
            return dataPartition2;
        }
        catch (IOException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
        }
    }

    @Override
    public void invalidAllCache() {
        logger.debug("Invalidate partition cache");
        this.partitionCache.storageGroupCache.clear();
        this.partitionCache.invalidAllDataPartitionCache();
        this.partitionCache.invalidAllSchemaPartitionCache();
        logger.debug("PartitionCache is invalid:{}", (Object)this.partitionCache);
    }

    private Map<String, String> getDeviceToStorageGroup(List<String> devicePaths, boolean isAutoCreate) {
        HashMap<String, String> deviceToStorageGroup = new HashMap<String, String>();
        for (String devicePath : devicePaths) {
            if (!devicePath.contains("*")) continue;
            return deviceToStorageGroup;
        }
        boolean firstTryResult = this.partitionCache.getStorageGroup(devicePaths, deviceToStorageGroup);
        if (!firstTryResult) {
            try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                TStorageGroupSchemaResp storageGroupSchemaResp = client.getMatchedStorageGroupSchemas(ROOT_PATH);
                if (storageGroupSchemaResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    Set<String> storageGroupNames = storageGroupSchemaResp.getStorageGroupSchemaMap().keySet();
                    this.partitionCache.updateStorageCache(storageGroupNames);
                    deviceToStorageGroup = new HashMap();
                    boolean secondTryResult = this.partitionCache.getStorageGroup(devicePaths, deviceToStorageGroup);
                    if (!secondTryResult && isAutoCreate) {
                        HashSet<String> storageGroupNamesNeedCreated = new HashSet<String>();
                        for (String string : devicePaths) {
                            if (deviceToStorageGroup.containsKey(string)) continue;
                            PartialPath storageGroupNameNeedCreated = MetaUtils.getStorageGroupPathByLevel(new PartialPath(string), config.getDefaultStorageGroupLevel());
                            storageGroupNamesNeedCreated.add(storageGroupNameNeedCreated.getFullPath());
                        }
                        HashSet<String> successFullyCreatedStorageGroup = new HashSet<String>();
                        for (String storageGroupName : storageGroupNamesNeedCreated) {
                            TStorageGroupSchema storageGroupSchema = new TStorageGroupSchema();
                            storageGroupSchema.setName(storageGroupName);
                            TSetStorageGroupReq req = new TSetStorageGroupReq(storageGroupSchema);
                            TSStatus tsStatus = client.setStorageGroup(req);
                            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                                successFullyCreatedStorageGroup.add(storageGroupName);
                                continue;
                            }
                            this.partitionCache.updateStorageCache(successFullyCreatedStorageGroup);
                            throw new RuntimeException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
                        }
                        this.partitionCache.updateStorageCache(storageGroupNamesNeedCreated);
                        deviceToStorageGroup = new HashMap();
                        boolean bl = this.partitionCache.getStorageGroup(devicePaths, deviceToStorageGroup);
                        if (!bl) {
                            throw new StatementAnalyzeException("Failed to get Storage Group Map when executing getOrCreateDataPartition()");
                        }
                    }
                }
            }
            catch (IOException | MetadataException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
            }
        }
        return deviceToStorageGroup;
    }

    private Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParam(List<DataPartitionQueryParam> dataPartitionQueryParams, boolean isAutoCreate) {
        ArrayList<String> devicePaths = new ArrayList<String>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            devicePaths.add(dataPartitionQueryParam.getDevicePath());
        }
        Map<String, String> deviceToStorageGroup = this.getDeviceToStorageGroup(devicePaths, isAutoCreate);
        HashMap<String, List<DataPartitionQueryParam>> result = new HashMap<String, List<DataPartitionQueryParam>>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            String devicePath = dataPartitionQueryParam.getDevicePath();
            if (!deviceToStorageGroup.containsKey(devicePath)) continue;
            String storageGroup = deviceToStorageGroup.get(devicePath);
            if (!result.containsKey(storageGroup)) {
                result.put(storageGroup, new ArrayList());
            }
            ((List)result.get(storageGroup)).add(dataPartitionQueryParam);
        }
        return result;
    }

    private TSchemaPartitionReq constructSchemaPartitionReq(PathPatternTree patternTree) {
        PublicBAOS baos = new PublicBAOS();
        try {
            patternTree.serialize(baos);
            ByteBuffer serializedPatternTree = ByteBuffer.allocate(baos.size());
            serializedPatternTree.put(baos.getBuf(), 0, baos.size());
            serializedPatternTree.flip();
            return new TSchemaPartitionReq(serializedPatternTree);
        }
        catch (IOException e) {
            throw new StatementAnalyzeException("An error occurred when serializing pattern tree");
        }
    }

    private TSchemaNodeManagementReq constructSchemaNodeManagementPartitionReq(PathPatternTree patternTree, Integer level) {
        PublicBAOS baos = new PublicBAOS();
        try {
            patternTree.serialize(baos);
            ByteBuffer serializedPatternTree = ByteBuffer.allocate(baos.size());
            serializedPatternTree.put(baos.getBuf(), 0, baos.size());
            serializedPatternTree.flip();
            TSchemaNodeManagementReq schemaNodeManagementReq = new TSchemaNodeManagementReq(serializedPatternTree);
            if (null == level) {
                schemaNodeManagementReq.setLevel(-1);
            } else {
                schemaNodeManagementReq.setLevel(level.intValue());
            }
            return schemaNodeManagementReq;
        }
        catch (IOException e) {
            throw new StatementAnalyzeException("An error occurred when serializing pattern tree");
        }
    }

    private TDataPartitionReq constructDataPartitionReq(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        HashMap partitionSlotsMap = new HashMap();
        for (Map.Entry<String, List<DataPartitionQueryParam>> entry : sgNameToQueryParamsMap.entrySet()) {
            HashMap deviceToTimePartitionMap = new HashMap();
            for (DataPartitionQueryParam queryParam : entry.getValue()) {
                if (queryParam.getSeriesPartitionSlot() == null) {
                    queryParam.setSeriesPartitionSlot(this.partitionExecutor.getSeriesPartitionSlot(queryParam.getDevicePath()));
                }
                deviceToTimePartitionMap.put(new TSeriesPartitionSlot(queryParam.getSeriesPartitionSlot().getSlotId()), queryParam.getTimePartitionSlotList().stream().map(timePartitionSlot -> new TTimePartitionSlot(timePartitionSlot.getStartTime())).collect(Collectors.toList()));
            }
            partitionSlotsMap.put(entry.getKey(), deviceToTimePartitionMap);
        }
        return new TDataPartitionReq(partitionSlotsMap);
    }

    private SchemaPartition parseSchemaPartitionResp(TSchemaPartitionResp schemaPartitionResp) {
        return new SchemaPartition(schemaPartitionResp.getSchemaRegionMap(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
    }

    private SchemaNodeManagementPartition parseSchemaNodeManagementPartitionResp(TSchemaNodeManagementResp schemaNodeManagementResp) {
        return new SchemaNodeManagementPartition(schemaNodeManagementResp.getSchemaRegionMap(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum(), schemaNodeManagementResp.getMatchedNode());
    }

    private DataPartition parseDataPartitionResp(TDataPartitionResp dataPartitionResp) {
        return new DataPartition(dataPartitionResp.getDataPartitionMap(), config.getSeriesPartitionExecutorClass(), config.getSeriesPartitionSlotNum());
    }

    static /* synthetic */ IoTDBConfig access$300() {
        return config;
    }

    private static class DataPartitionCacheKey {
        private TSeriesPartitionSlot seriesPartitionSlot;
        private TTimePartitionSlot timePartitionSlot;

        public DataPartitionCacheKey(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
            this.seriesPartitionSlot = seriesPartitionSlot;
            this.timePartitionSlot = timePartitionSlot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPartitionCacheKey that = (DataPartitionCacheKey)o;
            return Objects.equals(this.seriesPartitionSlot, that.seriesPartitionSlot) && Objects.equals(this.timePartitionSlot, that.timePartitionSlot);
        }

        public int hashCode() {
            return Objects.hash(this.seriesPartitionSlot, this.timePartitionSlot);
        }
    }

    private class PartitionCache {
        private final int cacheSize = ClusterPartitionFetcher.access$300().getPartitionCacheSize();
        private final Set<String> storageGroupCache = Collections.synchronizedSet(new HashSet());
        private final ReentrantReadWriteLock storageGroupCacheLock = new ReentrantReadWriteLock();
        private final Cache<String, TRegionReplicaSet> schemaPartitionCache;
        private final ReentrantReadWriteLock schemaPartitionCacheLock = new ReentrantReadWriteLock();
        private final Cache<DataPartitionCacheKey, List<TRegionReplicaSet>> dataPartitionCache;
        private final ReentrantReadWriteLock dataPartitionCacheLock = new ReentrantReadWriteLock();
        private final String seriesSlotExecutorName;
        private final int seriesPartitionSlotNum;

        public PartitionCache(String seriesSlotExecutorName, int seriesPartitionSlotNum) {
            this.seriesSlotExecutorName = seriesSlotExecutorName;
            this.seriesPartitionSlotNum = seriesPartitionSlotNum;
            this.schemaPartitionCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize).build();
            this.dataPartitionCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getStorageGroup(List<String> devicePaths, Map<String, String> deviceToStorageGroupMap) {
            this.storageGroupCacheLock.readLock().lock();
            try {
                boolean result = true;
                if (this.storageGroupCache.size() == 0) {
                    logger.debug("Failed to get storage group");
                    result = false;
                } else {
                    for (String devicePath : devicePaths) {
                        boolean hit = false;
                        Set<String> set = this.storageGroupCache;
                        synchronized (set) {
                            for (String storageGroup : this.storageGroupCache) {
                                if (!PathUtils.isStartWith((String)devicePath, (String)storageGroup)) continue;
                                deviceToStorageGroupMap.put(devicePath, storageGroup);
                                hit = true;
                                break;
                            }
                        }
                        if (hit) continue;
                        logger.debug("{} cannot hit storage group cache", (Object)devicePath);
                        result = false;
                        break;
                    }
                }
                CacheMetricsRecorder.record(result, "StorageGroup");
                boolean bl = result;
                return bl;
            }
            finally {
                this.storageGroupCacheLock.readLock().unlock();
            }
        }

        public void updateStorageCache(Set<String> storageGroupNames) {
            this.storageGroupCacheLock.writeLock().lock();
            try {
                this.storageGroupCache.addAll(storageGroupNames);
            }
            finally {
                this.storageGroupCacheLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidStorageGroupCache(List<String> storageGroupNames) {
            this.storageGroupCacheLock.writeLock().lock();
            try {
                for (String storageGroupName : storageGroupNames) {
                    this.storageGroupCache.remove(storageGroupName);
                }
            }
            finally {
                this.storageGroupCacheLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SchemaPartition getSchemaPartition(Map<String, String> deviceToStorageGroupMap) {
            this.schemaPartitionCacheLock.readLock().lock();
            try {
                String name = "SchemaPartition";
                if (deviceToStorageGroupMap.size() == 0) {
                    CacheMetricsRecorder.record(false, name);
                    SchemaPartition schemaPartition = null;
                    return schemaPartition;
                }
                HashMap schemaPartitionMap = new HashMap();
                for (Map.Entry<String, String> entry : deviceToStorageGroupMap.entrySet()) {
                    String device = entry.getKey();
                    TSeriesPartitionSlot seriesPartitionSlot = ClusterPartitionFetcher.this.partitionExecutor.getSeriesPartitionSlot(device);
                    TRegionReplicaSet regionReplicaSet = (TRegionReplicaSet)this.schemaPartitionCache.getIfPresent((Object)device);
                    if (null == regionReplicaSet) {
                        logger.debug("Failed to find schema partition");
                        CacheMetricsRecorder.record(false, name);
                        SchemaPartition schemaPartition = null;
                        return schemaPartition;
                    }
                    String storageGroupName = deviceToStorageGroupMap.get(device);
                    if (!schemaPartitionMap.containsKey(storageGroupName)) {
                        schemaPartitionMap.put(storageGroupName, new HashMap());
                    }
                    Map regionReplicaSetMap = (Map)schemaPartitionMap.get(storageGroupName);
                    regionReplicaSetMap.put(seriesPartitionSlot, regionReplicaSet);
                }
                logger.debug("Hit schema partition");
                CacheMetricsRecorder.record(true, name);
                SchemaPartition schemaPartition = new SchemaPartition(schemaPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
                return schemaPartition;
            }
            finally {
                this.schemaPartitionCacheLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
            this.dataPartitionCacheLock.readLock().lock();
            try {
                String name = "DataPartition";
                if (sgNameToQueryParamsMap.size() == 0) {
                    CacheMetricsRecorder.record(false, name);
                    DataPartition dataPartition = null;
                    return dataPartition;
                }
                HashMap dataPartitionMap = new HashMap();
                for (Map.Entry<String, List<DataPartitionQueryParam>> entry : sgNameToQueryParamsMap.entrySet()) {
                    String storageGroupName = entry.getKey();
                    if (!dataPartitionMap.containsKey(storageGroupName)) {
                        dataPartitionMap.put(storageGroupName, new HashMap());
                    }
                    Map seriesSlotToTimePartitionMap = (Map)dataPartitionMap.get(storageGroupName);
                    for (DataPartitionQueryParam dataPartitionQueryParam : entry.getValue()) {
                        if (null == dataPartitionQueryParam.getTimePartitionSlotList() || 0 == dataPartitionQueryParam.getTimePartitionSlotList().size()) {
                            logger.debug("Failed to find data partition");
                            CacheMetricsRecorder.record(false, name);
                            DataPartition dataPartition = null;
                            return dataPartition;
                        }
                        TSeriesPartitionSlot seriesPartitionSlot = ClusterPartitionFetcher.this.partitionExecutor.getSeriesPartitionSlot(dataPartitionQueryParam.getDevicePath());
                        if (!seriesSlotToTimePartitionMap.containsKey(seriesPartitionSlot)) {
                            seriesSlotToTimePartitionMap.put(seriesPartitionSlot, new HashMap());
                        }
                        Map timePartitionSlotListMap = (Map)seriesSlotToTimePartitionMap.get(seriesPartitionSlot);
                        for (TTimePartitionSlot timePartitionSlot : dataPartitionQueryParam.getTimePartitionSlotList()) {
                            DataPartitionCacheKey dataPartitionCacheKey = new DataPartitionCacheKey(seriesPartitionSlot, timePartitionSlot);
                            List regionReplicaSets = (List)this.dataPartitionCache.getIfPresent((Object)dataPartitionCacheKey);
                            if (null == regionReplicaSets) {
                                logger.debug("Failed to find data partition");
                                CacheMetricsRecorder.record(false, name);
                                DataPartition dataPartition = null;
                                return dataPartition;
                            }
                            timePartitionSlotListMap.put(timePartitionSlot, regionReplicaSets);
                        }
                    }
                }
                logger.debug("Hit data partition");
                CacheMetricsRecorder.record(true, name);
                DataPartition dataPartition = new DataPartition(dataPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
                return dataPartition;
            }
            finally {
                this.dataPartitionCacheLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSchemaPartitionCache(List<String> devices, SchemaPartition schemaPartition) {
            this.schemaPartitionCacheLock.writeLock().lock();
            try {
                Map storageGroupPartitionMap = schemaPartition.getSchemaPartitionMap();
                Set storageGroupNames = storageGroupPartitionMap.keySet();
                for (String device : devices) {
                    if (device.contains("*")) continue;
                    String storageGroup = null;
                    for (String storageGroupName : storageGroupNames) {
                        if (!PathUtils.isStartWith((String)device, (String)storageGroupName)) continue;
                        storageGroup = storageGroupName;
                        break;
                    }
                    if (null == storageGroup) continue;
                    TSeriesPartitionSlot seriesPartitionSlot = ClusterPartitionFetcher.this.partitionExecutor.getSeriesPartitionSlot(device);
                    TRegionReplicaSet regionReplicaSet = ((Map)storageGroupPartitionMap.get(storageGroup)).getOrDefault(seriesPartitionSlot, null);
                    if (null == regionReplicaSet) {
                        logger.error("Failed to get the regionReplicaSet of {} when update SchemaPartitionCache", (Object)device);
                        continue;
                    }
                    this.schemaPartitionCache.put((Object)device, (Object)regionReplicaSet);
                }
            }
            finally {
                this.schemaPartitionCacheLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateDataPartitionCache(DataPartition dataPartition) {
            this.dataPartitionCacheLock.writeLock().lock();
            try {
                for (Map.Entry entry1 : dataPartition.getDataPartitionMap().entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                        TSeriesPartitionSlot seriesPartitionSlot = (TSeriesPartitionSlot)entry2.getKey();
                        for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                            DataPartitionCacheKey dataPartitionCacheKey = new DataPartitionCacheKey(seriesPartitionSlot, (TTimePartitionSlot)entry3.getKey());
                            this.dataPartitionCache.put((Object)dataPartitionCacheKey, entry3.getValue());
                        }
                    }
                }
            }
            finally {
                this.dataPartitionCacheLock.writeLock().unlock();
            }
        }

        public void invalidSchemaPartitionCache(String device) {
            this.schemaPartitionCacheLock.writeLock().lock();
            try {
                this.schemaPartitionCache.invalidate((Object)device);
            }
            finally {
                this.schemaPartitionCacheLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidDataPartitionCache(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
            this.dataPartitionCacheLock.writeLock().lock();
            try {
                DataPartitionCacheKey dataPartitionCacheKey = new DataPartitionCacheKey(seriesPartitionSlot, timePartitionSlot);
                this.dataPartitionCache.invalidate((Object)dataPartitionCacheKey);
            }
            finally {
                this.dataPartitionCacheLock.writeLock().unlock();
            }
        }

        public void invalidAllSchemaPartitionCache() {
            this.schemaPartitionCacheLock.writeLock().lock();
            try {
                this.schemaPartitionCache.invalidateAll();
            }
            finally {
                this.schemaPartitionCacheLock.writeLock().unlock();
            }
        }

        public void invalidAllDataPartitionCache() {
            this.dataPartitionCacheLock.writeLock().lock();
            try {
                this.dataPartitionCache.invalidateAll();
            }
            finally {
                this.dataPartitionCacheLock.writeLock().unlock();
            }
        }

        public String toString() {
            return "PartitionCache{cacheSize=" + this.cacheSize + ", storageGroupCache=" + this.storageGroupCache + ", schemaPartitionCache=" + this.schemaPartitionCache + ", dataPartitionCache=" + this.dataPartitionCache + '}';
        }
    }

    private static final class ClusterPartitionFetcherHolder {
        private static final ClusterPartitionFetcher INSTANCE = new ClusterPartitionFetcher();

        private ClusterPartitionFetcherHolder() {
        }
    }
}

