/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePathsConvertOperator
implements ProcessOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePathsConvertOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;

    public NodePathsConvertOperator(OperatorContext operatorContext, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        TsBlock block = this.child.next();
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(HeaderConstant.showChildNodesHeader.getRespDataTypes());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            PartialPath partialPath;
            String path = block.getColumn(0).getBinary(i).toString();
            try {
                partialPath = new PartialPath(path);
            }
            catch (IllegalPathException e) {
                LOGGER.warn("Failed to convert node path to PartialPath {}", (Object)path);
                continue;
            }
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(partialPath.getTailNode()));
            tsBlockBuilder.declarePosition();
        }
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.child.isFinished();
    }
}

