/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class OffsetOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private long remainingOffset;
    private final Operator child;

    public OffsetOperator(OperatorContext operatorContext, long offset, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be at least zero");
        this.remainingOffset = offset;
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        TsBlock block = this.child.next();
        if (block == null) {
            return null;
        }
        if (this.remainingOffset > 0L) {
            int offset = Math.min((int)this.remainingOffset, block.getPositionCount());
            this.remainingOffset -= (long)offset;
            return block.getRegion(offset, block.getPositionCount() - offset);
        }
        return block;
    }

    @Override
    public boolean hasNext() {
        return this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.child.isFinished();
    }
}

