/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.template;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.template.DuplicatedTemplateException;
import org.apache.iotdb.db.exception.metadata.template.UndefinedTemplateException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateLogReader;
import org.apache.iotdb.db.metadata.template.TemplateLogWriter;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager {
    private static final Logger logger = LoggerFactory.getLogger(TemplateManager.class);
    private Map<String, Template> templateMap = new ConcurrentHashMap<String, Template>();
    private Map<Integer, String> templateHashMap = new ConcurrentHashMap<Integer, String>();
    private final Map<String, Set<Template>> templateUsageInStorageGroup = new ConcurrentHashMap<String, Set<Template>>();
    private TemplateLogWriter logWriter;
    private boolean isRecover;

    public static TemplateManager getInstance() {
        return TemplateManagerHolder.INSTANCE;
    }

    private TemplateManager() {
    }

    public void init() throws IOException {
        this.isRecover = true;
        this.recoverFromTemplateFile();
        this.logWriter = new TemplateLogWriter(IoTDBDescriptor.getInstance().getConfig().getSchemaDir(), "template_log.bin");
        this.isRecover = false;
    }

    private void recoverFromTemplateFile() throws IOException {
        File logFile = new File(IoTDBDescriptor.getInstance().getConfig().getSchemaDir(), "template_log.bin");
        if (!logFile.exists()) {
            return;
        }
        try (TemplateLogReader reader = new TemplateLogReader(IoTDBDescriptor.getInstance().getConfig().getSchemaDir(), "template_log.bin");){
            int idx = 0;
            block19: while (reader.hasNext()) {
                PhysicalPlan plan;
                try {
                    plan = reader.next();
                    ++idx;
                }
                catch (Exception e) {
                    logger.error("Parse TemplateFile error at lineNumber {} because:", (Object)idx, (Object)e);
                    break;
                }
                if (plan == null) continue;
                try {
                    switch (plan.getOperatorType()) {
                        case CREATE_TEMPLATE: {
                            this.createSchemaTemplate((CreateTemplatePlan)plan);
                            continue block19;
                        }
                        case APPEND_TEMPLATE: {
                            this.appendSchemaTemplate((AppendTemplatePlan)plan);
                            continue block19;
                        }
                        case PRUNE_TEMPLATE: {
                            this.pruneSchemaTemplate((PruneTemplatePlan)plan);
                            continue block19;
                        }
                        case DROP_TEMPLATE: {
                            this.dropSchemaTemplate((DropTemplatePlan)plan);
                            continue block19;
                        }
                    }
                    throw new IOException("Template file corrupted. Read unknown plan type during recover.");
                }
                catch (IOException | MetadataException e) {
                    logger.error("Can not operate cmd {} in TemplateFile for err:", (Object)plan.getOperatorType(), (Object)e);
                }
            }
        }
    }

    public void createSchemaTemplate(CreateTemplatePlan plan) throws MetadataException {
        List<List<TSDataType>> dataTypes = plan.getDataTypes();
        List<List<TSEncoding>> encodings = plan.getEncodings();
        for (int i = 0; i < dataTypes.size(); ++i) {
            for (int j = 0; j < dataTypes.get(i).size(); ++j) {
                SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i).get(j), encodings.get(i).get(j));
            }
        }
        if (plan.getSchemaNames() != null) {
            for (String schemaNames : plan.getSchemaNames()) {
                MetaFormatUtils.checkNodeName(schemaNames);
            }
        }
        for (List<String> measurements : plan.getMeasurements()) {
            for (String measurement : measurements) {
                MetaFormatUtils.checkTimeseries(new PartialPath(measurement));
            }
        }
        Template template = new Template(plan);
        if (this.templateMap.putIfAbsent(plan.getName(), template) != null) {
            throw new MetadataException("Duplicated template name: " + plan.getName());
        }
        this.addToHashMap(template);
        try {
            if (!this.isRecover) {
                this.logWriter.createSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    private void addToHashMap(Template template) {
        if (this.templateHashMap.size() >= 0x7FFFFFFE) {
            logger.error("Too many templates have been registered.");
            return;
        }
        while (this.templateHashMap.containsKey(template.hashCode())) {
            if (template.hashCode() == Integer.MAX_VALUE) {
                template.setRehash(Integer.MIN_VALUE);
            }
            if (template.hashCode() == 0) {
                template.setRehash(1);
            }
            template.setRehash(template.hashCode() + 1);
        }
        this.templateHashMap.put(template.hashCode(), template.getName());
    }

    public void dropSchemaTemplate(DropTemplatePlan plan) throws MetadataException {
        this.templateHashMap.remove(this.templateMap.get(plan.getName()).hashCode());
        this.templateMap.remove(plan.getName());
        try {
            if (!this.isRecover) {
                this.logWriter.dropSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    public void appendSchemaTemplate(AppendTemplatePlan plan) throws MetadataException {
        List<TSDataType> dataTypeList = plan.getDataTypes();
        List<TSEncoding> encodingList = plan.getEncodings();
        for (int idx = 0; idx < dataTypeList.size(); ++idx) {
            SchemaUtils.checkDataTypeWithEncoding(dataTypeList.get(idx), encodingList.get(idx));
        }
        String templateName = plan.getName();
        Template temp = this.templateMap.getOrDefault(templateName, null);
        if (temp != null) {
            String[] measurements = plan.getMeasurements().toArray(new String[0]);
            TSDataType[] dataTypes = new TSDataType[measurements.length];
            TSEncoding[] encodings = new TSEncoding[measurements.length];
            CompressionType[] compressionTypes = new CompressionType[measurements.length];
            for (int i = 0; i < measurements.length; ++i) {
                dataTypes[i] = plan.getDataTypes().get(i);
                encodings[i] = plan.getEncodings().get(i);
                compressionTypes[i] = plan.getCompressors().get(i);
            }
            if (plan.isAligned()) {
                temp.addAlignedMeasurements(measurements, dataTypes, encodings, compressionTypes);
            } else {
                temp.addUnalignedMeasurements(measurements, dataTypes, encodings, compressionTypes);
            }
        } else {
            throw new MetadataException("Template does not exists:" + plan.getName());
        }
        try {
            if (!this.isRecover) {
                this.logWriter.appendSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    public void pruneSchemaTemplate(PruneTemplatePlan plan) throws MetadataException {
        String templateName = plan.getName();
        Template temp = this.templateMap.getOrDefault(templateName, null);
        if (temp != null) {
            for (int i = 0; i < plan.getPrunedMeasurements().size(); ++i) {
                temp.deleteSeriesCascade(plan.getPrunedMeasurements().get(i));
            }
        } else {
            throw new MetadataException("Template does not exists:" + plan.getName());
        }
        try {
            if (!this.isRecover) {
                this.logWriter.pruneSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    public Template getTemplate(String templateName) throws UndefinedTemplateException {
        Template template = this.templateMap.get(templateName);
        if (template == null) {
            throw new UndefinedTemplateException(templateName);
        }
        return template;
    }

    public Template getTemplateFromHash(int hashcode) throws MetadataException {
        if (!this.templateHashMap.containsKey(hashcode)) {
            throw new MetadataException("Invalid hash code for schema template: " + hashcode);
        }
        return this.getTemplate(this.templateHashMap.get(hashcode));
    }

    public void setTemplateMap(Map<String, Template> templateMap) {
        this.templateMap.clear();
        for (Map.Entry<String, Template> templateEntry : templateMap.entrySet()) {
            this.templateMap.put(templateEntry.getKey(), templateEntry.getValue());
            this.addToHashMap(templateEntry.getValue());
        }
    }

    public Map<String, Template> getTemplateMap() {
        return this.templateMap;
    }

    public Set<String> getAllTemplateName() {
        return this.templateMap.keySet();
    }

    public void checkIsTemplateCompatible(Template template, IMNode node) throws MetadataException {
        if (node.getSchemaTemplate() != null) {
            if (node.getSchemaTemplate().equals(template)) {
                throw new DuplicatedTemplateException(template.getName());
            }
            throw new MetadataException("Specified node already has template");
        }
        if (node.isEntity() && node.getAsEntityMNode().isAligned() != template.isDirectAligned()) {
            for (IMNode dNode : template.getDirectNodes()) {
                if (!dNode.isMeasurement()) continue;
                throw new MetadataException(String.format("Template[%s] and mounted node[%s] has different alignment.", template.getName(), node.getFullPath() + '.' + dNode.getFullPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSchemaRegion(Template template, String storageGroup, SchemaRegionId schemaRegionId) {
        Map<String, Set<Template>> map = this.templateUsageInStorageGroup;
        synchronized (map) {
            if (!this.templateUsageInStorageGroup.containsKey(storageGroup)) {
                this.templateUsageInStorageGroup.putIfAbsent(storageGroup, Collections.synchronizedSet(new HashSet()));
            }
        }
        this.templateUsageInStorageGroup.get(storageGroup).add(template);
        template.markSchemaRegion(storageGroup, schemaRegionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkSchemaRegion(Template template, String storageGroup, SchemaRegionId schemaRegionId) {
        Set<Template> usageInStorageGroup = this.templateUsageInStorageGroup.get(storageGroup);
        usageInStorageGroup.remove(template);
        Map<String, Set<Template>> map = this.templateUsageInStorageGroup;
        synchronized (map) {
            if (usageInStorageGroup.isEmpty()) {
                this.templateUsageInStorageGroup.remove(storageGroup);
            }
        }
        template.unmarkSchemaRegion(storageGroup, schemaRegionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkStorageGroup(Template template, String storageGroup) {
        Map<String, Set<Template>> map = this.templateUsageInStorageGroup;
        synchronized (map) {
            this.templateUsageInStorageGroup.remove(storageGroup);
        }
        template.unmarkStorageGroup(storageGroup);
    }

    public void forceLog() {
        try {
            this.logWriter.force();
        }
        catch (IOException e) {
            logger.error("Cannot force template log", (Throwable)e);
        }
    }

    public void clear() throws IOException {
        this.templateMap.clear();
        this.templateUsageInStorageGroup.clear();
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    private static class TemplateManagerHolder {
        private static final TemplateManager INSTANCE = new TemplateManager();

        private TemplateManagerHolder() {
        }
    }
}

