/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.tsfile.read.common.Path;

public class PathDeserializeUtil {
    public static Path deserialize(ByteBuffer buffer) {
        byte pathType = buffer.get();
        switch (pathType) {
            case 0: {
                return MeasurementPath.deserialize(buffer);
            }
            case 1: {
                return AlignedPath.deserialize(buffer);
            }
            case 2: {
                return PartialPath.deserialize((ByteBuffer)buffer);
            }
            case 3: {
                return Path.deserialize((ByteBuffer)buffer);
            }
        }
        throw new IllegalArgumentException("Invalid path type: " + pathType);
    }
}

