/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.forward.http;

import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.apache.iotdb.db.engine.trigger.sink.forward.http.HTTPForwardConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.forward.http.HTTPForwardEvent;
import org.apache.iotdb.db.engine.trigger.utils.HTTPConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPForwardHandler
implements Handler<HTTPForwardConfiguration, HTTPForwardEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPForwardHandler.class);
    private static CloseableHttpClient client;
    private static int referenceCount;
    private HttpPost request;
    private HTTPForwardConfiguration config;

    private static synchronized void closeClient() throws IOException {
        if (--referenceCount == 0) {
            client.close();
        }
    }

    private static synchronized void openClient() {
        if (referenceCount++ == 0) {
            PoolingHttpClientConnectionManager connectionManager = HTTPConnectionPool.getInstance();
            client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    @Override
    public void close() throws IOException {
        HTTPForwardHandler.closeClient();
    }

    @Override
    public void open(HTTPForwardConfiguration config) {
        this.config = config;
        if (this.request == null) {
            this.request = new HttpPost(config.getEndpoint());
            this.request.setHeader("Accept", "application/json");
            this.request.setHeader("Content-type", "application/json");
        }
        HTTPForwardHandler.openClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(HTTPForwardEvent event) throws SinkException {
        CloseableHttpResponse response = null;
        try {
            this.request.setEntity((HttpEntity)new StringEntity("[" + event.toJsonString() + "]"));
            response = client.execute((HttpUriRequest)this.request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new SinkException(response.getStatusLine().toString());
            }
        }
        catch (Exception e) {
            if (this.config.isStopIfException()) {
                throw new SinkException("HTTP Forward Exception", e);
            }
            LOGGER.error("HTTP Forward Exception", (Throwable)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Connection Close Exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(List<HTTPForwardEvent> events) throws SinkException {
        CloseableHttpResponse response = null;
        try {
            StringBuilder sb = new StringBuilder().append("[");
            for (HTTPForwardEvent event : events) {
                sb.append(event.toJsonString()).append(", ");
            }
            sb.replace(sb.lastIndexOf(", "), sb.length(), "").append("]");
            this.request.setEntity((HttpEntity)new StringEntity(sb.toString()));
            response = client.execute((HttpUriRequest)this.request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new SinkException(response.getStatusLine().toString());
            }
        }
        catch (Exception e) {
            if (this.config.isStopIfException()) {
                throw new SinkException("HTTP Forward Exception", e);
            }
            LOGGER.error("HTTP Forward Exception", (Throwable)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Connection Close Exception", (Throwable)e);
            }
        }
    }
}

