/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine;

import java.io.File;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.multileader.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.db.consensus.statemachine.BaseStateMachine;
import org.apache.iotdb.db.consensus.statemachine.visitor.DataExecutionVisitor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.snapshot.SnapshotLoader;
import org.apache.iotdb.db.engine.snapshot.SnapshotTaker;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionStateMachine
extends BaseStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(DataRegionStateMachine.class);
    private static final FragmentInstanceManager QUERY_INSTANCE_MANAGER = FragmentInstanceManager.getInstance();
    private DataRegion region;

    public DataRegionStateMachine(DataRegion region) {
        this.region = region;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean takeSnapshot(File snapshotDir) {
        try {
            return new SnapshotTaker(this.region).takeFullSnapshot(snapshotDir.getAbsolutePath(), true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getLogicalStorageGroupName(), this.region.getDataRegionId(), snapshotDir, e});
            return false;
        }
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        DataRegion newRegion = new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getLogicalStorageGroupName(), this.region.getDataRegionId()).loadSnapshotForStateMachine();
        if (newRegion == null) {
            logger.error("Fail to load snapshot from {}", (Object)latestSnapshotRootDir);
            return;
        }
        this.region = newRegion;
        try {
            StorageEngineV2.getInstance().setDataRegion(new DataRegionId(Integer.parseInt(this.region.getDataRegionId())), this.region);
        }
        catch (Exception e) {
            logger.error("Exception occurs when replacing data region in storage engine.", (Throwable)e);
        }
    }

    public TSStatus write(IConsensusRequest request) {
        try {
            PlanNode planNode;
            if (request instanceof IndexedConsensusRequest) {
                IndexedConsensusRequest indexedConsensusRequest = (IndexedConsensusRequest)request;
                planNode = this.getPlanNode(indexedConsensusRequest.getRequest());
                if (planNode instanceof InsertNode) {
                    ((InsertNode)planNode).setSearchIndex(((IndexedConsensusRequest)request).getSearchIndex());
                    ((InsertNode)planNode).setSafelyDeletedSearchIndex(((IndexedConsensusRequest)request).getSafelyDeletedSearchIndex());
                }
            } else {
                planNode = this.getPlanNode(request);
            }
            return this.write(planNode);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    protected TSStatus write(PlanNode planNode) {
        return planNode.accept(new DataExecutionVisitor(), this.region);
    }

    public DataSet read(IConsensusRequest request) {
        FragmentInstance fragmentInstance;
        if (request instanceof GetConsensusReqReaderPlan) {
            return this.region.getWALNode();
        }
        try {
            fragmentInstance = this.getFragmentInstance(request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return null;
        }
        return QUERY_INSTANCE_MANAGER.execDataQueryFragmentInstance(fragmentInstance, this.region);
    }
}

