/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppenderBase;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.SnapshotInfo;

class LogAppenderDefault
extends LogAppenderBase {
    LogAppenderDefault(RaftServer.Division server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    private RaftProtos.AppendEntriesReplyProto sendAppendEntriesWithRetries() throws InterruptedException, InterruptedIOException, RaftLogIOException {
        int retry = 0;
        RaftProtos.AppendEntriesRequestProto request = null;
        while (this.isRunning()) {
            try {
                if (request == null || request.getEntriesCount() == 0) {
                    request = this.newAppendEntriesRequest(CallId.getAndIncrement(), false);
                }
                if (request == null) {
                    LOG.trace("{} no entries to send now, wait ...", (Object)this);
                    return null;
                }
                if (!this.isRunning()) {
                    LOG.info("{} is stopped. Skip appendEntries.", (Object)this);
                    return null;
                }
                this.getFollower().updateLastRpcSendTime(request.getEntriesCount() == 0);
                RaftProtos.AppendEntriesReplyProto r = this.getServerRpc().appendEntries(request);
                this.getFollower().updateLastRpcResponseTime();
                this.getLeaderState().onFollowerCommitIndex(this.getFollower(), r.getFollowerCommit());
                return r;
            }
            catch (InterruptedIOException | RaftLogIOException e) {
                throw e;
            }
            catch (IOException ioe) {
                if (retry++ % 10 == 0) {
                    LOG.warn("{}: Failed to appendEntries (retry={}): {}", new Object[]{this, retry++, ioe});
                }
                this.handleException(ioe);
                if (!this.isRunning()) continue;
                this.getServer().properties().rpcSleepTime().sleep();
            }
        }
        return null;
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshot(SnapshotInfo snapshot) throws InterruptedIOException {
        String requestId = UUID.randomUUID().toString();
        RaftProtos.InstallSnapshotReplyProto reply = null;
        try {
            for (RaftProtos.InstallSnapshotRequestProto request : this.newInstallSnapshotRequests(requestId, snapshot)) {
                this.getFollower().updateLastRpcSendTime(false);
                reply = this.getServerRpc().installSnapshot(request);
                this.getFollower().updateLastRpcResponseTime();
                if (reply.getServerReply().getSuccess()) continue;
                return reply;
            }
        }
        catch (InterruptedIOException iioe) {
            throw iioe;
        }
        catch (Exception ioe) {
            LOG.warn("{}: Failed to installSnapshot {}: {}", new Object[]{this, snapshot, ioe});
            this.handleException(ioe);
            return null;
        }
        if (reply != null) {
            this.getFollower().setSnapshotIndex(snapshot.getTermIndex().getIndex());
            LOG.info("{}: installSnapshot {} successfully", (Object)this, (Object)snapshot);
            this.getServer().getRaftServerMetrics().onSnapshotInstalled();
        }
        return reply;
    }

    public void run() throws InterruptedException, IOException {
        while (this.isRunning()) {
            if (this.shouldSendAppendEntries()) {
                RaftProtos.AppendEntriesReplyProto r;
                SnapshotInfo snapshot = this.shouldInstallSnapshot();
                if (snapshot != null) {
                    LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, send snapshot {} to follower", new Object[]{this, this.getFollower().getNextIndex(), this.getRaftLog().getStartIndex(), snapshot});
                    r = this.installSnapshot(snapshot);
                    if (r != null) {
                        switch (r.getResult()) {
                            case NOT_LEADER: {
                                this.onFollowerTerm(r.getTerm());
                                break;
                            }
                            case SUCCESS: 
                            case SNAPSHOT_UNAVAILABLE: 
                            case ALREADY_INSTALLED: {
                                this.getFollower().setAttemptedToInstallSnapshot();
                                break;
                            }
                        }
                    }
                } else {
                    r = this.sendAppendEntriesWithRetries();
                    if (r != null) {
                        this.handleReply(r);
                    }
                }
            }
            if (this.isRunning() && !this.hasAppendEntries()) {
                this.getEventAwaitForSignal().await(this.getHeartbeatWaitTimeMs(), TimeUnit.MILLISECONDS);
            }
            this.getLeaderState().checkHealth(this.getFollower());
        }
    }

    private void handleReply(RaftProtos.AppendEntriesReplyProto reply) throws IllegalArgumentException {
        if (reply != null) {
            switch (reply.getResult()) {
                case SUCCESS: {
                    long oldNextIndex = this.getFollower().getNextIndex();
                    long nextIndex = reply.getNextIndex();
                    if (nextIndex < oldNextIndex) {
                        throw new IllegalStateException("nextIndex=" + nextIndex + " < oldNextIndex=" + oldNextIndex + ", reply=" + ServerStringUtils.toAppendEntriesReplyString(reply));
                    }
                    if (nextIndex <= oldNextIndex) break;
                    this.getFollower().updateMatchIndex(nextIndex - 1L);
                    this.getFollower().increaseNextIndex(nextIndex);
                    this.getLeaderState().onFollowerSuccessAppendEntries(this.getFollower());
                    break;
                }
                case NOT_LEADER: {
                    this.onFollowerTerm(reply.getTerm());
                    break;
                }
                case INCONSISTENCY: {
                    this.getFollower().decreaseNextIndex(reply.getNextIndex());
                    break;
                }
                case UNRECOGNIZED: {
                    LOG.warn("{}: received {}", (Object)this, (Object)reply.getResult());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to process result " + reply.getResult());
                }
            }
        }
    }

    private void handleException(Exception e) {
        LOG.trace("TRACE", (Throwable)e);
        this.getServerRpc().handleException(this.getFollowerId(), e, false);
    }
}

