/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.jdbc.Field;
import org.apache.iotdb.jdbc.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBDriver;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.ListDataSet;
import org.apache.iotdb.jdbc.WatermarkEncoder;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDatabaseMetadata
implements DatabaseMetaData {
    private IoTDBConnection connection;
    private IClientRPCService.Iface client;
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDatabaseMetadata.class);
    private static final String METHOD_NOT_SUPPORTED_STRING = "Method not supported";
    private static final String DATABASE_VERSION = IoTDBDatabaseMetadata.class.getPackage().getImplementationVersion() != null ? IoTDBDatabaseMetadata.class.getPackage().getImplementationVersion() : "UNKNOWN";
    private long sessionId;
    private WatermarkEncoder groupedLSBWatermarkEncoder;
    private static String sqlKeywordsThatArentSQL92;

    IoTDBDatabaseMetadata(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId) {
        this.connection = connection;
        this.client = client;
        this.sessionId = sessionId;
    }

    private WatermarkEncoder getWatermarkEncoder() {
        try {
            this.groupedLSBWatermarkEncoder = new GroupedLSBWatermarkEncoder(this.client.getProperties().getWatermarkSecretKey(), this.client.getProperties().getWatermarkBitString(), this.client.getProperties().getWatermarkParamMarkRate(), this.client.getProperties().getWatermarkParamMaxRightBit());
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return this.groupedLSBWatermarkEncoder;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int arg0) {
        return true;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "TYPE_CAT", "TEXT"), new Field("", "TYPE_SCHEM", "TEXT"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "ATTR_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "ATTR_TYPE_NAME", "TEXT"), new Field("", "ATTR_SIZE", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "NUM_PREC_RADIX", "INT32"), new Field("", "NULLABLE ", "INT32"), new Field("", "REMARKS", "TEXT"), new Field("", "ATTR_DEF", "TEXT"), new Field("", "SQL_DATA_TYPE", "INT32"), new Field("", "SQL_DATETIME_SUB", "INT32"), new Field("", "CHAR_OCTET_LENGTH", "INT32"), new Field("", "ORDINAL_POSITION", "INT32"), new Field("", "IS_NULLABLE", "TEXT"), new Field("", "SCOPE_CATALOG", "TEXT"), new Field("", "SCOPE_SCHEMA", "TEXT"), new Field("", "SCOPE_TABLE", "TEXT"), new Field("", "SOURCE_DATA_TYPE", "INT32")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "SCOPE", "INT32"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "BUFFER_LENGTH", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "PSEUDO_COLUMN", "INT32")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return "storage group";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW STORAGE GROUP ");
        Field[] fields = new Field[1];
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigpaths = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        while (rs.next()) {
            ArrayList paths = new ArrayList();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", TSDataType.TEXT);
            m.put("val", rs.getString(1));
            paths.add(m);
            bigpaths.add(paths);
        }
        this.addToDataSet(bigpaths, dataSet);
        columnNameList.add("TYPE_CAT");
        columnTypeList.add("TEXT");
        columnNameIndex.put("TYPE_CAT", 0);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    public static TSQueryDataSet convertQueryDataSetByFetchSize(QueryDataSet queryDataSet, int fetchSize, WatermarkEncoder watermarkEncoder) throws IOException {
        int columnNum = queryDataSet.getColumnNum();
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        int columnNumWithTime = columnNum * 2 + 1;
        DataOutputStream[] dataOutputStreams = new DataOutputStream[columnNumWithTime];
        ByteArrayOutputStream[] byteArrayOutputStreams = new ByteArrayOutputStream[columnNumWithTime];
        for (int i = 0; i < columnNumWithTime; ++i) {
            byteArrayOutputStreams[i] = new ByteArrayOutputStream();
            dataOutputStreams[i] = new DataOutputStream(byteArrayOutputStreams[i]);
        }
        int rowCount = 0;
        int[] valueOccupation = new int[columnNum];
        int[] bitmap = new int[columnNum];
        for (int i = 0; i < fetchSize && queryDataSet.hasNext(); ++i) {
            RowRecord rowRecord = queryDataSet.next();
            if (watermarkEncoder != null) {
                rowRecord = watermarkEncoder.encodeRecord(rowRecord);
            }
            dataOutputStreams[0].writeLong(rowRecord.getTimestamp());
            List fields = rowRecord.getFields();
            block10: for (int k = 0; k < fields.size(); ++k) {
                org.apache.iotdb.tsfile.read.common.Field field = (org.apache.iotdb.tsfile.read.common.Field)fields.get(k);
                DataOutputStream dataOutputStream = dataOutputStreams[2 * k + 1];
                if (field == null || field.getDataType() == null) {
                    bitmap[k] = bitmap[k] << 1;
                    continue;
                }
                bitmap[k] = bitmap[k] << 1 | 1;
                TSDataType type = field.getDataType();
                switch (type) {
                    case INT32: {
                        dataOutputStream.writeInt(field.getIntV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 4;
                        continue block10;
                    }
                    case INT64: {
                        dataOutputStream.writeLong(field.getLongV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 8;
                        continue block10;
                    }
                    case FLOAT: {
                        dataOutputStream.writeFloat(field.getFloatV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 4;
                        continue block10;
                    }
                    case DOUBLE: {
                        dataOutputStream.writeDouble(field.getDoubleV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 8;
                        continue block10;
                    }
                    case BOOLEAN: {
                        dataOutputStream.writeBoolean(field.getBoolV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 1;
                        continue block10;
                    }
                    case TEXT: {
                        dataOutputStream.writeInt(field.getBinaryV().getLength());
                        dataOutputStream.write(field.getBinaryV().getValues());
                        valueOccupation[k] = valueOccupation[k] + 4 + field.getBinaryV().getLength();
                        continue block10;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                    }
                }
            }
            if (++rowCount % 8 != 0) continue;
            for (int j = 0; j < bitmap.length; ++j) {
                DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (j + 1)];
                dataBitmapOutputStream.writeByte(bitmap[j]);
                bitmap[j] = 0;
            }
        }
        int remaining = rowCount % 8;
        if (remaining != 0) {
            for (int j = 0; j < bitmap.length; ++j) {
                DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (j + 1)];
                dataBitmapOutputStream.writeByte(bitmap[j] << 8 - remaining);
            }
        }
        int timeOccupation = rowCount * 8;
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeOccupation);
        timeBuffer.put(byteArrayOutputStreams[0].toByteArray());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
        int bitmapOccupation = rowCount / 8 + (rowCount % 8 == 0 ? 0 : 1);
        LinkedList<ByteBuffer> bitmapList = new LinkedList<ByteBuffer>();
        LinkedList<ByteBuffer> valueList = new LinkedList<ByteBuffer>();
        for (int i = 1; i < byteArrayOutputStreams.length; i += 2) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueOccupation[(i - 1) / 2]);
            valueBuffer.put(byteArrayOutputStreams[i].toByteArray());
            valueBuffer.flip();
            valueList.add(valueBuffer);
            ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapOccupation);
            bitmapBuffer.put(byteArrayOutputStreams[i + 1].toByteArray());
            bitmapBuffer.flip();
            bitmapList.add(bitmapBuffer);
        }
        tsQueryDataSet.setBitmapList(bitmapList);
        tsQueryDataSet.setValueList(valueList);
        return tsQueryDataSet;
    }

    private void addToDataSet(List<List<Map>> listbigPaths, ListDataSet dataSet) {
        ArrayList<TSDataType> listType = new ArrayList<TSDataType>();
        int i = 0;
        for (List<Map> listPaths : listbigPaths) {
            RowRecord record = new RowRecord(0L);
            for (Map map : listPaths) {
                TSDataType columnType = (TSDataType)map.get("type");
                Object val = map.get("val");
                org.apache.iotdb.tsfile.read.common.Field field = new org.apache.iotdb.tsfile.read.common.Field(columnType);
                switch (columnType) {
                    case TEXT: {
                        field.setBinaryV(new Binary(val.toString()));
                        break;
                    }
                    case FLOAT: {
                        field.setFloatV(((Float)val).floatValue());
                        break;
                    }
                    case INT32: {
                        field.setIntV(((Integer)val).intValue());
                        break;
                    }
                    case INT64: {
                        field.setLongV(((Long)val).longValue());
                        break;
                    }
                    case DOUBLE: {
                        field.setDoubleV(((Double)val).doubleValue());
                        break;
                    }
                    case BOOLEAN: {
                        field.setBoolV(((Boolean)val).booleanValue());
                    }
                }
                record.addField(field);
                if (i != 0) continue;
                listType.add(columnType);
            }
            ++i;
            dataSet.putRecord(record);
        }
        dataSet.setDataTypes(listType);
        dataSet.setColumnNum(listType.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW STORAGE GROUP ");
        Field[] fields = new Field[]{new Field("", "NAME", "TEXT"), new Field("", "MAX_LEN", "INT32"), new Field("", "DEFAULT_VALUE", "INT32"), new Field("", "DESCRIPTION", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT);
        List<Object> listVal = Arrays.asList("fetch_size", 10, 10, "");
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ArrayList properties = new ArrayList();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", listType.get(i));
            m.put("val", listVal.get(i));
            properties.add(m);
        }
        bigproperties.add(properties);
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "SHOW STORAGE GROUP";
        if (catalog != null && catalog.length() > 0) {
            sql = sql + " " + catalog;
        } else if (schemaPattern != null && schemaPattern.length() > 0) {
            sql = sql + " " + schemaPattern;
        }
        if ((catalog != null && catalog.length() > 0 || schemaPattern != null && schemaPattern.length() > 0) && tableNamePattern != null && tableNamePattern.length() > 0) {
            sql = sql + "." + tableNamePattern;
        }
        if ((catalog != null && catalog.length() > 0 || schemaPattern != null && schemaPattern.length() > 0) && tableNamePattern != null && tableNamePattern.length() > 0 && columnNamePattern != null && columnNamePattern.length() > 0) {
            sql = sql + "." + columnNamePattern;
        }
        ResultSet rs = stmt.executeQuery(sql);
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "GRANTOR", "TEXT"), new Field("", "GRANTEE", "TEXT"), new Field("", "PRIVILEGE", "TEXT"), new Field("", "IS_GRANTABLE", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                if (i < 4) {
                    m.put("val", rs.getString(1));
                } else if (i == 5) {
                    m.put("val", this.getUserName());
                } else if (i == 6) {
                    m.put("val", "");
                } else if (i == 7) {
                    m.put("val", "NO");
                } else {
                    m.put("val", "");
                }
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", "TEXT"), new Field("", "PKTABLE_SCHEM", "TEXT"), new Field("", "PKTABLE_NAME", "TEXT"), new Field("", "PKCOLUMN_NAME", "TEXT"), new Field("", "FKTABLE_CAT", "TEXT"), new Field("", "FKTABLE_SCHEM", "TEXT"), new Field("", "FKTABLE_NAME", "TEXT"), new Field("", "FKCOLUMN_NAME", "TEXT"), new Field("", "KEY_SEQ", "TEXT"), new Field("", "UPDATE_RULE ", "TEXT"), new Field("", "DELETE_RULE", "TEXT"), new Field("", "FK_NAME", "TEXT"), new Field("", "PK_NAME", "TEXT"), new Field("", "DEFERRABILITY", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public int getDatabaseMajorVersion() {
        int major_version = 0;
        try {
            String version = this.client.getProperties().getVersion();
            String[] versions = version.split(".");
            if (versions.length >= 2) {
                major_version = Integer.valueOf(versions[0]);
            }
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return major_version;
    }

    @Override
    public int getDatabaseMinorVersion() {
        int minor_version = 0;
        try {
            String version = this.client.getProperties().getVersion();
            String[] versions = version.split(".");
            if (versions.length >= 2) {
                minor_version = Integer.valueOf(versions[1]);
            }
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return minor_version;
    }

    @Override
    public String getDatabaseProductName() {
        return "IoTDB";
    }

    @Override
    public String getDatabaseProductVersion() {
        return DATABASE_VERSION;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 4;
    }

    @Override
    public int getDriverMinorVersion() {
        return 3;
    }

    @Override
    public String getDriverName() {
        return IoTDBDriver.class.getName();
    }

    @Override
    public String getDriverVersion() {
        return DATABASE_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", "TEXT"), new Field("", "PKTABLE_SCHEM", "INT32"), new Field("", "PKTABLE_NAME", "TEXT"), new Field("", "PKCOLUMN_NAME", "TEXT"), new Field("", "FKTABLE_CAT", "TEXT"), new Field("", "FKTABLE_SCHEM", "TEXT"), new Field("", "FKTABLE_NAME", "TEXT"), new Field("", "FKCOLUMN_NAME", "TEXT"), new Field("", "KEY_SEQ", "INT32"), new Field("", "UPDATE_RULE", "INT32"), new Field("", "DELETE_RULE", "INT32"), new Field("", "FK_NAME", "TEXT"), new Field("", "PK_NAME", "TEXT"), new Field("", "DEFERRABILITY", "INT32")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("show functions");
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT ", "TEXT"), new Field("", "FUNCTION_SCHEM", "TEXT"), new Field("", "FUNCTION_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "COLUMN_TYPE", "INT32"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "PRECISION", "INT32"), new Field("", "LENGTH", "INT32"), new Field("", "SCALE", "INT32"), new Field("", "RADIX", "INT32"), new Field("", "NULLABLE", "INT32"), new Field("", "REMARKS", "TEXT"), new Field("", "CHAR_OCTET_LENGTH", "INT32"), new Field("", "ORDINAL_POSITION", "INT32"), new Field("", "IS_NULLABLE", "TEXT"), new Field("", "SPECIFIC_NAME", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                if (i == 2) {
                    m.put("val", rs.getString(1));
                } else if ("INT32".equals(fields[i].getSqlType())) {
                    m.put("val", 0);
                } else {
                    m.put("val", "");
                }
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("show functions");
        Field[] fields = new Field[]{new Field("", "FUNCTION_CAT ", "TEXT"), new Field("", "FUNCTION_SCHEM", "TEXT"), new Field("", "FUNCTION_NAME", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "FUNCTION_TYPE", "INT32"), new Field("", "SPECIFIC_NAME", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                if (i == 2) {
                    m.put("val", rs.getString(1));
                } else if (i == 4) {
                    m.put("val", 0);
                } else {
                    m.put("val", "");
                }
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    @Override
    public String getIdentifierQuoteString() {
        return "' or \"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", "TEXT"), new Field("", "PKTABLE_SCHEM", "INT32"), new Field("", "PKTABLE_NAME", "TEXT"), new Field("", "PKCOLUMN_NAME", "TEXT"), new Field("", "FKTABLE_CAT", "TEXT"), new Field("", "FKTABLE_SCHEM", "TEXT"), new Field("", "FKTABLE_NAME", "TEXT"), new Field("", "FKCOLUMN_NAME", "TEXT"), new Field("", "KEY_SEQ", "INT32"), new Field("", "UPDATE_RULE", "INT32"), new Field("", "DELETE_RULE", "INT32"), new Field("", "FK_NAME", "TEXT"), new Field("", "PK_NAME", "TEXT"), new Field("", "DEFERRABILITY", "INT32")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "NON_UNIQUE", "TEXT"), new Field("", "INDEX_QUALIFIER", "TEXT"), new Field("", "INDEX_NAME", "TEXT"), new Field("", "TYPE", "TEXT"), new Field("", "ORDINAL_POSITION", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "ASC_OR_DESC", "TEXT"), new Field("", "CARDINALITY", "TEXT"), new Field("", "PAGES", "TEXT"), new Field("", "PK_NAME", "TEXT"), new Field("", "FILTER_CONDITION", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 3;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 1024;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 1024;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 1;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 1;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() {
        int maxcount = 0;
        try {
            maxcount = this.client.getProperties().getMaxConcurrentClientNum();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return maxcount;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0x7FFFFFF7;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 1024;
    }

    @Override
    public int getMaxStatementLength() {
        try {
            return this.client.getProperties().getThriftMaxFrameSize();
        }
        catch (TException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 1024;
    }

    @Override
    public int getMaxUserNameLength() {
        return 1024;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNumericFunctions() {
        ResultSet resultSet = null;
        Statement statement = null;
        String result = "";
        try {
            statement = this.connection.createStatement();
            StringBuilder str = new StringBuilder("");
            resultSet = statement.executeQuery("show functions");
            List<String> listfunction = Arrays.asList("MAX_TIME", "MIN_TIME", "TIME_DIFFERENCE", "NOW");
            while (resultSet.next()) {
                if (listfunction.contains(resultSet.getString(1))) continue;
                str.append(resultSet.getString(1)).append(",");
            }
            result = str.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
            this.close(resultSet, statement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(resultSet, statement);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Statement stmt = this.connection.createStatement();
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT);
        List<Object> listValSub_1 = Arrays.asList(catalog, "", table, "time", 1, "PRIMARY");
        List<Object> listValSub_2 = Arrays.asList(catalog, "", table, "deivce", 2, "PRIMARY");
        List<List> listVal = Arrays.asList(listValSub_1, listValSub_2);
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "KEY_SEQ", "INT32"), new Field("", "PK_NAME", "TEXT")};
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        for (List listob : listVal) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                m.put("val", listob.get(i));
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", "TEXT"), new Field("", "PROCEDURE_SCHEM", "TEXT"), new Field("", "PROCEDURE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "COLUMN_TYPE", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "PRECISION", "TEXT"), new Field("", "LENGTH", "TEXT"), new Field("", "SCALE", "TEXT"), new Field("", "RADIX", "TEXT"), new Field("", "NULLABLE", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "COLUMN_DEF", "TEXT"), new Field("", "SQL_DATA_TYPE", "INT32"), new Field("", "SQL_DATETIME_SUB", "TEXT"), new Field("", "CHAR_OCTET_LENGTH", "TEXT"), new Field("", "ORDINAL_POSITION", "TEXT"), new Field("", "IS_NULLABLE", "TEXT"), new Field("", "SPECIFIC_NAME", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", "TEXT"), new Field("", "PROCEDURE_SCHEM", "TEXT"), new Field("", "PROCEDURE_NAME", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "PROCEDURE_TYPE", "TEXT"), new Field("", "SPECIFIC_NAME", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "NUM_PREC_RADIX", "INT32"), new Field("", "COLUMN_USAGE", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "CHAR_OCTET_LENGTH", "INT32"), new Field("", "IS_NULLABLE", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT);
        List<Object> listVal = Arrays.asList(catalog, catalog, tableNamePattern, "times", -5, 1, 0, 2, "", "", 13, "NO");
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ArrayList properties = new ArrayList();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", listType.get(i));
            m.put("val", listVal.get(i));
            properties.add(m);
        }
        bigproperties.add(properties);
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() {
        return sqlKeywordsThatArentSQL92;
    }

    @Override
    public int getSQLStateType() {
        return 0;
    }

    @Override
    public String getSchemaTerm() {
        return "stroge group";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW STORAGE GROUP ");
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_CATALOG", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                m.put("val", rs.getString(1));
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getSchemas();
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getStringFunctions() {
        return this.getSystemFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "SUPERTABLE_NAME", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "SUPERTYPE_CAT", "TEXT"), new Field("", "SUPERTYPE_SCHEM", "TEXT"), new Field("", "SUPERTYPE_NAME", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSystemFunctions() {
        String result = "";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            StringBuilder str = new StringBuilder("");
            resultSet = statement.executeQuery("show functions");
            while (resultSet.next()) {
                str.append(resultSet.getString(1)).append(",");
            }
            result = str.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
            this.close(resultSet, statement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.close(resultSet, statement);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "SHOW STORAGE GROUP";
        if (catalog != null && catalog.length() > 0) {
            sql = sql + " " + catalog;
        } else if (schemaPattern != null && schemaPattern.length() > 0) {
            sql = sql + " " + schemaPattern;
        }
        if ((catalog != null && catalog.length() > 0 || schemaPattern != null && schemaPattern.length() > 0) && tableNamePattern != null && tableNamePattern.length() > 0) {
            sql = sql + "." + tableNamePattern;
        }
        ResultSet rs = stmt.executeQuery(sql);
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "GRANTOR", "TEXT"), new Field("", "GRANTEE", "TEXT"), new Field("", "PRIVILEGE", "TEXT"), new Field("", "IS_GRANTABLE", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                if (i < 4) {
                    m.put("val", rs.getString(1));
                } else if (i == 5) {
                    m.put("val", this.getUserName());
                } else if (i == 6) {
                    m.put("val", "");
                } else if (i == 7) {
                    m.put("val", "NO");
                } else {
                    m.put("val", "");
                }
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        Statement stmt = this.connection.createStatement();
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigpaths = new ArrayList<List<Map>>();
        ArrayList paths = new ArrayList();
        ListDataSet dataSet = new ListDataSet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("type", TSDataType.TEXT);
        m.put("val", "table");
        paths.add(m);
        bigpaths.add(paths);
        this.addToDataSet(bigpaths, dataSet);
        columnNameList.add("TABLE_TYPE");
        columnTypeList.add("TEXT");
        columnNameIndex.put("TABLE_TYPE", 0);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "SHOW STORAGE GROUP";
        if (catalog != null && catalog.length() > 0) {
            sql = sql + " " + catalog;
        } else if (schemaPattern != null && schemaPattern.length() > 0) {
            sql = sql + " " + schemaPattern;
        }
        if ((catalog != null && catalog.length() > 0 || schemaPattern != null && schemaPattern.length() > 0) && tableNamePattern != null && tableNamePattern.length() > 0) {
            sql = sql + "." + tableNamePattern;
        }
        if ((catalog != null && catalog.length() > 0 || schemaPattern != null && schemaPattern.length() > 0) && tableNamePattern != null && tableNamePattern.length() > 0 && columnNamePattern != null && columnNamePattern.length() > 0) {
            sql = sql + "." + columnNamePattern;
        }
        ResultSet rs = stmt.executeQuery(sql);
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "BUFFER_LENGTH", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "NUM_PREC_RADIX", "INT32"), new Field("", "NULLABLE", "INT32"), new Field("", "REMARKS", "TEXT"), new Field("", "COLUMN_DEF", "TEXT"), new Field("", "SQL_DATA_TYPE", "INT32"), new Field("", "SQL_DATETIME_SUB", "INT32"), new Field("", "CHAR_OCTET_LENGTH", "INT32"), new Field("", "ORDINAL_POSITION", "INT32"), new Field("", "IS_NULLABLE", "TEXT"), new Field("", "SCOPE_CATALOG", "TEXT"), new Field("", "SCOPE_SCHEMA", "TEXT"), new Field("", "SCOPE_TABLE", "TEXT"), new Field("", "SOURCE_DATA_TYPE", "INT32"), new Field("", "IS_AUTOINCREMENT", "TEXT"), new Field("", "IS_GENERATEDCOLUMN", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                if (i < 4) {
                    m.put("val", rs.getString(1));
                } else if (i == 4) {
                    m.put("val", this.getSQLType(fields[i].getSqlType()));
                } else if (i == 6) {
                    m.put("val", this.getTypePrecision(fields[i].getSqlType()));
                } else if (i == 7) {
                    m.put("val", 0);
                } else if (i == 8) {
                    m.put("val", this.getTypeScale(fields[i].getSqlType()));
                } else if (i == 9) {
                    m.put("val", 10);
                } else if (i == 10) {
                    m.put("val", 0);
                } else if (i == 11) {
                    m.put("val", "");
                } else if (i == 12) {
                    m.put("val", "");
                } else if (i == 13) {
                    m.put("val", 0);
                } else if (i == 14) {
                    m.put("val", 0);
                } else if (i == 15) {
                    m.put("val", this.getTypePrecision(fields[i].getSqlType()));
                } else if (i == 16) {
                    m.put("val", 1);
                } else if (i == 17) {
                    m.put("val", "NO");
                } else if (i == 18) {
                    m.put("val", "");
                } else if (i == 19) {
                    m.put("val", "");
                } else if (i == 20) {
                    m.put("val", "");
                } else if (i == 21) {
                    m.put("val", 0);
                } else if (i == 22) {
                    m.put("val", "NO");
                } else if (i == 23) {
                    m.put("val", "NO");
                } else {
                    m.put("val", "");
                }
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    private void close(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex) {
            rs = null;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception ex) {
            stmt = null;
        }
    }

    public int getTypeScale(String columnType) {
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": 
            case "INT32": 
            case "INT64": 
            case "TEXT": {
                return 0;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 15;
            }
        }
        return 0;
    }

    private int getSQLType(String columnType) {
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": {
                return 16;
            }
            case "INT32": {
                return 4;
            }
            case "INT64": {
                return -5;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 8;
            }
            case "TEXT": {
                return -1;
            }
        }
        return 0;
    }

    private int getTypePrecision(String columnType) {
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": {
                return 1;
            }
            case "INT32": {
                return 10;
            }
            case "INT64": {
                return 19;
            }
            case "FLOAT": {
                return 38;
            }
            case "DOUBLE": {
                return 308;
            }
            case "TEXT": {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Statement stmt = this.connection.createStatement();
        String sql = "SHOW timeseries";
        if (catalog != null && catalog.length() > 0) {
            sql = sql + " " + catalog;
        } else if (schemaPattern != null && schemaPattern.length() > 0) {
            sql = sql + " " + schemaPattern;
        }
        if ((catalog != null && catalog.length() > 0 || schemaPattern != null && schemaPattern.length() > 0) && tableNamePattern != null && tableNamePattern.length() > 0) {
            sql = sql + "." + tableNamePattern;
        }
        ResultSet rs = stmt.executeQuery(sql);
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "TABLE_TYPE", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "TYPE_CAT", "TEXT"), new Field("", "TYPE_SCHEM", "TEXT"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "SELF_REFERENCING_COL_NAME", "TEXT"), new Field("", "REF_GENERATION", "TEXT")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        while (rs.next()) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                if (i < 2) {
                    m.put("val", rs.getString(3));
                } else if (i == 2) {
                    m.put("val", rs.getString(1));
                } else if (i == 3) {
                    m.put("val", "TABLE");
                } else {
                    m.put("val", "");
                }
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    @Override
    public String getTimeDateFunctions() {
        return "MAX_TIME,MIN_TIME,TIME_DIFFERENCE,NOW";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Statement stmt = this.connection.createStatement();
        Field[] fields = new Field[]{new Field("", "TYPE_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "PRECISION", "INT32"), new Field("", "LITERAL_PREFIX", "TEXT"), new Field("", "LITERAL_SUFFIX", "TEXT"), new Field("", "CREATE_PARAMS", "TEXT"), new Field("", "NULLABLE", "INT32"), new Field("", "CASE_SENSITIVE", "BOOLEAN"), new Field("", "SEARCHABLE", "TEXT"), new Field("", "UNSIGNED_ATTRIBUTE", "BOOLEAN"), new Field("", "FIXED_PREC_SCALE", "BOOLEAN"), new Field("", "AUTO_INCREMENT", "BOOLEAN"), new Field("", "LOCAL_TYPE_NAME", "TEXT"), new Field("", "MINIMUM_SCALE", "INT32"), new Field("", "MAXIMUM_SCALE", "INT32"), new Field("", "SQL_DATA_TYPE", "INT32"), new Field("", "SQL_DATETIME_SUB", "INT32"), new Field("", "NUM_PREC_RADIX", "INT32")};
        List<TSDataType> listType = Arrays.asList(TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT, TSDataType.BOOLEAN, TSDataType.BOOLEAN, TSDataType.BOOLEAN, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32);
        List<Object> listValSub_1 = Arrays.asList("INT32", 4, 10, "", "", "", 1, true, "", false, true, false, "", 0, 10, 0, 0, 10);
        List<Object> listValSub_2 = Arrays.asList("INT64", -5, 19, "", "", "", 1, true, "", false, true, false, "", 0, 10, 0, 0, 10);
        List<Object> listValSub_3 = Arrays.asList("BOOLEAN", 16, 1, "", "", "", 1, true, "", false, true, false, "", 0, 10, 0, 0, 10);
        List<Object> listValSub_4 = Arrays.asList("FLOAT", 6, 38, "", "", "", 1, true, "", false, true, false, "", 0, 10, 0, 0, 10);
        List<Object> listValSub_5 = Arrays.asList("DOUBLE", 8, 308, "", "", "", 1, true, "", false, true, false, "", 0, 10, 0, 0, 10);
        List<Object> listValSub_6 = Arrays.asList("TEXT", -1, 64, "", "", "", 1, true, "", false, true, false, "", 0, 10, 0, 0, 10);
        List<List> listVal = Arrays.asList(listValSub_1, listValSub_2, listValSub_3, listValSub_4, listValSub_5, listValSub_6);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Map>> bigproperties = new ArrayList<List<Map>>();
        ListDataSet dataSet = new ListDataSet();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
            HashMap hashMap = new HashMap();
        }
        for (List listob : listVal) {
            ArrayList properties = new ArrayList();
            for (int i = 0; i < fields.length; ++i) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("type", listType.get(i));
                m.put("val", listob.get(i));
                properties.add(m);
            }
            bigproperties.add(properties);
        }
        this.addToDataSet(bigproperties, dataSet);
        TSQueryDataSet tsdataset = null;
        try {
            tsdataset = IoTDBDatabaseMetadata.convertQueryDataSetByFetchSize(dataSet, stmt.getFetchSize(), this.getWatermarkEncoder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, 0L, this.sessionId, tsdataset, null, 60000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "CLASS_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "REMARKS", "TEXT"), new Field("", "BASE_TYPE", "TEXT")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public String getURL() {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        Statement stmt = this.connection.createStatement();
        try {
            Field[] fields = new Field[]{new Field("", "SCOPE", "INT32"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "BUFFER_LENGTH", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "PSEUDO_COLUMN", "INT32")};
            for (int i = 0; i < fields.length; ++i) {
                columnNameList.add(fields[i].getName());
                columnTypeList.add(fields[i].getSqlType());
                columnNameIndex.put(fields[i].getName(), i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, false, this.client, null, 0L, this.sessionId, null, null, 60000L, true);
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.client.getProperties().isReadOnly;
        }
        catch (TException e) {
            e.printStackTrace();
            throw new SQLException("Can not get the read-only mode");
        }
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return 1 == holdability;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return 1000 == type || 1003 == type;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return false;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Deprecated
    public String toString() {
        block7: {
            try {
                return this.getMetadataInJsonFunc();
            }
            catch (IoTDBSQLException e) {
                logger.error("Failed to fetch metadata in json because: ", (Throwable)e);
            }
            catch (TException e) {
                boolean flag = this.connection.reconnect();
                this.client = this.connection.getClient();
                if (flag) {
                    try {
                        return this.getMetadataInJsonFunc();
                    }
                    catch (TException e2) {
                        logger.error("Fail to get all timeseries info after reconnecting. please check server status", (Throwable)e2);
                        break block7;
                    }
                    catch (IoTDBSQLException ioTDBSQLException) {
                        break block7;
                    }
                }
                logger.error("Fail to reconnect to server when getting all timeseries info. please check server status");
            }
        }
        return "";
    }

    public String getMetadataInJson() throws SQLException {
        try {
            return this.getMetadataInJsonFunc();
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.client = this.connection.getClient();
            if (flag) {
                try {
                    return this.getMetadataInJsonFunc();
                }
                catch (TException e2) {
                    throw new SQLException("Failed to fetch all metadata in json after reconnecting. Please check the server status.");
                }
            }
            throw new SQLException("Failed to reconnect to the server when fetching all metadata in json. Please check the server status.");
        }
    }

    private String getMetadataInJsonFunc() throws TException, IoTDBSQLException {
        TSFetchMetadataReq req = new TSFetchMetadataReq(this.sessionId, "METADATA_IN_JSON");
        TSFetchMetadataResp resp = this.client.fetchMetadata(req);
        try {
            RpcUtils.verifySuccess((TSStatus)resp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), resp.getStatus());
        }
        return resp.getMetadataInJson();
    }

    static {
        String[] allIotdbSQLKeywords = new String[]{"ALTER", "ADD", "ALIAS", "ALL", "AVG", "ALIGN", "ATTRIBUTES", "AS", "ASC", "BY", "BOOLEAN", "BITMAP", "CREATE", "CONFIGURATION", "COMPRESSOR", "CHILD", "COUNT", "COMPRESSION", "CLEAR", "CACHE", "CONTAIN", "CONCAT", "DELETE", "DEVICE", "DESCRIBE", "DATATYPE", "DOUBLE", "DIFF", "DROP", "DEVICES", "DISABLE", "DESC", "ENCODING", "FROM", "FILL", "FLOAT", "FLUSH", "FIRST_VALUE", "FULL", "FALSE", "FOR", "FUNCTION", "FUNCTIONS", "GRANT", "GROUP", "GORILLA", "GLOBAL", "GZIP", "INSERT", "INTO", "INT32", "INT64", "INDEX", "INFO", "KILL", "LIMIT", "LINEAR", "LABEL", "LINK", "LIST", "LOAD", "LEVEL", "LAST_VALUE", "LAST", "LZO", "LZ4", "LATEST", "LIKE", "METADATA", "MERGE", "MOVE", "MIN_TIME", "MAX_TIME", "MIN_VALUE", "MAX_VALUE", "NOW", "NODES", "ORDER", "OFFSET", "ON", "OFF", "OF", "PROCESSLIST", "PREVIOUS", "PREVIOUSUNTILLAST", "PROPERTY", "PLAIN", "PLAIN_DICTIONARY", "PRIVILEGES", "PASSWORD", "PATHS", "PAA", "PLA", "PARTITION", "QUERY", "ROOT", "RLE", "REGULAR", "ROLE", "REVOKE", "REMOVE", "RENAME", "SELECT", "SHOW", "SET", "SLIMIT", "SOFFSET", "STORAGE", "SUM", "SNAPPY", "SNAPSHOT", "SCHEMA", "TO", "TIMESERIES", "TIMESTAMP", "TEXT", "TS_2DIFF", "TRACING", "TTL", "TASK", "TIME", "TAGS", "TRUE", "TEMPORARY", "TOP", "TOLERANCE", "UPDATE", "UNLINK", "UPSERT", "USING", "USER", "UNSET", "UNCOMPRESSED", "VALUES", "VERSION", "WHERE", "WITH", "WATERMARK_EMBEDDING"};
        String[] sql92Keywords = new String[]{"ABSOLUTE", "EXEC", "OVERLAPS", "ACTION", "EXECUTE", "PAD", "ADA", "EXISTS", "PARTIAL", "ADD", "EXTERNAL", "PASCAL", "ALL", "EXTRACT", "POSITION", "ALLOCATE", "FALSE", "PRECISION", "ALTER", "FETCH", "PREPARE", "AND", "FIRST", "PRESERVE", "ANY", "FLOAT", "PRIMARY", "ARE", "FOR", "PRIOR", "AS", "FOREIGN", "PRIVILEGES", "ASC", "FORTRAN", "PROCEDURE", "ASSERTION", "FOUND", "PUBLIC", "AT", "FROM", "READ", "AUTHORIZATION", "FULL", "REAL", "AVG", "GET", "REFERENCES", "BEGIN", "GLOBAL", "RELATIVE", "BETWEEN", "GO", "RESTRICT", "BIT", "GOTO", "REVOKE", "BIT_LENGTH", "GRANT", "RIGHT", "BOTH", "GROUP", "ROLLBACK", "BY", "HAVING", "ROWS", "CASCADE", "HOUR", "SCHEMA", "CASCADED", "IDENTITY", "SCROLL", "CASE", "IMMEDIATE", "SECOND", "CAST", "IN", "SECTION", "CATALOG", "INCLUDE", "SELECT", "CHAR", "INDEX", "SESSION", "CHAR_LENGTH", "INDICATOR", "SESSION_USER", "CHARACTER", "INITIALLY", "SET", "CHARACTER_LENGTH", "INNER", "SIZE", "CHECK", "INPUT", "SMALLINT", "CLOSE", "INSENSITIVE", "SOME", "COALESCE", "INSERT", "SPACE", "COLLATE", "INT", "SQL", "COLLATION", "INTEGER", "SQLCA", "COLUMN", "INTERSECT", "SQLCODE", "COMMIT", "INTERVAL", "SQLERROR", "CONNECT", "INTO", "SQLSTATE", "CONNECTION", "IS", "SQLWARNING", "CONSTRAINT", "ISOLATION", "SUBSTRING", "CONSTRAINTS", "JOIN", "SUM", "CONTINUE", "KEY", "SYSTEM_USER", "CONVERT", "LANGUAGE", "TABLE", "CORRESPONDING", "LAST", "TEMPORARY", "COUNT", "LEADING", "THEN", "CREATE", "LEFT", "TIME", "CROSS", "LEVEL", "TIMESTAMP", "CURRENT", "LIKE", "TIMEZONE_HOUR", "CURRENT_DATE", "LOCAL", "TIMEZONE_MINUTE", "CURRENT_TIME", "LOWER", "TO", "CURRENT_TIMESTAMP", "MATCH", "TRAILING", "CURRENT_USER", "MAX", "TRANSACTION", "CURSOR", "MIN", "TRANSLATE", "DATE", "MINUTE", "TRANSLATION", "DAY", "MODULE", "TRIM", "DEALLOCATE", "MONTH", "TRUE", "DEC", "NAMES", "UNION", "DECIMAL", "NATIONAL", "UNIQUE", "DECLARE", "NATURAL", "UNKNOWN", "DEFAULT", "NCHAR", "UPDATE", "DEFERRABLE", "NEXT", "UPPER", "DEFERRED", "NO", "USAGE", "DELETE", "NONE", "USER", "DESC", "NOT", "USING", "DESCRIBE", "NULL", "VALUE", "DESCRIPTOR", "NULLIF", "VALUES", "DIAGNOSTICS", "NUMERIC", "VARCHAR", "DISCONNECT", "OCTET_LENGTH", "VARYING", "DISTINCT", "OF", "VIEW", "DOMAIN", "ON", "WHEN", "DOUBLE", "ONLY", "WHENEVER", "DROP", "OPEN", "WHERE", "ELSE", "OPTION", "WITH", "END", "OR", "WORK", "END-EXEC", "ORDER", "WRITE", "ESCAPE", "OUTER", "YEAR", "EXCEPT", "OUTPUT", "ZONE", "EXCEPTION"};
        TreeMap myKeywordMap = new TreeMap();
        for (int i = 0; i < allIotdbSQLKeywords.length; ++i) {
            myKeywordMap.put(allIotdbSQLKeywords[i], null);
        }
        HashMap sql92KeywordMap = new HashMap(sql92Keywords.length);
        for (int j = 0; j < sql92Keywords.length; ++j) {
            sql92KeywordMap.put(sql92Keywords[j], null);
        }
        Iterator it = sql92KeywordMap.keySet().iterator();
        while (it.hasNext()) {
            myKeywordMap.remove(it.next());
        }
        StringBuffer keywordBuf = new StringBuffer();
        it = myKeywordMap.keySet().iterator();
        if (it.hasNext()) {
            keywordBuf.append(it.next().toString());
        }
        while (it.hasNext()) {
            keywordBuf.append(",");
            keywordBuf.append(it.next().toString());
        }
        sqlKeywordsThatArentSQL92 = keywordBuf.toString();
    }
}

