/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorReq;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeInfoReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListReq;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.AdjustMaxRegionGroupCountReq;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateFunctionReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionsReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteProcedureReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteRegionsReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.DropFunctionReq;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.consensus.request.write.UpdateProcedureReq;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigRequest
implements IConsensusRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRequest.class);
    private final ConfigRequestType type;

    public ConfigRequest(ConfigRequestType type) {
        this.type = type;
    }

    public ConfigRequestType getType() {
        return this.type;
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer serializeToByteBuffer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void serializeImpl(DataOutputStream var1) throws IOException;

    protected abstract void deserializeImpl(ByteBuffer var1) throws IOException;

    public static class Factory {
        public static ConfigRequest create(ByteBuffer buffer) throws IOException {
            ConfigRequest req;
            int typeNum = buffer.getInt();
            if (typeNum >= ConfigRequestType.values().length) {
                throw new IOException("unrecognized log type " + typeNum);
            }
            ConfigRequestType type = ConfigRequestType.values()[typeNum];
            switch (type) {
                case RegisterDataNode: {
                    req = new RegisterDataNodeReq();
                    break;
                }
                case GetDataNodeInfo: {
                    req = new GetDataNodeInfoReq();
                    break;
                }
                case SetStorageGroup: {
                    req = new SetStorageGroupReq();
                    break;
                }
                case SetTTL: {
                    req = new SetTTLReq();
                    break;
                }
                case SetSchemaReplicationFactor: {
                    req = new SetSchemaReplicationFactorReq();
                    break;
                }
                case SetDataReplicationFactor: {
                    req = new SetDataReplicationFactorReq();
                    break;
                }
                case SetTimePartitionInterval: {
                    req = new SetTimePartitionIntervalReq();
                    break;
                }
                case AdjustMaxRegionGroupCount: {
                    req = new AdjustMaxRegionGroupCountReq();
                    break;
                }
                case CountStorageGroup: {
                    req = new CountStorageGroupReq();
                    break;
                }
                case GetStorageGroup: {
                    req = new GetStorageGroupReq();
                    break;
                }
                case CreateRegionGroups: {
                    req = new CreateRegionsReq();
                    break;
                }
                case DeleteRegions: {
                    req = new DeleteRegionsReq();
                    break;
                }
                case GetSchemaPartition: {
                    req = new GetSchemaPartitionReq();
                    break;
                }
                case CreateSchemaPartition: {
                    req = new CreateSchemaPartitionReq();
                    break;
                }
                case GetOrCreateSchemaPartition: {
                    req = new GetOrCreateSchemaPartitionReq();
                    break;
                }
                case GetDataPartition: {
                    req = new GetDataPartitionReq();
                    break;
                }
                case CreateDataPartition: {
                    req = new CreateDataPartitionReq();
                    break;
                }
                case GetOrCreateDataPartition: {
                    req = new GetOrCreateDataPartitionReq();
                    break;
                }
                case DeleteProcedure: {
                    req = new DeleteProcedureReq();
                    break;
                }
                case UpdateProcedure: {
                    req = new UpdateProcedureReq();
                    break;
                }
                case PreDeleteStorageGroup: {
                    req = new PreDeleteStorageGroupReq();
                    break;
                }
                case DeleteStorageGroup: {
                    req = new DeleteStorageGroupReq();
                    break;
                }
                case ListUser: 
                case ListRole: 
                case ListUserPrivilege: 
                case ListRolePrivilege: 
                case ListUserRoles: 
                case ListRoleUsers: 
                case CreateUser: 
                case CreateRole: 
                case DropUser: 
                case DropRole: 
                case GrantRole: 
                case GrantUser: 
                case GrantRoleToUser: 
                case RevokeUser: 
                case RevokeRole: 
                case RevokeRoleFromUser: 
                case UpdateUser: {
                    req = new AuthorReq(type);
                    break;
                }
                case ApplyConfigNode: {
                    req = new ApplyConfigNodeReq();
                    break;
                }
                case RemoveConfigNode: {
                    req = new RemoveConfigNodeReq();
                    break;
                }
                case CreateFunction: {
                    req = new CreateFunctionReq();
                    break;
                }
                case DropFunction: {
                    req = new DropFunctionReq();
                    break;
                }
                case GetNodePathsPartition: {
                    req = new GetNodePathsPartitionReq();
                    break;
                }
                case GetRegionInfoList: {
                    req = new GetRegionInfoListReq();
                    break;
                }
                default: {
                    throw new IOException("unknown PhysicalPlan type: " + typeNum);
                }
            }
            req.deserializeImpl(buffer);
            return req;
        }

        private Factory() {
        }
    }
}

