/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.handlers;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;

public class FlushHandler
implements AsyncMethodCallback<TSStatus> {
    private final TDataNodeLocation dataNodeLocation;
    private final CountDownLatch countDownLatch;
    private final List<TSStatus> dataNodeResponseStatus;

    public FlushHandler(TDataNodeLocation dataNodeLocation, CountDownLatch countDownLatch, List<TSStatus> dataNodeResponseStatus) {
        this.dataNodeLocation = dataNodeLocation;
        this.countDownLatch = countDownLatch;
        this.dataNodeResponseStatus = dataNodeResponseStatus;
    }

    public void onComplete(TSStatus response) {
        this.countDownLatch.countDown();
        this.dataNodeResponseStatus.add(response);
    }

    public void onError(Exception exception) {
        this.countDownLatch.countDown();
        this.dataNodeResponseStatus.add(new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)("Flush error on DataNode: {id=" + this.dataNodeLocation.getDataNodeId() + ", internalEndPoint=" + this.dataNodeLocation.getInternalEndPoint() + "}" + exception.getMessage()))));
    }
}

