/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.confignode.client.ConfigNodeClientPoolFactory;
import org.apache.iotdb.confignode.client.handlers.CreateRegionHandler;
import org.apache.iotdb.confignode.client.handlers.DataNodeHeartbeatHandler;
import org.apache.iotdb.confignode.client.handlers.FlushHandler;
import org.apache.iotdb.confignode.client.handlers.FunctionManagementHandler;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionsReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionRequest;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionRequest;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatReq;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncDataNodeClientPool.class);
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ConfigNodeClientPoolFactory.AsyncDataNodeInternalServiceClientPoolFactory());

    private AsyncDataNodeClientPool() {
    }

    public void createRegions(CreateRegionsReq createRegionGroupsReq, Map<String, Long> ttlMap) {
        int index = 0;
        int regionNum = 0;
        TreeMap<TConsensusGroupId, Map> indexMap = new TreeMap<TConsensusGroupId, Map>();
        for (Map.Entry<String, List<TRegionReplicaSet>> entry : createRegionGroupsReq.getRegionGroupMap().entrySet()) {
            for (TRegionReplicaSet regionReplicaSet : entry.getValue()) {
                regionNum += regionReplicaSet.getDataNodeLocationsSize();
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    indexMap.computeIfAbsent(regionReplicaSet.getRegionId(), idMap -> new TreeMap()).put(dataNodeLocation.getDataNodeId(), index);
                    ++index;
                }
            }
        }
        BitSet bitSet = new BitSet(regionNum);
        for (int retry = 0; retry < 3; ++retry) {
            CountDownLatch latch = new CountDownLatch(regionNum - bitSet.cardinality());
            createRegionGroupsReq.getRegionGroupMap().forEach((storageGroup, regionReplicaSets) -> regionReplicaSets.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> {
                if (!bitSet.get((Integer)((Map)indexMap.get(regionReplicaSet.getRegionId())).get(dataNodeLocation.getDataNodeId()))) {
                    TEndPoint endPoint = dataNodeLocation.getInternalEndPoint();
                    CreateRegionHandler handler = new CreateRegionHandler((Integer)((Map)indexMap.get(regionReplicaSet.getRegionId())).get(dataNodeLocation.getDataNodeId()), bitSet, latch, regionReplicaSet.getRegionId(), (TDataNodeLocation)dataNodeLocation);
                    switch (regionReplicaSet.getRegionId().getType()) {
                        case SchemaRegion: {
                            this.createSchemaRegion(endPoint, this.genCreateSchemaRegionReq((String)storageGroup, (TRegionReplicaSet)regionReplicaSet), handler);
                            break;
                        }
                        case DataRegion: {
                            this.createDataRegion(endPoint, this.genCreateDataRegionReq((String)storageGroup, (TRegionReplicaSet)regionReplicaSet, (Long)ttlMap.get(storageGroup)), handler);
                        }
                    }
                }
            })));
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("ClusterSchemaManager was interrupted during create Regions on DataNodes", (Throwable)e);
            }
            if (bitSet.cardinality() == regionNum) break;
        }
        if (bitSet.cardinality() < regionNum) {
            LOGGER.error("Failed to create some SchemaRegions or DataRegions on DataNodes. Please check former logs.");
        }
    }

    private TCreateSchemaRegionReq genCreateSchemaRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet) {
        TCreateSchemaRegionReq req = new TCreateSchemaRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        return req;
    }

    private void createSchemaRegion(TEndPoint endPoint, TCreateSchemaRegionReq req, CreateRegionHandler handler) {
        try {
            AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
            client.createSchemaRegion(req, (AsyncMethodCallback)handler);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to DataNode {}", (Object)endPoint, (Object)e);
        }
        catch (TException e) {
            LOGGER.error("Create SchemaRegion on DataNode {} failed", (Object)endPoint, (Object)e);
        }
    }

    private TCreateDataRegionReq genCreateDataRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet, long TTL) {
        TCreateDataRegionReq req = new TCreateDataRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        req.setTtl(TTL);
        return req;
    }

    public void createDataRegion(TEndPoint endPoint, TCreateDataRegionReq req, CreateRegionHandler handler) {
        try {
            AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
            client.createDataRegion(req, (AsyncMethodCallback)handler);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to DataNode {}", (Object)endPoint, (Object)e);
        }
        catch (TException e) {
            LOGGER.error("Create DataRegion on DataNode {} failed", (Object)endPoint, (Object)e);
        }
    }

    public void getDataNodeHeartBeat(TEndPoint endPoint, THeartbeatReq req, DataNodeHeartbeatHandler handler) {
        try {
            AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
            client.getDataNodeHeartBeat(req, (AsyncMethodCallback)handler);
        }
        catch (Exception e) {
            LOGGER.error("Asking DataNode: {}, for heartbeat failed", (Object)endPoint, (Object)e);
        }
    }

    public void resetClient(TEndPoint endPoint) {
        this.clientManager.clear((Object)endPoint);
    }

    public void createFunction(TEndPoint endPoint, TCreateFunctionRequest request, FunctionManagementHandler handler) {
        try {
            ((AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint)).createFunction(request, (AsyncMethodCallback)handler);
        }
        catch (Exception e) {
            LOGGER.error("Failed to asking DataNode to create function: {}", (Object)endPoint, (Object)e);
        }
    }

    public void dropFunction(TEndPoint endPoint, TDropFunctionRequest request, FunctionManagementHandler handler) {
        try {
            ((AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint)).dropFunction(request, (AsyncMethodCallback)handler);
        }
        catch (Exception e) {
            LOGGER.error("Failed to asking DataNode to create function: {}", (Object)endPoint, (Object)e);
        }
    }

    public void flush(TEndPoint endPoint, TFlushReq flushReq, FlushHandler handler) {
        for (int retry = 0; retry < 3; ++retry) {
            try {
                ((AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint)).flush(flushReq, (AsyncMethodCallback)handler);
                return;
            }
            catch (Exception e) {
                LOGGER.error("Failed to asking DataNode to flush: {}", (Object)endPoint, (Object)e);
                continue;
            }
        }
    }

    public static AsyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final AsyncDataNodeClientPool INSTANCE = new AsyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

