/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncConfigNodeIServiceClient;
import org.apache.iotdb.confignode.client.handlers.ConfigNodeHeartbeatHandler;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConfigNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncConfigNodeClientPool.class);
    private final IClientManager<TEndPoint, AsyncConfigNodeIServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.AsyncConfigNodeIServiceClientPoolFactory());

    private AsyncConfigNodeClientPool() {
    }

    public void getConfigNodeHeartBeat(TEndPoint endPoint, long timestamp, ConfigNodeHeartbeatHandler handler) {
        try {
            AsyncConfigNodeIServiceClient client = (AsyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)endPoint);
            client.getConfigNodeHeartBeat(timestamp, (AsyncMethodCallback)handler);
        }
        catch (Exception e) {
            LOGGER.error("Asking ConfigNode: {}, for heartbeat failed", (Object)endPoint, (Object)e);
        }
    }

    public static AsyncConfigNodeClientPool getInstance() {
        return AsyncConfigNodeClientPoolHolder.INSTANCE;
    }

    private static class AsyncConfigNodeClientPoolHolder {
        private static final AsyncConfigNodeClientPool INSTANCE = new AsyncConfigNodeClientPool();

        private AsyncConfigNodeClientPoolHolder() {
        }
    }
}

