/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(NodeUrlUtils.class);

    public static String convertTEndPointUrl(TEndPoint endPoint) {
        StringJoiner url = new StringJoiner(":");
        url.add(endPoint.getIp());
        url.add(String.valueOf(endPoint.getPort()));
        return url.toString();
    }

    public static String convertTEndPointUrls(List<TEndPoint> endPoints) {
        StringJoiner urls = new StringJoiner(",");
        for (TEndPoint endPoint : endPoints) {
            urls.add(NodeUrlUtils.convertTEndPointUrl(endPoint));
        }
        return urls.toString();
    }

    public static TEndPoint parseTEndPointUrl(String endPointUrl) throws BadNodeUrlException {
        TEndPoint result;
        String[] split = endPointUrl.split(":");
        if (split.length != 2) {
            logger.warn("Bad node url: {}", (Object)endPointUrl);
            throw new BadNodeUrlException(String.format("Bad node url: %s", endPointUrl));
        }
        String ip = split[0];
        try {
            int port = Integer.parseInt(split[1]);
            result = new TEndPoint(ip, port);
        }
        catch (NumberFormatException e) {
            logger.warn("Bad node url: {}", (Object)endPointUrl);
            throw new BadNodeUrlException(String.format("Bad node url: %s", endPointUrl));
        }
        return result;
    }

    public static List<TEndPoint> parseTEndPointUrls(List<String> endPointUrls) throws BadNodeUrlException {
        ArrayList<TEndPoint> result = new ArrayList<TEndPoint>();
        for (String url : endPointUrls) {
            result.add(NodeUrlUtils.parseTEndPointUrl(url));
        }
        return result;
    }

    public static List<TEndPoint> parseTEndPointUrls(String endPointUrls) throws BadNodeUrlException {
        return NodeUrlUtils.parseTEndPointUrls(Arrays.asList(endPointUrls.split(",")));
    }

    public static String convertTConfigNodeUrl(TConfigNodeLocation configNodeLocation) {
        StringJoiner url = new StringJoiner(",");
        url.add(String.valueOf(configNodeLocation.getConfigNodeId()));
        url.add(NodeUrlUtils.convertTEndPointUrl(configNodeLocation.getInternalEndPoint()));
        url.add(NodeUrlUtils.convertTEndPointUrl(configNodeLocation.getConsensusEndPoint()));
        return url.toString();
    }

    public static String convertTConfigNodeUrls(List<TConfigNodeLocation> configNodeLocations) {
        StringJoiner urls = new StringJoiner(";");
        for (TConfigNodeLocation configNodeLocation : configNodeLocations) {
            urls.add(NodeUrlUtils.convertTConfigNodeUrl(configNodeLocation));
        }
        return urls.toString();
    }

    public static TConfigNodeLocation parseTConfigNodeUrl(String configNodeUrl) throws BadNodeUrlException {
        String[] split = configNodeUrl.split(",");
        if (split.length != 3) {
            logger.warn("Bad ConfigNode url: {}", (Object)configNodeUrl);
            throw new BadNodeUrlException(String.format("Bad node url: %s", configNodeUrl));
        }
        return new TConfigNodeLocation(Integer.parseInt(split[0]), NodeUrlUtils.parseTEndPointUrl(split[1]), NodeUrlUtils.parseTEndPointUrl(split[2]));
    }

    public static List<TConfigNodeLocation> parseTConfigNodeUrls(List<String> configNodeUrls) throws BadNodeUrlException {
        ArrayList<TConfigNodeLocation> result = new ArrayList<TConfigNodeLocation>();
        for (String url : configNodeUrls) {
            result.add(NodeUrlUtils.parseTConfigNodeUrl(url));
        }
        return result;
    }

    public static List<TConfigNodeLocation> parseTConfigNodeUrls(String configNodeUrls) throws BadNodeUrlException {
        return NodeUrlUtils.parseTConfigNodeUrls(Arrays.asList(configNodeUrls.split(";")));
    }
}

