/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.BuiltinTimeSeriesGeneratingFunction;
import org.apache.iotdb.commons.udf.service.SnapshotUtils;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableResource;
import org.apache.iotdb.commons.udf.service.UDFLogWriter;
import org.apache.iotdb.commons.udf.service.UDFRegistrationInformation;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.udf.api.UDF;
import org.apache.iotdb.udf.api.exception.UDFRegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFRegistrationService
implements IService,
SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFRegistrationService.class);
    private final String ulogFileDir;
    private final String logFileName;
    private final String temporaryLogFileName;
    private final ReentrantLock registrationLock;
    private ConcurrentHashMap<String, UDFRegistrationInformation> registrationInformation;
    private final ReentrantReadWriteLock logWriterLock;
    private UDFLogWriter logWriter;
    private static UDFRegistrationService INSTANCE = null;

    private UDFRegistrationService(String ulogFileDir) {
        this.ulogFileDir = ulogFileDir;
        this.logFileName = ulogFileDir + "ulog.txt";
        this.temporaryLogFileName = this.logFileName + ".tmp";
        this.registrationLock = new ReentrantLock();
        this.registrationInformation = new ConcurrentHashMap();
        this.logWriterLock = new ReentrantReadWriteLock();
    }

    public void acquireRegistrationLock() {
        this.registrationLock.lock();
    }

    public void releaseRegistrationLock() {
        this.registrationLock.unlock();
    }

    public void validate(String functionName, String className) {
        functionName = functionName.toUpperCase();
        UDFRegistrationService.validateFunctionName(functionName, className);
        this.checkIfRegistered(functionName, className);
    }

    public void register(String functionName, String className, boolean writeToTemporaryLogFile) throws UDFRegistrationException {
        functionName = functionName.toUpperCase();
        UDFRegistrationService.validateFunctionName(functionName, className);
        this.checkIfRegistered(functionName, className);
        this.doRegister(functionName, className, Collections.emptyList());
        this.tryAppendRegistrationLog(functionName, className, Collections.emptyList(), writeToTemporaryLogFile);
    }

    public void register(String functionName, String className, List<String> uris, UDFExecutableManager udfExecutableManager, boolean writeToTemporaryLogFile) throws UDFRegistrationException {
        functionName = functionName.toUpperCase();
        UDFRegistrationService.validateFunctionName(functionName, className);
        this.checkIfRegistered(functionName, className);
        this.downloadExecutableResources(functionName, className, uris, udfExecutableManager);
        this.doRegister(functionName, className, uris);
        this.tryAppendRegistrationLog(functionName, className, uris, writeToTemporaryLogFile);
    }

    private static void validateFunctionName(String functionName, String className) throws UDFRegistrationException {
        if (!BuiltinAggregationFunction.getNativeFunctionNames().contains(functionName.toLowerCase())) {
            return;
        }
        String errorMessage = String.format("Failed to register UDF %s(%s), because the given function name conflicts with the built-in function name", functionName, className);
        LOGGER.warn(errorMessage);
        throw new UDFRegistrationException(errorMessage);
    }

    private void checkIfRegistered(String functionName, String className) throws UDFRegistrationException {
        UDFRegistrationInformation information = this.registrationInformation.get(functionName);
        if (information == null) {
            return;
        }
        String errorMessage = information.isBuiltin() ? String.format("Failed to register UDF %s(%s), because the given function name is the same as a built-in UDF function name.", functionName, className) : (information.getClassName().equals(className) ? String.format("Failed to register UDF %s(%s), because a UDF %s(%s) with the same function name and the class name has already been registered.", functionName, className, information.getFunctionName(), information.getClassName()) : String.format("Failed to register UDF %s(%s), because a UDF %s(%s) with the same function name but a different class name has already been registered.", functionName, className, information.getFunctionName(), information.getClassName()));
        LOGGER.warn(errorMessage);
        throw new UDFRegistrationException(errorMessage);
    }

    private void downloadExecutableResources(String functionName, String className, List<String> uris, UDFExecutableManager udfExecutableManager) throws UDFRegistrationException {
        if (uris.isEmpty()) {
            return;
        }
        try {
            UDFExecutableResource resource = udfExecutableManager.request(uris);
            try {
                udfExecutableManager.removeFromExtLibDir(functionName);
                udfExecutableManager.moveToExtLibDir(resource, functionName);
            }
            catch (Exception innerException) {
                udfExecutableManager.removeFromExtLibDir(functionName);
                udfExecutableManager.removeFromTemporaryLibRoot(resource);
                throw innerException;
            }
        }
        catch (Exception outerException) {
            String errorMessage = String.format("Failed to register UDF %s(%s) because failed to fetch UDF executables(%s)", functionName, className, uris);
            LOGGER.warn(errorMessage, (Throwable)outerException);
            throw new UDFRegistrationException(errorMessage, (Throwable)outerException);
        }
    }

    private void doRegister(String functionName, String className, List<String> uris) throws UDFRegistrationException {
        this.acquireRegistrationLock();
        try {
            UDFClassLoader currentActiveClassLoader = UDFClassLoaderManager.getInstance().updateAndGetActiveClassLoader();
            this.updateAllRegisteredClasses(currentActiveClassLoader);
            Class<?> functionClass = Class.forName(className, true, currentActiveClassLoader);
            functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.registrationInformation.put(functionName, new UDFRegistrationInformation(functionName, className, uris, false, functionClass));
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to register UDF %s(%s), because its instance can not be constructed successfully. Exception: %s", functionName, className, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new UDFRegistrationException(errorMessage);
        }
        finally {
            this.releaseRegistrationLock();
        }
    }

    private void tryAppendRegistrationLog(String functionName, String className, List<String> uris, boolean writeToTemporaryLogFile) throws UDFRegistrationException {
        if (!writeToTemporaryLogFile) {
            return;
        }
        try {
            this.appendRegistrationLog(functionName, className, uris);
        }
        catch (IOException e) {
            this.registrationInformation.remove(functionName);
            String errorMessage = String.format("Failed to append UDF log when registering UDF %s(%s), because %s", functionName, className, e);
            LOGGER.error(errorMessage);
            throw new UDFRegistrationException(errorMessage, (Throwable)e);
        }
    }

    private void updateAllRegisteredClasses(UDFClassLoader activeClassLoader) throws ClassNotFoundException {
        for (UDFRegistrationInformation information : this.getRegistrationInformation()) {
            if (information.isBuiltin()) continue;
            information.updateFunctionClass(activeClassLoader);
        }
    }

    public void deregister(String functionName) throws UDFRegistrationException {
        UDFRegistrationInformation information = this.registrationInformation.get(functionName = functionName.toUpperCase());
        if (information == null) {
            String errorMessage = String.format("UDF %s does not exist.", functionName);
            LOGGER.warn(errorMessage);
            throw new UDFRegistrationException(errorMessage);
        }
        if (information.isBuiltin()) {
            String errorMessage = String.format("Built-in function %s can not be deregistered.", functionName);
            LOGGER.warn(errorMessage);
            throw new UDFRegistrationException(errorMessage);
        }
        try {
            this.appendDeregistrationLog(functionName);
            this.registrationInformation.remove(functionName);
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to append UDF log when deregistering UDF %s, because %s", functionName, e);
            LOGGER.error(errorMessage);
            throw new UDFRegistrationException(errorMessage, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRegistrationLog(String functionName, String className, List<String> uris) throws IOException {
        this.logWriterLock.writeLock().lock();
        try {
            this.logWriter.register(functionName, className, uris);
        }
        finally {
            this.logWriterLock.writeLock().unlock();
        }
    }

    private void appendDeregistrationLog(String functionName) throws IOException {
        this.logWriterLock.writeLock().lock();
        try {
            this.logWriter.deregister(functionName);
        }
        finally {
            this.logWriterLock.writeLock().unlock();
        }
    }

    public UDF reflect(String functionName) {
        UDFRegistrationInformation information = this.registrationInformation.get(functionName = functionName.toUpperCase());
        if (information == null) {
            String errorMessage = String.format("Failed to reflect UDF instance, because UDF %s has not been registered.", functionName);
            LOGGER.warn(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        if (!information.isBuiltin()) {
            Thread.currentThread().setContextClassLoader(UDFClassLoaderManager.getInstance().getActiveClassLoader());
        }
        try {
            return (UDF)information.getFunctionClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to reflect UDF %s(%s) instance, because %s", functionName, information.getClassName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage);
        }
    }

    public UDFRegistrationInformation[] getRegistrationInformation() {
        return this.registrationInformation.values().toArray(new UDFRegistrationInformation[0]);
    }

    @Override
    public void start() throws StartupException {
        try {
            this.recovery();
        }
        catch (Exception e) {
            throw new StartupException(e);
        }
    }

    private void recovery() throws Exception {
        this.registrationInformation = new ConcurrentHashMap();
        this.registerBuiltinTimeSeriesGeneratingFunctions();
        this.makeDirIfNecessary();
        this.doRecovery();
        this.logWriter = new UDFLogWriter(this.logFileName);
    }

    private void registerBuiltinTimeSeriesGeneratingFunctions() {
        for (BuiltinTimeSeriesGeneratingFunction builtinTimeSeriesGeneratingFunction : BuiltinTimeSeriesGeneratingFunction.values()) {
            String functionName = builtinTimeSeriesGeneratingFunction.getFunctionName();
            this.registrationInformation.put(functionName, new UDFRegistrationInformation(functionName, builtinTimeSeriesGeneratingFunction.getClassName(), Collections.emptyList(), true, builtinTimeSeriesGeneratingFunction.getFunctionClass()));
        }
    }

    private void makeDirIfNecessary() throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(this.ulogFileDir);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    private void doRecovery() throws IOException {
        File temporaryLogFile = SystemFileFactory.INSTANCE.getFile(this.temporaryLogFileName);
        File logFile = SystemFileFactory.INSTANCE.getFile(this.logFileName);
        if (temporaryLogFile.exists()) {
            if (logFile.exists()) {
                this.recoveryFromLogFile(logFile);
                FileUtils.deleteQuietly((File)temporaryLogFile);
            } else {
                this.recoveryFromLogFile(temporaryLogFile);
                FSFactoryProducer.getFSFactory().moveFile(temporaryLogFile, logFile);
            }
        } else if (logFile.exists()) {
            this.recoveryFromLogFile(logFile);
        }
    }

    private void recoveryFromLogFile(File logFile) throws IOException {
        HashMap<String, String> recoveredUDFs = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] data = line.split(",");
                byte type = Byte.parseByte(data[0]);
                if (type == UDFLogWriter.REGISTER_WITHOUT_URIS_TYPE || type == UDFLogWriter.REGISTER_WITH_URIS_TYPE) {
                    recoveredUDFs.put(data[1], data[2]);
                    continue;
                }
                if (type == UDFLogWriter.DEREGISTER_TYPE) {
                    recoveredUDFs.remove(data[1]);
                    continue;
                }
                throw new UnsupportedEncodingException();
            }
        }
        for (Map.Entry udf : recoveredUDFs.entrySet()) {
            try {
                this.register((String)udf.getKey(), (String)udf.getValue(), false);
            }
            catch (UDFRegistrationException uDFRegistrationException) {}
        }
    }

    @Override
    public void stop() {
        try {
            this.writeTemporaryLogFile();
            this.logWriter.close();
            this.logWriter.deleteLogFile();
            File temporaryLogFile = SystemFileFactory.INSTANCE.getFile(this.temporaryLogFileName);
            File logFile = SystemFileFactory.INSTANCE.getFile(this.logFileName);
            FSFactoryProducer.getFSFactory().moveFile(temporaryLogFile, logFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeTemporaryLogFile() throws IOException {
        UDFLogWriter temporaryLogFile = new UDFLogWriter(this.temporaryLogFileName);
        for (UDFRegistrationInformation information : this.registrationInformation.values()) {
            if (information.isBuiltin()) continue;
            temporaryLogFile.register(information.getFunctionName(), information.getClassName(), information.getUris());
        }
        temporaryLogFile.close();
    }

    public void deregisterAll() throws UDFRegistrationException {
        for (UDFRegistrationInformation information : this.getRegistrationInformation()) {
            if (information.isBuiltin()) continue;
            this.deregister(information.getFunctionName());
        }
    }

    public void registerBuiltinFunction(String functionName, String className) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> functionClass = Class.forName(className, true, classLoader);
        functionName = functionName.toUpperCase();
        this.registrationInformation.put(functionName, new UDFRegistrationInformation(functionName, className, Collections.emptyList(), true, functionClass));
    }

    public void deregisterBuiltinFunction(String functionName) {
        this.registrationInformation.remove(functionName.toUpperCase());
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UDF_REGISTRATION_SERVICE;
    }

    public static synchronized UDFRegistrationService setupAndGetInstance(String ulogFileDir) {
        if (INSTANCE == null) {
            INSTANCE = new UDFRegistrationService(ulogFileDir);
        }
        return INSTANCE;
    }

    public static UDFRegistrationService getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return SnapshotUtils.takeSnapshotForDir(this.ulogFileDir, snapshotDir.getAbsolutePath() + File.separator + "udf");
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        SnapshotUtils.loadSnapshotForDir(snapshotDir.getAbsolutePath() + File.separator + "udf", this.ulogFileDir);
        try {
            this.recovery();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

