/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;

public abstract class SeriesPartitionExecutor {
    protected final int seriesPartitionSlotNum;

    public SeriesPartitionExecutor(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public abstract TSeriesPartitionSlot getSeriesPartitionSlot(String var1);

    public static SeriesPartitionExecutor getSeriesPartitionExecutor(String executorName, int seriesPartitionSlotNum) {
        try {
            Class<?> executor = Class.forName(executorName);
            Constructor<?> executorConstructor = executor.getConstructor(Integer.TYPE);
            return (SeriesPartitionExecutor)executorConstructor.newInstance(seriesPartitionSlotNum);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Couldn't Constructor SeriesPartitionExecutor class: %s", executorName));
        }
    }
}

