/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDescriptor.class);
    private final CommonConfig config = new CommonConfig();

    private CommonDescriptor() {
    }

    public static CommonDescriptor getInstance() {
        return CommonDescriptorHolder.INSTANCE;
    }

    public CommonConfig getConfig() {
        return this.config;
    }

    public void initCommonConfigDir(String systemDir) {
        this.config.setUserFolder(systemDir + File.separator + "users");
        this.config.setRoleFolder(systemDir + File.separator + "roles");
        this.config.setProcedureWalFolder(systemDir + File.separator + "procedure");
    }

    public void loadCommonProps(Properties properties) {
        this.config.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.config.getAuthorizerProvider()));
        this.config.setOpenIdProviderUrl(properties.getProperty("openID_url", this.config.getOpenIdProviderUrl()));
        this.config.setAdminName(properties.getProperty("admin_name", this.config.getAdminName()));
        this.config.setAdminPassword(properties.getProperty("admin_password", this.config.getAdminPassword()));
        this.config.setEncryptDecryptProvider(properties.getProperty("iotdb_server_encrypt_decrypt_provider", this.config.getEncryptDecryptProvider()));
        this.config.setEncryptDecryptProviderParameter(properties.getProperty("iotdb_server_encrypt_decrypt_provider_parameter", this.config.getEncryptDecryptProviderParameter()));
        this.config.setDefaultTTL(Long.parseLong(properties.getProperty("default_ttl", String.valueOf(this.config.getDefaultTTL()))));
    }

    private static class CommonDescriptorHolder {
        private static final CommonDescriptor INSTANCE = new CommonDescriptor();

        private CommonDescriptorHolder() {
        }
    }
}

