/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import org.apache.iotdb.tsfile.fileSystem.FSType;

public class CommonConfig {
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.commons.auth.authorizer.LocalFileAuthorizer";
    private String encryptDecryptProvider = "org.apache.iotdb.commons.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private String adminName = "root";
    private String adminPassword = "root";
    private String userFolder = "data" + File.separator + "system" + File.separator + "users";
    private String roleFolder = "data" + File.separator + "system" + File.separator + "roles";
    private String procedureWalFolder = "data" + File.separator + "system" + File.separator + "procedure";
    private FSType systemFileStorageFs = FSType.LOCAL;
    private long defaultTTL = Long.MAX_VALUE;

    CommonConfig() {
    }

    public void updatePath(String homeDir) {
        this.userFolder = this.addHomeDir(this.userFolder, homeDir);
        this.roleFolder = this.addHomeDir(this.roleFolder, homeDir);
        this.procedureWalFolder = this.addHomeDir(this.procedureWalFolder, homeDir);
    }

    private String addHomeDir(String dir, String homeDir) {
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    public String getRoleFolder() {
        return this.roleFolder;
    }

    public void setRoleFolder(String roleFolder) {
        this.roleFolder = roleFolder;
    }

    public String getProcedureWalFolder() {
        return this.procedureWalFolder;
    }

    public void setProcedureWalFolder(String procedureWalFolder) {
        this.procedureWalFolder = procedureWalFolder;
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(FSType systemFileStorageFs) {
        this.systemFileStorageFs = systemFileStorageFs;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }
}

