/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.client.BaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.thrift.async.TAsyncClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncBaseClientFactory<K, V>
extends BaseClientFactory<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncBaseClientFactory.class);
    protected TAsyncClientManager[] tManagers;
    protected AtomicInteger clientCnt = new AtomicInteger();

    protected AsyncBaseClientFactory(ClientManager<K, V> clientManager, ClientFactoryProperty clientFactoryProperty) {
        super(clientManager, clientFactoryProperty);
        this.tManagers = new TAsyncClientManager[clientFactoryProperty.getSelectorNumOfAsyncClientPool()];
        for (int i = 0; i < this.tManagers.length; ++i) {
            try {
                this.tManagers[i] = new TAsyncClientManager();
                continue;
            }
            catch (IOException e) {
                logger.error("Cannot create Async client factory", (Throwable)e);
            }
        }
    }
}

